# Data description

## Hourly Ambulance Call Data

- **Files**: `2019-first-heatwave-extra-week.csv.gz` and `2019-summer.csv.gz`
- **Description**: These datasets contain detailed ambulance call data for a specific period in summer 2019, including the first heatwave and an additional week. The data is recorded at an individual call level with temporal and spatial information.
- **Attributes**:
  - **`pmeId`**: Unique identifier for each ambulance call.
  - **`pmeTimeStamp`**: Timestamp of the ambulance call.
  - **`pmeLat`**: Latitude coordinate of the ambulance call location.
  - **`pmeLon`**: Longitude coordinate of the ambulance call location.
  - *Note*: Additional columns are present in the dataset but are not used in the current analysis.

## District-Level Data

- **Files**: `districts.csv` or `neighborhoods.csv`
- **Description**: This dataset combines district-level socio-demographic data, Urban Heat Island (UHI) effect data, and health data on the district or neighborhood scale for each of the case cities. It is used for urban heat vulnerability analysis.
- **Attributes**:
  - **gwb_code_10**: district or neighborhood code
  - **Age Groups**: '0-14', '15-24', '25-44', '45-64', '65+'
  - **Ethnicity**: 'Dutch', 'Western migr.', 'non-Western migr.'
  - **Household Composition**: 'Single pers. HH', 'HH w/o children', 'HH w children'
  - **Education**: 'Low edu.', 'Mid edu.', 'High edu.'
  - **Income**: '40% low income HH', '20% high income HH'
  - **Health**: 'Sv. lim. due to health', 'Mob. issues'
  - **Adaptive Capacity**: 'Srs. or very srs. lonely'
  - **Urban Heat Island**: 'UHI'

*Note: For the original names of the features, please refer to the original data sources.*

## Temperature Data

- **File**: Not specified
- **Attributes**:
  - **`temperature`**: Information about temperature measurements
  - **`time`**: Timestamp for temperature recordings
  - *Note*: Additional columns are present in the dataset but are not used in the current analysis.

For detailed information on data sources and methodologies, please refer to the official documentation on the dedicated web pages.
