function derr = errorCp(d1cSensors,staf)
if length(unique(d1cSensors)) ~= length(d1cSensors)
    derr = 1e6;
    return;
end
d1cSensors = sort(d1cSensors);

d1prob = staf.d1prob;

[~,iLEairfoil] = min(staf.d2geom(:,1));
d1cCp = [1 - staf.d2geom(1:iLEairfoil,1);1 + staf.d2geom(iLEairfoil+1:end,1)];
d2cpExp = staf.d2cp(2:end,2:end);

d2cpSensors = interp1(d1cCp,staf.d2cp(2:end,2:end)',d1cSensors');
d2cpInterp = interp1(d1cSensors',d2cpSensors,d1cCp,'linear','extrap')';

d1err = trapz(d1cCp,abs(d2cpInterp - d2cpExp),2).*d1prob;
derr = sum(d1err);
end