function d2polars = polarsFromCp(d2Airfoil,d2Cp,d1AoA)
%Function retrieves the local cl distribution based on the airfoil
%geometry, the cp distribution (as obtained using e.g. XFOIL) and the angle
%of attack (in degrees)

d2dsUp = circshift(d2Airfoil,[-1,0])-d2Airfoil;
d2dsDown = d2Airfoil - circshift(d2Airfoil,[1,0]);

d1dA = 0.5*(sqrt(d2dsUp(:,1).^2+d2dsUp(:,2).^2)+sqrt(d2dsDown(:,1).^2+d2dsDown(:,2).^2));
d1dA(1) = d1dA(2);
d1dA(end) = d1dA(end-1);

d2n = [d2dsUp(:,2),-d2dsUp(:,1)]+[d2dsDown(:,2),-d2dsDown(:,1)];
d2n(1,:) = d2n(2,:);
d2n(end,:) = d2n(end-1,:);
d2nNorm = [d2n(:,1)./sqrt(d2n(:,1).^2+d2n(:,2).^2) , d2n(:,2)./sqrt(d2n(:,1).^2+d2n(:,2).^2)];

d2Cl = -d1dA.*d2Cp.*(d2nNorm(:,2)*cosd(d1AoA') - d2nNorm(:,1)*sind(d1AoA'));
d1Cl = sum(d2Cl,1)';

d2Cdp = -d1dA.*d2Cp.*(d2nNorm(:,2)*sind(d1AoA') + d2nNorm(:,1)*cosd(d1AoA'));
d1Cdp = sum(d2Cdp,1)';

d2Cm = -d1dA.*d2Cp.*(d2nNorm(:,2).*(0.25 - d2Airfoil(:,1)) + d2nNorm(:,1).*d2Airfoil(:,2));
d1Cm = sum(d2Cm,1)';

d2polars = [d1AoA,d1Cl,d1Cdp,d1Cm];
end