#!/usr/bin/env bash

ALP=alpinist
VCT=vercors
STD_FLAGS="--silicon --progress"
EXMPL_DIR=Alpinist-Examples
CALCS=scripts/calcs.py
TABLE=scripts/format_table_2.py
LOG=table_2.log

if [ -z "$1" ]
then
	NEXP=1
	echo All experiments are run once
else 
	NEXP=$1
	echo All experiments are run $1 times
fi

source scripts/evaluation_helper.sh

echo "Generating Table 2 of the paper \"Alpinist: an Annotation-Aware GPU Program Optimizer\""
echo "" > $LOG
table_entries=()

EXPERIMENTS=( 	"loop_unroll/sortingalgorithms/bubblesort" "iteration_merging/sortingalgorithms/bubblesort" "loop_unroll/sortingalgorithms/insertionsort" "iteration_merging/sortingalgorithms/insertionsort" "loop_unroll/sortingalgorithms/selectionsort" "iteration_merging/sortingalgorithms/selectionsort" "loop_unroll/sortingalgorithms/timsort1" "iteration_merging/sortingalgorithms/timsort1" "loop_unroll/PrefixSumBlelloch" "iteration_merging/PrefixSumBlelloch" "loop_unroll/PrefixSumKoggeStone" "iteration_merging/PrefixSumKoggeStone" "data_prefetch/PrefixSumKoggeStone" "loop_unroll/MatrixGrid" "iteration_merging/MatrixGrid" "loop_unroll/verifythis/2019/Challenge1" "matrix_linearization/SAT_Transpose_Kernel" )
FLAG=( "loop_unroll" "iter_merge"  "loop_unroll" "iter_merge"  "loop_unroll" "iter_merge"  "loop_unroll" "iter_merge"  "loop_unroll" "iter_merge"  "loop_unroll" "iter_merge" "glob_to_reg" "loop_unroll" "iter_merge"  "loop_unroll" "matrix_lin" )
PASS=( "unrollLoops" "mergeLoopIterations" "unrollLoops" "mergeLoopIterations" "unrollLoops" "mergeLoopIterations" "unrollLoops" "mergeLoopIterations" "unrollLoops" "mergeLoopIterations" "unrollLoops" "mergeLoopIterations" "globalMemoryLocToRegister"  "unrollLoops" "mergeLoopIterations" "unrollLoops" "linearizeMatrices" )
len=${#EXPERIMENTS[@]}

#for i in {0..$len}; do 
for ((i=0;i<$len;i++)); do
	echo $(($i+1))/$len - Applying ${FLAG[$i]} on ${EXPERIMENTS[$i]}
	times=`run_example $EXMPL_DIR/${EXPERIMENTS[$i]} ${FLAG[$i]} ${PASS[$i]} $LOG`
	#echo $times
	echo " - done" 
	opt=(`echo $times | cut -f2 -d " "`)
	before=(`echo $times | cut -f1 -d " "`)
	after=(`echo $times | cut -f3 -d " "`)
	table_entries+=( $opt $before $after)
done

echo ""
python3 $TABLE ${table_entries[@]}
