#!/usr/bin/env bash

ALP=alpinist
VCT=vercors
STD_FLAGS="--silicon --progress"
EXMPL_DIR=Alpinist-Examples
CALCS=scripts/calcs.py
TABLE=scripts/format_table_1.py
LOG=table_1.log

if [ -z "$1" ]
then
	NEXP=1
	echo All experiments are run once
else 
	NEXP=$1
	echo All experiments are run $1 times
fi

if [ -z "$2" ]
then
	OPTS=( "loop_unroll" "tiling" "kernel_fusion" "iteration_merging" "matrix_linearization" "data_prefetch" )
	echo All optimizations are run
else 
	OPTS=(`echo $2 | tr "," " "`)
	for o in ${OPTS[@]}; do
		if [ -d $EXMPL_DIR/$o ];
		then
			true
			#echo $opt is a directory, go ahead
		else 
			echo "The directory " $EXMPL_DIR/$o " does not exists"
			exit 1
		fi
	done
	echo Only the optimizations \' ${OPTS[@]} \' are ran
fi

source scripts/evaluation_helper.sh

echo "Generating Table 1 of the paper \"Alpinist: an Annotation-Aware GPU Program Optimizer\""
echo "Generating Table 1 for the optimizations ${OPTS[@]}"

function progressbar() {
	curr=$1
	total=$2
	bar="\r_ "
	for ((i=0;i<$curr;i++)); do
		bar+="#"
	done
	(( rest =  total - curr ))
	for ((j=0;j<$rest;j++)); do
		bar+="."
	done

	bar+=" _ $(($curr+1))/$total"
	echo -ne $bar
}

echo "" > $LOG

table_entries=()
for opt in ${OPTS[@]}; do
	EXPERIMENTS=($(find $EXMPL_DIR/$opt -type d -links 2))
	NEXPERIMENTS=${#EXPERIMENTS[@]}
	FLAG=$(get_flag $opt)
	PASS=$(get_pass $opt)

	echo Applying $opt with flag $(get_flag $opt) to $NEXPERIMENTS examples
	i=0
	opt_times=()
	before_times=()
	after_times=()
	for exp in ${EXPERIMENTS[@]}; do
		#echo $exp
		echo -e `progressbar $i $NEXPERIMENTS`
		i=$(( $i+1 ))
		times=`run_example $exp $FLAG $PASS $LOG`
		opt_times+=(`echo $times | cut -f2 -d " "`)
		before_times+=(`echo $times | cut -f1 -d " "`)
		after_times+=(`echo $times | cut -f3 -d " "`)
	done
	echo -e `progressbar $NEXPERIMENTS $NEXPERIMENTS`
	echo " - done "

	agg_opt=`python3 $CALCS ${opt_times[@]}`
	agg_before=`python3 $CALCS ${before_times[@]}`
	agg_after=`python3 $CALCS ${after_times[@]}`

	table_entries+=($opt $agg_opt $agg_before $agg_after)
done

python3 $TABLE ${table_entries[@]}

