import sys
from beautifultable import BeautifulTable

def isFloat(v):
    try:
        float(v)
        return True
    except ValueError:
        return False

args=sys.argv[1:]
# OPT min max avg med min max avg med min max avg med 
opts=["{:.3f}".format(float(o)/1000) if isFloat(o) else o for o in args]

table=BeautifulTable(maxwidth=120)
table.columns.header=["","LU","","","IM","","","ML","","", "DP","",""]

table.rows.append(["Case" ,"OT","VB","VA", "OT","VB","VA","OT","VB","VA","OT","VB","VA"])


table.rows.append(["BubbleSort" ,
    opts[0],opts[1],opts[2], 
    opts[3],opts[4],opts[5],
    "N/A","N/A","N/A",
    "N/A","N/A","N/A"])
table.rows.append(["InsertionSort" ,
    opts[6],opts[7],opts[8], 
    opts[9],opts[10],opts[11],
    "N/A","N/A","N/A",
    "N/A","N/A","N/A"])
table.rows.append(["SelectionSort" ,
    opts[12],opts[13],opts[14], 
    opts[15],opts[16],opts[17],
    "N/A","N/A","N/A",
    "N/A","N/A","N/A"])
table.rows.append(["TimSort" ,
    opts[18],opts[19],opts[20], 
    opts[21],opts[22],opts[23],
    "N/A","N/A","N/A",
    "N/A","N/A","N/A"])
table.rows.append(["Blelloch" ,
    opts[24],opts[25],opts[26], 
    opts[27],opts[28],opts[29],
    "N/A","N/A","N/A",
    "N/A","N/A","N/A"])
table.rows.append(["Kogge-Stone",
    opts[30],opts[31],opts[32], 
    opts[33],opts[34],opts[35],
    "N/A","N/A","N/A", 
    opts[36],opts[37],opts[38]])
table.rows.append(["TicTacToe" ,
    opts[39],opts[40],opts[41], 
    opts[42],opts[43],opts[44],
    "N/A","N/A","N/A",
    "N/A","N/A","N/A"])
table.rows.append(["VerifyThis",
    opts[45],opts[46],opts[47], 
    "N/A","N/A","N/A",
    "N/A","N/A","N/A",
    "N/A","N/A","N/A"])
table.rows.append(["Transpose" ,
    "N/A","N/A","N/A", 
    "N/A","N/A","N/A",
    opts[48],opts[49],opts[50],
    "N/A","N/A","N/A"])

print(table)
