import sys
from beautifultable import BeautifulTable

def isFloat(v):
    try:
        float(v)
        return True
    except ValueError:
        return False

chunk=13
args=sys.argv[1:]
# OPT min max avg med min max avg med min max avg med 
opts=["{:.3f}".format(float(o)/1000) if isFloat(o) else o for o in args]
opts=[opts[i:i+chunk] for i in range(0, len(opts), chunk)]


table=BeautifulTable(maxwidth=120)
table.columns.header=["","Opt (s)","","","","V.orig (s)","","","","V.opt (s)","","",""]

table.rows.append(["Optimization" ,"Min","Max","Avg","Med","Min","Max","Avg","Med","Min","Max","Avg","Med"])

for opt in opts:
    table.rows.append(opt)

print(table)
