function get_flag() {
	case $1 in
	data_prefetch)
		echo "glob_to_reg" 
	;;

	iteration_merging)
		echo "iter_merge" 
	;;
	kernel_fusion)
		echo "fuse"
	;;
	loop_unroll)
		echo "loop_unroll"
	;;
	matrix_linearization)
		echo "matrix_lin"
	;;
	tiling)
		echo "tile" 
	;;
	*)
		echo $1 unknown optimization
		exit 1
	;;
	esac

	return 0
}	

function get_pass() {
	case $1 in
	data_prefetch)
		echo "globalMemoryLocToRegister" 
	;;

	iteration_merging)
		echo "mergeLoopIterations" 
	;;
	kernel_fusion)
		echo "fuseKernels"
	;;
	loop_unroll)
		echo "unrollLoops"
	;;
	matrix_linearization)
		echo "linearizeMatrices"
	;;
	tiling)
		echo "tileKernel" 
	;;
	*)
		echo $1 unknown optimization
		exit 1
	;;
	esac

	return 0
}

function get_pass_by_flag() {
	case $1 in
	glob_to_reg)
		echo "globalMemoryLocToRegister" 
	;;

	iter_merge)
		echo "mergeLoopIterations" 
	;;
	fuse)
		echo "fuseKernels"
	;;
	loop_unroll)
		echo "unrollLoops"
	;;
	matrix_lin)
		echo "linearizeMatrices"
	;;
	tile)
		echo "tileKernel" 
	;;
	*)
		echo $1 unknown optimization
		exit 1
	;;
	esac

	return 0
}

function get_verification_time() {
	dir=$1
	opt=$2
	pass=$3
	log=$4
	echo "-- verifying the original code" >&2
	before_output=`$VCT $STD_FLAGS $dir/orig_* 2>/dev/null | tee -a $log | awk '/entire run took/{split($0,a);print a[5]}'`
	echo "-- optimizing the original code" >&2
	opt_output=`$ALP $STD_FLAGS $dir/orig_* --encoded-gpuopt opt_tmp.pvl --gpuopt $opt 2>/dev/null | tee -a $log |awk '/'${pass}'/{split($0, a);print a[5]}'`
	echo "-- verifying the optimized code" >&2
	after_output=`$VCT $STD_FLAGS opt_tmp.pvl 2>/dev/null | tee -a $log | awk '/entire run took/{split($0, a); print a[5]}'`
	echo $before_output $opt_output $after_output
}

function run_example(){
	dir=$1
	opt_flag=$2
	pass=$3
	log=$4
	
	time_opt=()
	time_before=()
	time_after=()
	for i in `seq 1 $NEXP`; do
		echo "- run nr. $i" >&2
		output=`get_verification_time $dir $opt_flag $pass $log`
		#echo $output
		time_opt+=(`echo $output | cut -f2 -d " "`)
		time_before+=(`echo $output | cut -f1 -d " "`)
		time_after+=(`echo $output | cut -f3 -d " "`)
		#echo opt ${time_opt[@]} >&2
		#echo before ${time_before[@]} >&2
		#echo after ${time_after[@]} after >&2
	done
	avg_opt=`python3 $CALCS ${time_opt[@]} | cut -f5 -d " "`
	avg_before=`python3 $CALCS ${time_before[@]} | cut -f5 -d " "`
	avg_after=`python3 $CALCS ${time_after[@]} | cut -f5 -d " "`
	echo $avg_before $avg_opt $avg_after
}


