#!/usr/bin/env bash

ALP=alpinist
VCT=vercors
STD_FLAGS="--silicon --progress"
EXMPL_DIR=Alpinist-Examples
CALCS=scripts/calcs.py
TABLE=scripts/format_runN.py
LOG=runN.log
source scripts/evaluation_helper.sh

if [ -z "$1" ]
then
	echo usage: run.sh "<run X times> <dir> <opt>"
	exit 1
else 
	NEXP=$1	
fi

if [ -z "$2" ]
then
	echo usage: run.sh "<run X times> <dir> <opt>"
	exit 1
else
		if [ -d $2 ];
		then
			exp=$2
			#echo $opt is a directory, go ahead
		else 
			echo $2 " is not a directory"
			exit 1
		fi
fi

if [ -z "$3" ]
then
	echo usage: runN.sh "<run X times> <dir> <opt>"
	exit 1
else
	FLAG=$3
	PASS=`get_pass_by_flag $FLAG`
fi


echo "Optimizing $exp $NEXP time(s) with optimization $FLAG"

echo "" > $LOG

times=`run_example $exp $FLAG $PASS $LOG`
opt_time=(`echo $times | cut -f2 -d " "`)
before_time=(`echo $times | cut -f1 -d " "`)
after_time=(`echo $times | cut -f3 -d " "`)

python3 $TABLE $before_time $opt_time $after_time

