% settings_material.m

% *************************************************************************

% Settings File - Simulation Material Properties
% Define default settings
% All physical properties - won't change until changing materials

% ALL CAPITAL VARIABLES NEVER CHANGE IN LOOPS

% Units are all in International System of Units (SI)

% *************************************************************************

% -------------------------------------------------------------------------

% Load All Physical Constants
% settings_physical
% settings_physical.m

% *************************************************************************

% Settings File - Some Relative Physical Constants
% Define default settings
% All physical constants - Never Change

% ALL CAPITAL VARIABLES NEVER CHANGE IN LOOPS

% Units are all in International System of Units (SI)

% *************************************************************************

% Faraday Constant
FARADAY = 96487;        % [UNIT: C/mol]

% Ideal Gas Constant
RU = 8.314;             % [UNIT: J/mol/K]

% DONE***DONE***DONE***DONE***DONE***DONE***DONE***DONE***DONE***DONE***DONE

% -------------------------------------------------------------------------

% Volume Fractions, ie. porosity

porosity_n = 0.21;%0.332;         % Porosity Coefficient of NEGATIVE Electrode [Dimensionless]
porosity_s = 0.500;         % Porosity Coefficient of NEGATIVE Electrode [Dimensionless]
porosity_p = 0.25;%0.330;         % Porosity Coefficient of POSITIVE Electrode [Dimensionless]

% -------------------------------------------------------------------------

% Volume Fraction of Active Particles in Electrodes

poroActive_n = 0.58;        % Porosity of Active in NEGATIVE Electrode [Dimensionless]
poroActive_p = 0.50;        % Porosity of Active in POSITIVE Electrode [Dimensionless]

% -------------------------------------------------------------------------

% diffusion Coefficient

diffu =1.6595e-11;%4.8473e-11;             % diffusivity for BOTH Electrodes and SEPARATER [UNIT: m^2/s]

% diffusion Coefficient of Li-ion in Solid Active Particles

diffuSolid_n = 2.0e-14;      % Li+ diffusivity in Solid Phase for NEGATIVE Electrode [UNIT: m^2/s]
diffuSolid_p = 2.65005*10^(-15.5); %1.6924e-16;% 4.0277e-16;      % Li+ diffusivity in Solid Phase for POSITIVE Electrode [UNIT: m^2/s]

% Transference Number - ASSUMED CONSTANT FOR SIMPLIFICATION

tPlus = 0.35;%0.363           % [Dimensionless]

% Radius of Active Particles in Electrodes

R_s =2.63755*10^(-6.5);%4.4803e-7;%1e-6;           % At BOTH Electrodes [UNIT: m]

% Transfer Coefficient of Surface Reaction
alpha_a = 0.5;         	% At NEGATIVE Electrode (Cathodic) [Dimensionless]
alpha_c = 0.5;        	% At POSITIVE Electrode (anodic) [Dimensionless]

% Maxium Concentration of Li-ion on Surface of Particles
concS_max_n = 16.1e3;           % At NEGATIVE Electrode [UNIT: mol/m^3]
concS_max_p = 23.9e3;           % At POSITIVE Electrode [UNIT: mol/m^3]

% Surface Electrochemical Reaction-Rate Constant
kcon_n = 1.38*10^(-5.5);%1.38e-4;       % At NEGATIVE Electrode [UNIT: mol^(-3/2) * m^(-1/2) * s^(-1)]
kcon_p = 0.64*10^(-5.5);%0.64e-4;       % At POSITIVE Electrode [UNIT: mol^(-3/2) * m^(-1/2) * s^(-1)]

% Actual Electrical Conductivity of Particles
sigma_n = 1000;%1000;          % At NEGATIVE Electrode [UNIT: s/m]
sigma_p = 0.002;%0.0018;%9.6710e-4;           % At POSITIVE Electrode [UNIT: s/m]

% DONE***DONE***DONE***DONE***DONE***DONE***DONE***DONE***DONE***DONE***DONE