% settings_initial.m

% *************************************************************************

% Settings File - Initial Conditions / Starting Conditions
% Define default settings
% Testing Configuration Variables

% ALL CAPITAL VARIABLES NEVER CHANGE IN LOOPS

% Units are all in International System of Units (SI)

% *************************************************************************

% -------------------------------------------------------------------------
A0=1.045;%1.045;
resistance = 7.27105*10^(-3.5);%2e-3;         % External Contact Resistance [UNIT: Ohm * m^2]
capacity0 = 7.2;               % External Circuit Capacity [UNIT: Ah = Amp * h]
capacity=12.7;
A=A0*capacity/capacity0;
i_app_cum = 0;              % Cumulative Charge / Discharge Rate

% -------------------------------------------------------------------------
% Load Hybrid Data

if(hybrid_cycle)
    settings_hybrid_reading;
else    
% -------------------------------------------------------------------------
    % Apply Current - Boundary Conditions and Other Parameters
        i_app_D =6;                % 1-C Discharge Rate
        i_app_C = -12;               % 1-C Charge Rate

% Stoic Value and Apply Current Value at Charge / Discharge Condition
    if charge == true                           % ------------------------------------------------
        stoic_n = 0.126;                        % Charge Condition
        stoic_p = 0.936;
        i_app = i_app_C;
    else                                        % ------------------------------------------------
        stoic_n = 0.676;                      % Discharge Condition
        stoic_p = 0.442;
        i_app = i_app_D;
    end                                         % ------------------------------------------------
    
end

% -------------------------------------------------------------------------

% Initial Condition for Concentration
conc_o( 1 : n_t ) = 1.2e3;                  % [UNIT: mol / m^3]

% concS_o = zeros( 1, n_t );       % Preallocation
% for i = 1 : n_n
%     concS_o(i) = stoic_n * concS_max_n;         % NEGATIVE----------------------------------------NEED FURTHER CONFIG (CHARGE/DISCHARGE)NOT SURE WHAT IS STOIC
% end
% for i = n_n + n_s + 1 : n_t
%     concS_o(i) = stoic_p * concS_max_p;         % POSITIVE----------------------------------------NEED FURTHER CONFIG (CHARGE/DISCHARGE)
% end

concS_o = zeros( 1, (n_n+n_p)*11 );       % Preallocation
for i = 1 : n_n
    concS_o((i-1)*11+1:(i-1)*11+11) = stoic_n * concS_max_n;         % NEGATIVE----------------------------------------NEED FURTHER CONFIG (CHARGE/DISCHARGE)NOT SURE WHAT IS STOIC
end
for i = n_n + 1 : n_n+n_p
    concS_o((i-1)*11+1:(i-1)*11+11) = stoic_p * concS_max_p;         % POSITIVE----------------------------------------NEED FURTHER CONFIG (CHARGE/DISCHARGE)
end

concS_surf=zeros(1,n_t);
for i=1:n_n
    concS_surf(i)=concS_o(i*11);
end
for i = n_n+n_s + 1 : n_n+n_p+n_s
    concS_surf(i)=concS_o((i-n_s)*11);        
end

concS=concS_o;

% -------------------------------------------------------------------------

% Initial Guesses - Needed to Calculate Properties at First Time Step

tem( 1 : n_t) = 303;                        % Initial Hardwired Temperature
temFACE( 1 : n_t + 1 ) =303;               % Hardwired for now
conc( 1 : n_t ) = conc_o( 1 : n_t );        % Initial Concentration
% concS( 1 : n_t ) = concS_o( 1 : n_t );      % Initial Solid Face Concentration----------------NOT SURE
% concS_surf( 1 : n_t ) = concS( 1 : n_t );   % Iniitla Solid Face Concentration at Surface-----NOT SURE

phiS = zeros( 1, n_n+n_p );                     % Preallocation
eta = zeros( 1, n_t );                      % Preallocation

if charge == true                           % ------------------------------------------------
    phiE( 1 : n_t ) = 1.9;                  % Charge Condition
    for i = 1 : n_n                         % NEGATIVE
        phiS(i) = 2.1;
        phiE(i) = 1.9;
        eta(i) = -0.01;
    end
    for i = n_n + n_s + 1 : n_t             % POSITIVE
        phiS(i-n_s) = 4.6;
        phiE(i) = 1.9;
        eta(i) = 0.01;
    end
elseif charge==false && hybrid_cycle==true                                       % ------------------------------------------------
    phiE( 1 : n_t ) = 2.15;                
    for i = 1 : n_n                         % NEGATIVE
        phiS(i) = 2.2;
        phiE(i) = 2.2;
        eta(i) = 0.01;
    end
    for i = n_n + n_s + 1 : n_t             % POSITIVE
        phiS(i-n_s) =5.65;                  % discharge condition: change to 6.2
        phiE(i) = 2.1;
        eta(i) = -0.01;
    end                                     % ------------------------------------------------
  
else 
   phiE( 1 : n_t ) = 2.15;                % Discharge Condition
    for i = 1 : n_n                         % NEGATIVE
        phiS(i) = 2.2;
        phiE(i) = 2.2;
        eta(i) = 0.01;
    end
    for i = n_n + n_s + 1 : n_t             % POSITIVE
        phiS(i-n_s) =6.2;                  % discharge condition: change to 6.2
        phiE(i) = 2.1;
        eta(i) = -0.01;
    end   
end
% DONE***DONE***DONE***DONE***DONE***DONE***DONE***DONE***DONE***DONE***DONE