% settings_hybrid_reading.m

% *************************************************************************

% Settings File - Initial Conditions / Starting Conditions
% Define default settings
% Testing Configuration Variables

% ALL CAPITAL VARIABLES NEVER CHANGE IN LOOPS

% Units are all in International System of Units (SI)

% *************************************************************************

hybridDATA = importdata('hybrid_cycle.in');

    stoic_n = hybridDATA(1,1);
    stoic_p = hybridDATA(1,2);
    
    npt = hybridDATA(2,1);
    
    tt = zeros(1 , npt);
    chg = zeros(1 , npt);
    
    for i = 1 : npt
        tt(i) = hybridDATA(i+2,1);
        chg(i) = hybridDATA(i+2,2);
    end

    if(chg(1) < 0)
        charge = false;
    else
        charge = true;
    end
    if stoic_n==0.2085
    sigma_p=0.0015;
    end
    
    app_curr = zeros(1, time_max);
    for j = 1:time_max
        timePt = j * dt;
        for i = 1 : npt-1
            if( timePt >= tt(i) && timePt < tt(i+1) )
                app_curr(j) = -chg(i) * 12;
                break;
            else
                app_curr(j) = -chg(npt) *12;
            end
        end
    end
    tt = 0; chg = 0;
    i_app = app_curr(1);
    
% DONE***DONE***DONE***DONE***DONE***DONE***DONE***DONE***DONE***DONE***DONE