% settings_grid.m

% *************************************************************************

% Settings File - Simulation Geometry Parameters
% Define default settings
% Settings here can be changed to improve precision

% ALL CAPITAL VARIABLES NEVER CHANGE IN LOOPS

% *************************************************************************

% Time Step
dt = 1e0;               	% Time Step Length [UNIT: seconds]---------------------Test Config

% Grid Parameters
n_n = 50;                   % Number of Finite Volume Nodes - NEGATIVE-------------Test Config
n_s = 25;                   % Number of Finite Volume Nodes - SEPARATOR------------Test Config
n_p = 36;                   % Number of Finite Volume Nodes - POSITIVE-------------Test Config
n_t = n_n + n_s + n_p;      % Total Number of Cells

l_n = 50e-6;                % Length of NEGATIVE Electrode [UNIT: m]
l_s = 25.4e-6;              % Length of SEPARATOR          [UNIT: m]
l_p = 36.4e-6;              % Length of POSITIVE Electrode [UNIT: m]
% *************************************************************************
% Mesh Node Properties
dx_n = l_n / n_n;           % Cell size in NEGATIVE Electrode
dx_s = l_s / n_s;           % Cell size in SEPARATOR
dx_p = l_p / n_p;           % Cell size in POSITIVE Electrode
% -------------------------------------------------------------------------
% Volume and Grid Spacing of Each Cell
% vol = zeros( 1, n_t );      % Preallocation
dx = zeros( 1, n_t );       % Preallocation
dx(1:n_n)=dx_n;
dx(n_n + 1 : n_n + n_s)=dx_s;
dx(n_n + n_s + 1 : n_t)=dx_p;
% -------------------------------------------------------------------------

% % Cell Center of Each Cells
% xc = zeros( 1, n_t );       % Preallocation
% 
% % For i = 1
% xc(1) = dx_n / 2;
% 
% % For i = 2 : n_t
% for i = 2 : n_t
%     xc(i) = xc(i-1) + ( dx(i-1) + dx(i) ) / 2;
% end
%%
nr=11;
% DONE***DONE***DONE***DONE***DONE***DONE***DONE***DONE***DONE***DONE***DONE