% settings_control.m
% -------------------------------------------------------------------------
dt = 1;               	% Time Step Length [UNIT: seconds]
TINY = 1e-20;                 
time_max = time / dt;           % Maxium Time Steps
iter_max = 5000;                % Max Number of Iteration Loops
res_max( 1 : 4 ) = TINY;        % Normolized residual reference 
% -------------------------------------------------------------------------
% Property Limitations
conc_min = 1e-40;           % Minimum Concentration Value [UNIT: mol/m^3]
conc_max = 1e5;             % Maximum Concentration Value [UNIT: mol/m^3]

phiE_min = -10;             % Minimum Electrolyte Phase Potential [UNIT: V]
phiE_max = 10;              % Maximum Electrolyte Phase Potential [UNIT: V]

phiS_min = -10;             % Minimum Solid Phase Potential [UNIT: V]
phiS_max = 10;              % Maximum Solid Phase Potential [UNIT: V]

eta_min = -5e-1;            % Minimum Allowed eta Value
eta_max = 5e-1;             % Maximum Allowed eta Value
                    