
% settings_atCnF.m

% *************************************************************************

% Settings File - Some Additional Material Properties for Each Nodes
% Define default settings
% All physical properties - won't change until changing materials

% ALL CAPITAL VARIABLES NEVER CHANGE IN LOOPS

% Units are all in International System of Units (SI)

% *************************************************************************

% -------------------------------------------------------------------------

% Prosity at Each Node
porosityNODE = zeros( 1, n_t );             % Preallocation
poroActiveNODE = zeros( 1, n_t );           % Preallocation

for i = 1 : n_n
    porosityNODE(i) = porosity_n;
    poroActiveNODE(i) = poroActive_n;
end
for i = n_n + 1 : n_n + n_s
    porosityNODE(i) = porosity_s;
    poroActiveNODE(i) = 0;
end
for i = n_n + n_s + 1 : n_t
    porosityNODE(i) = porosity_p;
    poroActiveNODE(i) = poroActive_p;
end

% -------------------------------------------------------------------------

% diffusion Coefficient at Each Node
diffuNODE = zeros( 1, n_t );             % Preallocation

for i = 1 : n_t
    diffuNODE(i) = diffu * ( porosityNODE(i)^1.5 );
end

% -------------------------------------------------------------------------

% EffectiveElectronic conductivity at each node
sigmaEffNODE = zeros( 1, n_t );                        % Preallocation
sigmaNODE = zeros( 1 , n_t );

for i = 1 : n_n
    sigmaEffNODE(i) = sigma_n * ( poroActiveNODE(i)^1.0 );
    sigmaNODE(i) = sigma_n;
end
for i = n_n + n_s + 1 : n_t
    sigmaEffNODE(i) = sigma_p * ( poroActiveNODE(i)^1.0 );
    sigmaNODE(i) = sigma_p;
end

% *************************************************************************

% Transport porosity and diffusion at Faces
porosityFACE = zeros( 1, n_t + 1 );            % Preallocation
poroActiveFACE = zeros( 1, n_t + 1 );          % Preallocation
diffuFACE = zeros( 1, n_t + 1 );                % Preallocation
sigmaEffFACE = zeros( 1, n_t + 1 );               % Preallocation
sigmaFACE = zeros( 1, n_t + 1 );               % Preallocation

% Left Boundary
porosityFACE(1) = porosityNODE(1);
poroActiveFACE(1) = porosityNODE(1);
diffuFACE(1) = diffuNODE(1);
sigmaEffFACE(1) = sigmaEffNODE(1);
sigmaFACE(1) = sigmaNODE(1);

% NEGATIVE
for i = 2 : n_n
    diffuFACE(i) = ( diffuNODE( i - 1 ) + diffuNODE(i) ) / 2;
    porosityFACE(i) = ( porosityNODE( i - 1 ) + porosityNODE(i) ) / 2;
    sigmaEffFACE(i) = ( sigmaEffNODE( i - 1 ) + sigmaEffNODE( i ) ) / 2;
    sigmaFACE(i) = ( sigmaNODE( i - 1 ) + sigmaNODE( i ) ) / 2;
    poroActiveFACE(i) = ( porosityNODE( i - 1 ) + porosityNODE( i ) ) / 2;
end

% NEGATIVE and SEPARATER Boundary
wt = ( 1 / dx( n_n ) ) / ( 1 / dx( n_n ) + 1 / dx( n_n + 1 ) );
avg_p = wt * porosityNODE( n_n ) + ( 1 - wt ) * porosityNODE( n_n + 1 );
avg_d = wt * diffuNODE( n_n ) + ( 1 - wt ) * diffuNODE( n_n + 1 );

porosityFACE( n_n + 1 ) = porosityNODE( n_n ) * porosityNODE( n_n + 1 ) / avg_p;
poroActiveFACE( n_n + 1 ) = 0;%poroActiveFACE( n_n );
diffuFACE( n_n + 1 ) = diffuNODE( n_n ) * diffuNODE( n_n + 1 ) / avg_d;
sigmaEffFACE( n_n + 1 ) = 0;%sigmaEffFACE( n_n );
sigmaFACE( n_n + 1 ) = 0;%sigmaFACE( n_n );

% SEPARATER
for i = n_n + 2 : n_n + n_s
    diffuFACE(i) = ( diffuNODE( i - 1 ) + diffuNODE( i ) ) / 2;
    porosityFACE(i) = (porosityNODE( i - 1 ) + porosityNODE( i ) ) / 2;
    sigmaEffFACE(i) = 0;
    sigmaFACE(i) = 0;
    poroActiveFACE(i) = 0;
end

% POSITIVE and SEPARATER Boundary
wt = ( 1 / dx( n_n + n_s ) ) / ( 1 / dx( n_n + n_s ) + 1 / dx( n_n + n_s + 1 ) );
avg_p = wt * porosityNODE( n_n + n_s ) + ( 1 - wt ) * porosityNODE( n_n + n_s + 1 );
avg_d = wt * diffuNODE( n_n + n_s ) + ( 1 - wt ) * diffuNODE( n_n + n_s + 1 );

porosityFACE( n_n + n_s + 1 ) = porosityNODE( n_n + n_s ) * porosityNODE( n_n + n_s + 1 ) / avg_p;
poroActiveFACE( n_n + n_s + 1 ) = 0;
diffuFACE( n_n + n_s + 1 ) = diffuNODE( n_n + n_s ) * diffuNODE( n_n + n_s + 1 ) / avg_d;
sigmaEffFACE( n_n + n_s + 1 ) = 0;
sigmaFACE( n_n + n_s + 1 ) = 0;

% POSITIVE
for i = n_n + n_s + 2 : n_t
    porosityFACE(i) = ( porosityNODE( i - 1 ) + porosityNODE( i ) ) / 2;
    poroActiveFACE(i) = (poroActiveNODE( i - 1 ) + poroActiveNODE( i ) ) / 2;
    diffuFACE(i) = ( diffuNODE( i - 1 ) + diffuNODE( i ) ) / 2;
    sigmaEffFACE(i) = ( sigmaEffNODE( i - 1 ) + sigmaEffNODE( i ) ) / 2;
    sigmaFACE(i) = ( sigmaNODE( i - 1 ) + sigmaNODE( i ) ) / 2;
end

% Right Boundary
porosityFACE( n_t + 1 ) = porosityNODE( n_t );
poroActiveFACE( n_t + 1 ) = poroActiveNODE( n_t );
diffuFACE( n_t + 1 ) = diffuNODE( n_t );
sigmaEffFACE( n_t + 1 ) = sigmaEffNODE( n_t );
sigmaFACE( n_t + 1 ) = sigmaNODE( n_t );


% -------------------------------------------------------------------------

% Interfacial Surface Area-Volume Ratio of Particle
sv = zeros( 1, n_t );                       % Preallocation
for i = 1 : n_t
    sv(i) = 3.0 * poroActiveNODE(i) / R_s;         %[UNIT: 1/m]
end

% Surface Electrochemical Reaction-Rate Constant at each node
kconNODE = zeros( 1, n_t );                       % Preallocation
for i = 1 : n_n
    kconNODE(i) = kcon_n;       % At NEGATIVE Electrode [UNIT: mol^(-3/2) * m^(-1/2) * s^(-1)]
end
for i = n_n + n_s + 1 : n_t
    kconNODE(i) = kcon_p;       % At POSITIVE Electrode [UNIT: mol^(-3/2) * m^(-1/2) * s^(-1)]
end

% Maxium Concentration of Li-ion on Surface of Particles at each node
concS_maxNODE = zeros( 1, n_t );                       % Preallocation
for i = 1 : n_n
    concS_maxNODE(i) = concS_max_n;           % At NEGATIVE Electrode [UNIT: mol/m^3]
end
for i = n_n + n_s + 1 : n_t
    concS_maxNODE(i) = concS_max_p;           % At POSITIVE Electrode [UNIT: mol/m^3]
end

% DONE***DONE***DONE***DONE***DONE***DONE***DONE***DONE***DONE***DONE***DONE