% loop_eqpot.m

% *************************************************************************

% Calculate the equilibrium potential ( or open circuit potential)

% Units are all in International System of Units (SI)

% *************************************************************************

eqpot = zeros( 1, n_t );            % Preallocation
% NEGATIVE side
for i = 1 : n_n

    x_bulk(i) = ( stoic_n * poroActive_n * concS_max_n * l_n - i_app_cum / FARADAY ) ...
        / ( poroActive_n * concS_max_n * l_n );
    x(i)=concS_surf(i)./concS_max_n;
         
    eqpot(i) = 8.00229 + 5.0647 * x(i) - 12.578 * sqrt(x(i)) - 8.6322e-4 / x(i)...
        + 2.1765e-5 * ( x(i)^1.5 ) - 0.46016 * exp ( 15.0 * ( 0.06 - x(i) ) )...
        - 0.55364 * exp ( -2.4326 * ( x(i) - 0.92 ) );
    
end

% POSITIVE side
yL = 0.442; yH = 0.936; alf = 1.0/(yL-yH); bet = -yH/(yL-yH);

for i = n_n + n_s + 1 : n_t

    y_bulk(i)= ( stoic_p * poroActive_p * concS_max_p * l_p + i_app_cum / FARADAY ) ...
        / ( poroActive_p * concS_max_p * l_p );
    y(i)=concS_surf(i)./concS_max_p;
    z(i)= alf*y(i)+bet;
%     eqpot(i) = EMFpos(z(i));

    

    eqpot(i) = p(1) * ( z(i)^7 ) +p(2) * ( z(i)^6 ) +p(3) * ( z(i)^5 ) ...
        +p(4) * ( z(i)^4 ) + p(5) * ( z(i)^3) +p(6)* (z(i)^2) ...
        +p(7)*z(i)+p(8) * exp (p(9) * ( z(i)^10 ) ) +p(10);
%     
end
x_n(t)=x(1);
y_p(t)=y(n_t);

x_bulk_n(t)=x_bulk(1);
y_bulk_p(t)=y_bulk(n_t);
U1(t)=eqpot(1);
U2(t)=eqpot(n_t);
% DONE***DONE***DONE***DONE***DONE***DONE***DONE***DONE***DONE***DONE***DONE