%% Do not* change anything in this file %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%********* define Jacobian matrix for Ce **********%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Time derivative by Backward Euler
% F(block1)=((dt)*A_cs-1)cs(t)+(dt)f_cs(cs(t))+cs(t-1)=0
% F(block2)=((dt)*A_ce-1)ce(t)+(dt)f_ce(cs(t))+ce(t-1)=0
% F(block3)=A_phie(ce)*[ce;phie]+f_phie
% F(block4)=A_phis*phis+f_phis+Biapp
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function J_ce =bat_ce_J(y_in)

global eta tem sv porosityNODE dx n_n n_s n_t n_p nr FARADAY RU...
       tPlus alpha_a alpha_c concS_max_n...
       concS_max_p kcon_n kcon_p diffuFACE dt A_ce jli
conc=y_in(n_n+n_p+n_t+1:n_n+n_p+n_t+n_t);
concS_surf=y_in((n_n+n_p)+n_t+n_t+nr*(n_n+n_p)+1:(n_n+n_p)+n_t+n_t+nr*(n_n+n_p)+n_t);
T=tem(1);
%% define BV equation
concS_max=zeros(1,n_t);concS_max(1:n_n)=concS_max_n;
concS_max(n_n+n_s+1:n_t)=concS_max_p;
kcon=zeros(1,n_t);kcon(1:n_n)=kcon_n;kcon(n_n+n_s+1:n_t)=kcon_p;
i0=kcon.*(conc.^alpha_a).*((concS_max-concS_surf).^alpha_a).*(concS_surf.^alpha_c);
exp1=exp((alpha_a * FARADAY/( RU * T ))* eta);
exp2= exp(-(alpha_c * FARADAY/( RU * T))* eta);
jli=sv.*i0.*(exp1-exp2);
Jli_ce=(alpha_a*jli)./conc;
%% define jacobian matrix for ConcE
%************************* define A_ce matrix **%%%**********************%
A_ce=zeros(n_t,n_t);
for i=1;
    E_ce=porosityNODE(i)*dx(i);
    A_ce(i,i)=-2*diffuFACE(i+1)*dt/(dx(i)+dx(i+1))/E_ce-1;
    A_ce(i,i+1)=2*diffuFACE(i+1)*dt/(dx(i)+dx(i+1))/E_ce;
end
for i=2:n_n+n_s+n_p-1
    E_ce=porosityNODE(i)*dx(i);
    A_ce(i,i-1)=diffuFACE(i)*2*dt/(dx(i)+dx(i-1))/E_ce;
    A_ce(i,i)=-((diffuFACE(i)*2*dt/(dx(i)+dx(i-1)))+...
               (diffuFACE(i+1)*2*dt/(dx(i)+dx(i+1))))/E_ce-1;
    A_ce(i,i+1)=diffuFACE(i+1)*2*dt/(dx(i)+dx(i+1))/E_ce;
end
for i=n_n+n_s+n_p;
    E_ce=porosityNODE(i)*dx(i);
    A_ce(i,i-1)=diffuFACE(i)*2*dt/(dx(i)+dx(i-1))/E_ce;
    A_ce(i,i)=-diffuFACE(i)*2*dt/(dx(i)+dx(i-1))/E_ce-1;
end
%************************* define BV equation ***************************%
f_ce=(((1-tPlus)*dt/FARADAY*Jli_ce)./porosityNODE)';
% J_ce=(A_ce.*(dt)-eye(n_t))+spdiags(f_ce,0,length(f_ce),length(f_ce));
J_ce=(A_ce)+spdiags(f_ce,0,length(f_ce),length(f_ce));