%% %%%%%%%%%%%% sensitivity analysis QR %%%%%%%%%%%
clear all
load voltage_05soc_pulse300s_1e3.mat
load voltage_pulse300s_short_full_ori.mat
load theta_new_nominal.mat

%%
delta=theta_hat*1e-3;
para_num=16;
theta_hat(16)=[];
J=[];

for i=1:para_num
    differ(i,:)=voltage_pulse{1,i}-cell_voltage(1:3700);
end
for i=1:16

J(i,:)=differ(i,:)/delta(i);

end
theta_hat1=diag(theta_hat,0);
J1=theta_hat1*J;

%% sensitivity matrix
Sen=J1';
[U,S,V]=svd(Sen);
%% QR
figure(10000)
[Q,R,P]=qr(Sen);
rank_ori=(1:16)';

rank_new=P'*rank_ori; %new sensitivity rank
stem(diag(abs(R)),'b');
% title('Magnitude of diagonal entries of R')
ylim([0 2])
set(gca,'ytick',0:0.5:2)
xlim([0 16])
xlabel('m');
ylabel('Value')


