%% long relaxation validation
clear all
load volts_05soc_pulse120s_de.mat
load volts_05soc_lsq_short_pulse120s.mat
load app_curr_120s.mat

figure(777)
subplot(2,1,1)
plot((1:1:5700)/60,app_curr,'b','LineWidth',1)
xlim([0,5700/60]);
xlabel('Time [min]')
ylabel('Current [A]');
text(1,17,'\fontsize{14}a)')

subplot(2,1,2);
plot((1:1:5700)/60, volts_pulse120s_de(1:5700),'b','LineWidth',1)
hold on
plot((1:1:5700)/60, cell_voltage,'r','LineWidth',1)
legend('experimental','model')
xlim([0,5700/60]);
xlabel('Time [min]')
ylabel('Voltage [V]');
text(1,3.78,'\fontsize{14}b)')

sqrt(sum((cell_voltage'-volts_pulse120s_de(1:5700)).^2)/5700)