%% constant discharge validation
clear all
load volts_1c_exp.mat
load volts_05c_exp.mat
load volts_01c_exp.mat
load dod_1c_exp.mat
load dod_05c_exp.mat
load dod_01c_exp.mat

load dod_aver.mat
load voltage_aver.mat
load dod_aver_05.mat
load voltage_aver_05.mat
load dod_aver_01.mat
load voltage_aver_01.mat
%%
figure(777)
plot(dod_1c_exp(1:10:738)*12.7,volts_1c_exp(1:10:738),'bs','MarkerSize',4)
hold on
plot(dod_1c*12.7,cell_voltage_1c,'b','LineWidth',1)
volts_extra=interp1(dod_1c_exp,volts_1c_exp,dod_1c,'linear','extrap');
sqrt(sum((cell_voltage_1c-volts_extra).^2)/3300)
hold on
plot(dod_05c_exp(1:20:end)*12.7,volts_05c_exp(1:20:end),'ro','MarkerSize',4)
volts_extra2=interp1(dod_05c_exp,volts_05c_exp,dod_05c,'linear','extrap');
sqrt(sum((cell_voltage_05c-volts_extra2).^2)/6804)

hold on
plot(dod_05c*12.7,cell_voltage_05c,'r','LineWidth',1)
hold on
plot(dod_01c_exp(1:75:end)*12.7,volts_01c_exp(1:75:end),'gd','MarkerSize',4)
hold on
plot(dod_01c*12.7,cell_voltage_01c,'g','LineWidth',1)
volts_extra3=interp1(dod_01c_exp,volts_01c_exp,dod_01c,'linear','extrap');
sqrt(sum((cell_voltage_01c-volts_extra3).^2)/34824)
h=legend('1C measured','1C model','0.5C measured','0.5C model','0.1C measured','0.1C model');
% title('Comparison between measured voltage and predicted voltage');
set(h,'Fontsize',12);
xlim([-0.1,12.7]);
xlabel('Capacity [Ah]');
ylabel('Voltage [V]');
%% 20% 80% validation
clear all
load volts_02soc_pulse300s_short.mat
load voltage_02soc_ori.mat
load volts_02soc_lsq_short_pulse300s.mat
load volts_08soc_pulse300s_short.mat
load voltage_08soc_ori.mat
load volts_08soc_lsq_short_pulse300s.mat
load volts_05soc_pulse300s_short.mat
load voltage_05soc_ori.mat
load volts_05soc_lsq_short_pulse300s.mat
load app_curr.mat

figure(7)
subplot(4,1,1)
plot((1:1:4700)/60,app_curr,'b','LineWidth',1)
xlim([0,4700/60]);
xlabel('Time [min]')
ylabel('Current [A]');
text(1,18,'\fontsize{14}a)')

% 80%soc
subplot(4,1,2)
plot((1:1:4700)/60,volts_pulse300s_08soc,'b','LineWidth',1)
hold on
plot((1:1:4700)/60,cell_voltage_08soc,'r','LineWidth',1)
legend('experimental','prediction')
xlim([0,4700/60]);
ylim([3.6 4.2]);
xlabel('Time [min]')
ylabel('Voltage [V]');
text(1,4.15,'\fontsize{14}b)')
% 20%soc
subplot(4,1,3);
plot((1:1:4700)/60,volts_02soc_pulse300s_short,'b','LineWidth',1)
hold on
plot((1:1:4700)/60,cell_voltage_02soc,'r','LineWidth',1)
legend('experimental','prediction')
xlim([0,4700/60]);
ylim([3 3.7]);
xlabel('Time [min]')
ylabel('Voltage [V]');
text(1, 3.8, '\fontsize{14}c)');

% 50%soc
subplot(4,1,4)
plot((1:1:4700)/60,volts_pulse300s_short,'b','LineWidth',1)
hold on
plot((1:1:4700)/60,cell_voltage_05soc,'r','LineWidth',1)
legend('experimental','model')
xlim([0,4700/60]);
ylim([3.4 4]);
xlabel('Time [min]')
ylabel('Voltage [V]');
text(1, 3.95, '\fontsize{14}b)');


%% 50% SoC validation
clear all
load volts_05soc_pulse300s_short.mat
load volts_05soc_lsq_short_pulse300s.mat
load app_curr.mat

figure(77)
subplot(2,1,1)
plot(app_curr,'b','LineWidth',1)
xlim([0,4700]);
xlabel('t(s)')
ylabel('current(A)');
title('Input');

subplot(2,1,2);
plot(volts_pulse300s_short,'b','LineWidth',1)
hold on
plot(cell_voltage_05soc,'r','LineWidth',1)
legend('experimental','optimal')
xlim([0,4700]);
xlabel('t(s)')
ylabel('voltage(V)');
title('50% SoC');

%% long relaxation validation
clear all
load volts_05soc_pulse120s_de.mat
load volts_05soc_lsq_short_pulse120s.mat
load app_curr_120s.mat

figure(777)
subplot(2,1,1)
plot((1:1:5700)/60,app_curr,'b','LineWidth',1)
xlim([0,5700/60]);
xlabel('Time [min]')
ylabel('Current [A]');
text(1,17,'\fontsize{14}a)')

subplot(2,1,2);
plot((1:1:5700)/60, volts_pulse120s_de(1:5700),'b','LineWidth',1)
hold on
plot((1:1:5700)/60, cell_voltage,'r','LineWidth',1)
legend('experimental','model')
xlim([0,5700/60]);
xlabel('Time [min]')
ylabel('Voltage [V]');
text(1,3.78,'\fontsize{14}b)')

sqrt(sum((cell_voltage'-volts_pulse120s_de(1:5700)).^2)/5700)

%% fit emf
load Eeq_qinetiq_30deg.mat

DoD =Qtrans(isfinite(Qtrans)&isfinite(Vtrans))/max(Qtrans);
SoC = 1-DoD;
EMFtmp = @(x) interp1(SoC, Vtrans(isfinite(Qtrans)&isfinite(Vtrans)), x, 'linear', 'extrap');

nint=10000;
socgrd = [0: (1-0)/nint :1];
xL=0.126;xH=0.676;
xgrd = [xL : (xH-xL)/nint : xH];
npot= 8.00229 + 5.0647 * xgrd - 12.578 * (xgrd).^0.5 - 8.6322e-4 ./ xgrd...
        + 2.1765e-5 * ( xgrd.^1.5 ) - 0.46016 * exp ( 15.0 * ( 0.06 - xgrd ) )...
        - 0.55364 * exp ( -2.4326 * ( xgrd - 0.92 ) );

EMFpostbl = EMFtmp(socgrd)+npot;

EMFpos = @(x) interp1(socgrd, EMFpostbl, x, 'linear', 'extrap');

%%
fun = @(alpha,socgrd) alpha(1)*socgrd.^7+alpha(2)*socgrd.^6+alpha(3)*socgrd.^5+alpha(4)*socgrd.^4+...
    alpha(5)*socgrd.^3+alpha(6)*socgrd.^2+alpha(7)*socgrd+alpha(8)*exp(alpha(9)*socgrd.^10)+alpha(10);
alpha_i=[1 0 0 0 0 0 0 0 0 0]; 
[alpha,sse] = lsqcurvefit(fun,alpha_i,socgrd,EMFpostbl);

Vemf=alpha(1)*socgrd.^7+alpha(2)*socgrd.^6+alpha(3)*socgrd.^5+alpha(4)*socgrd.^4+...
    alpha(5)*socgrd.^3+alpha(6)*socgrd.^2+alpha(7)*socgrd+alpha(8)*exp(alpha(9)*socgrd.^10)+alpha(10);
V_fit=Vemf-npot;

%%
figure(1)
plot(socgrd,Vemf)
hold on
plot(socgrd,EMFpostbl)
legend('fit','experimental')
title('EMF function in positive')

emf=EMFtmp(socgrd);
figure(2)
plot(socgrd,emf,'b','LineWidth',1)
hold on
plot(socgrd(1:10:10000),V_fit(1:10:10000),'--r','LineWidth',2)
xlabel('SoC')
ylabel('Voltage (V)')
legend('experimental','fit')
title('Open-circuit Voltage')
%%
yL =0.442; yH = 0.936; alf = 1.0/(yL-yH); bet = -yH/(yL-yH);
figure(3)
[hAx,hLine1,hLine2] =plotyy(socgrd,npot,[socgrd',socgrd'],[Vemf',emf']);
 set(hLine1,'LineWidth',1);
 set(hLine2,'LineWidth',1);
  set(hLine1,'color','b');
  set(hLine2,'color','r');
 set(hAx,{'ycolor'},{'b';'r'})
 
 set(hAx(2),'YLim',[2.7 4.4])
set(hLine2(2),'LineStyle', '--');
 set(gca,'xtick',0:0.2:1)
xlabel('SoC')
ylabel(hAx(1),'Voltage [V]') % left y-axis
ylabel(hAx(2),'Voltage [V]')
h=legend('Negative','Positive','Battery');
set(h,'Fontsize',12);
