clearvars; clear all;
close all; clc;
colarr=['b','c','g','y','m','r','k','b','c','g','y','m','r','k'];
typarr=['-','-','-','-','-','-','-',':',':',':',':',':',':',':'];
mult = 3600;mulv=1;
Tain = 30; %Initial ambient temperature C
dTminus=0.5;dTplus=5;

%% Add directory with common functions to the Matlabs search path
addpath('functions');
addpath('Characterisation');


%% Cell capacity
Cap = 12;

% Procedure data logged by MACCOR
[b2] = GetBData_Graupner3('Charac_30deg_2.txt',5);

%% Convert the auxiliary voltages to temperatures
b2.Temp1 = V2T(b2.Aux1,4); % Cell outside temperature
b2.Temp2 = V2T(b2.Aux2,5); % Cell outside temperature


%% Work out logged data
figure(1); subplot(311);
plot(b2.test/mult,b2.volts,'b','LineWidth',2); grid on;
xlabel('Time [h]');ylabel('Voltage [V]');
ylim([2.5 4.3]);
%title('Voltage variation during cycling with different C-rates in discharges, T_{amb}=0{\circ}C');
title('(a)')

% Correction of current (I)sign during charge and discharge cycles
Itmp=b2.amps;tmp = b2.MD;
for i=1:length(Itmp),
    if ( strcmp(tmp(i),'C') ),       Itmp(i) =  1.0*Itmp(i); 
    elseif ( strcmp(tmp(i),'D') ),   Itmp(i) = -1.0*Itmp(i); 
    elseif ( strcmp(tmp(i),'R') ),   Itmp(i) =  0.0*Itmp(i); 
    elseif ( strcmp(tmp(i),'O') ),   Itmp(i) =  0.0*Itmp(i); 
    else    disp(i);disp(tmp(i));    end;    
end;
b2.amps=Itmp;
figure(1); subplot(312)
plot(b2.test/mult,b2.amps,'b','LineWidth',2); grid on;
xlabel('Time [h]');ylabel('Current [A]');
%title('Current variation during cycling, different C-rates in discharges, T_{amb}=0{\circ}C');
title('(b)')

% Finding change point of cyclings from Rest to Charge or to Discharge and
% vise versa. Also finding the temperature at end of each rest cycle.
[chp2,reg2,chpr,Trend] = findchange(b2);
%%
% Smooth raw temperatures
wl=75;
b2.Temp1smth = smooth(b2.Temp1,wl,'moving');
b2.Temp1smth =smooth(b2.Temp1smth,wl,'moving');
b2.Temp2smth = smooth(b2.Temp2,wl,'moving');
b2.Temp2smth =smooth(b2.Temp2smth,wl,'moving');

figure(6); 
plot(b2.test/mult,b2.Temp1,b2.test/mult,b2.Temp1smth,'r','LineWidth',2); grid on;
xlabel('Time [hr]');ylabel('T[{\circ}C]');
title(strcat('Temperature evolution during cycling, T_{amb}=',num2str(Tain),'{\circ}C'));
legend('Raw data','Filtered data',2); 
ylim([Tain-dTminus Tain+dTplus]);

figure; 
plot(b2.test/mult,b2.Temp1smth,b2.test/mult,b2.Temp2smth,'r','LineWidth',2); grid on;
xlabel('Time [hr]');ylabel('T[{\circ}C]');
title(strcat('Temperature evolution during cycling, T_{amb}=',num2str(Tain),'{\circ}C'));
legend('Top','Middle',2); 
ylim([Tain-dTminus Tain+dTplus]);

%%
% Extract charge
charge=extractcharge(b2,chp2,reg2, Cap); 

% Creating Discharge curves for different C-rates
[disch2,b2.Temp1verysmth]=extractdisch(b2,chp2,reg2, Cap); 
disch2=disch2([7:end]);  %%??

% Extract rest
rest = extractrest(b2,chp2,reg2, Cap);
IndRest = 11 : 2 : 23 ;
IndRestAftCh = 10 : 2 : 22 ;
for i = 1:length(IndRest)
    rest1(i) = rest(IndRest(i));
    restAftCh(i) = rest(IndRestAftCh(i));
end

% Plotting a somewhat more smooth temperature
figure(1); subplot(313);
plot(b2.test/mult,b2.Temp1smth , ...
    b2.test/mult,b2.Temp2smth , 'LineWidth',2); grid on;
xlabel('Time [h]');ylabel('Temperature [{\circ}C]'); 
ylim([Tain-dTminus Tain+dTplus]); 
title(strcat('Temperature evolution during cycling, T_{amb}=',num2str(Tain),'{\circ}C'));
title('(c)');

% Plot all discharge curves vs extracted charge
figure(8); ic=1; maxQin=-1e10; maxV=-1e10; minV=1e10;
for i=1:length(disch2),
    disch2{i}.Qin = disch2{i}.amphr-min(disch2{i}.amphr);
    maxQin=max(maxQin, max(disch2{i}.Qin));
    maxV  =max(maxV,   max(disch2{i}.volts));
    minV  =min(minV,   min(disch2{i}.volts));
    plot(disch2{i}.Qin,disch2{i}.volts,colarr(i),'LineWidth',1.5);hold on;
    ltxt(ic,:) = num2str( disch2{i}.C, '%4.2f C' );ic=ic+1;
    % Current integration methods
    Qmax1 = max(disch2{i}.Qin);
    Qmax2 = max(-mean(disch2{i}.amps)*(disch2{i}.test-disch2{i}.test(1))/3600);
    Qmax3 = -trapz((disch2{i}.test-disch2{i}.test(1))/3600,disch2{i}.amps);
    clc
end;
legend(ltxt,'Location','SouthWest'); grid on;
ylim([2.5 4.3]);%xlim([0 ceil(maxQin)])
title(strcat('Discharge voltages for T_{amb}=',num2str(Tain),'{\circ}C'));
xlabel('Q_{out}'); ylabel('Voltage [V]');


% Plot all relaxation voltages after DISCHARGE
figure(18); ic=1;
for i=1:length(rest1),
    rest1{i}.time = rest1{i}.test-rest1{i}.test(1);
    plot(rest1{i}.time./3600,rest1{i}.volts,colarr(i),'LineWidth',1.5);hold on;
    ltxt(ic,:) = num2str( disch2{i}.C, '%4.2f C' );ic=ic+1;
end;
legend(ltxt,4); grid on;
% ylim([2.5 4.3]); xlim([-0.05 2]);
title(strcat('Relaxation voltages after discharge for T_{amb}=',num2str(Tain),'{\circ}C'));
xlabel('time [h]'); ylabel('Voltage [V]');

% Plot all relaxation voltages after CHARGE
figure(28); ic=1;
for i=1:length(restAftCh),
    restAftCh{i}.time = restAftCh{i}.test-restAftCh{i}.test(1);
    plot(restAftCh{i}.time./3600,restAftCh{i}.volts,colarr(i),'LineWidth',1.5);hold on;
    ltxt(ic,:) = num2str( disch2{i}.C, '%4.2f C' );ic=ic+1;
end;
legend(ltxt,1); grid on;
% ylim([ 4.17 3.20 ]); xlim([-0.05 2]);
title(strcat('Relaxation voltages after charge for T_{amb}=',num2str(Tain),'{\circ}C'));
xlabel('time [h]'); ylabel('Voltage [V]');




%%
% Difference between raw measured data and distinct-made data
figure;
plot(disch2{1,1}.amphr1,disch2{1,1}.volts2,disch2{1,1}.Qin,disch2{1,1}.volts);grid on;drawnow;
xlabel('Q_{out} [Ah]'); ylabel('Voltage [V]');
legend('raw data','distinct data (for interp1)');

% Capturing I from the table
for i=1:length(disch2), 
    I(i) = disch2{i}.C; 
end; 
I=I(:);

%% Create regression extrapolation curves to zero current

Qout = [0.05;2;4;6;8]; % [Ah]
num = [1;2;3;4]; % Number in disch2{1,num} (for current)
Vreg = zeros(length(Qout),length(num)); 
II = zeros(1,length(num));figure(12);
for i = 1:length(num)
    for j = 1:length(Qout)
        Vreg(j,i) = interp1(disch2{1,num(i)}.Qin,disch2{1,num(i)}.volts,Qout(j));
        plot(-disch2{1,num(i)}.C*Cap,Vreg(j,i),'x','LineWidth',5); hold on;
        II(i) = -disch2{1,num(i)}.C*Cap; % Current
    end
end
xlabel('I [A]'); ylabel('Voltage [V]'); grid on;

step = 0.01;
U = [II ; II.^0]'; % LINEAR
% U = [II.^2 ; II ; II.^0]'; % Quadratic
Vregest = zeros(length(Qout),length(0:step:II(end))); 
for i = 1:length(Qout)
   c1 = U\Vreg(i,:)';
   %Vregest(i,:) = polyval(c1,[0 II]);
   Vregest(i,:) = polyval(c1,0:step:II(end));
end
figure(12); hold on;
plot(0:step:II(end),Vregest,'r','LineWidth',2); hold on;
plot(zeros(length(Vregest(:,1)),1),Vregest(:,1),'xr','LineWidth',5);
ttxt = num2str(  Qout', '%4.2fAh, '); 
%title(ttxt);
%title('(a)'); % Title for report
text(1,4,ttxt,'FontSize',12,'BackgroundColor','w');%[.7 .9 .7]


% Method for Qout vs Current
Vout = [2.8;3.3;3.4;3.5]; % [Ah]
num = [1;2;3]; % Number in disch2{1,num}
Qreg = zeros(length(Qout),length(num)); 
II = zeros(1,length(num));figure(13);
for i = 1:length(num)
    for j = 1:length(Vout)
        Qreg(j,i) = interp1(disch2{1,num(i)}.volts,disch2{1,num(i)}.Qin,Vout(j));
        plot(-disch2{1,num(i)}.C*Cap,Qreg(j,i),'x','LineWidth',5); hold on;
        II(i) = -disch2{1,num(i)}.C*Cap; % Current
    end
end
xlabel('I [A]'); ylabel('Q_{out} [Ah]'); grid on;

U = [II.^2 ; II ; II.^0]'; % Quadratic
Qregest = zeros(length(Vout),length(0:step:II(end))); 
for i = 1:length(Vout)
   c2 = U\Qreg(i,:)';
   %Vregest(i,:) = polyval(c1,[0 II]);
   Qregest(i,:) = polyval(c2,0:step:II(end));
end
figure(13); hold on;
plot(0:step:II(end),Qregest,'r','LineWidth',2); hold on;
plot(zeros(length(Qregest(:,1)),1),Qregest(:,1),'xr','LineWidth',5);
ttxt = num2str(  Vout', '%4.2fV, '); 
%title(ttxt);
%title('(b)'); % Title for report
text(0.5,8.5,ttxt,'FontSize',12,'BackgroundColor','w');%[.7 .9 .7]

%%
% Generating a new grid on x-axis as basis for redrawing and interpolation
Qgrid = (0:0.01:maxQin); 
Qshow = (0:(maxQin/(100-1)):maxQin);
for i=1:length(disch2),
   Qgrid = union(Qgrid,max(disch2{i}.Qin)); 
end;

% Interpolation on voltage-Qout curves on horizontal zone to find emf
III=I(1:3); 
X = [ones(size(III)) III];
% X = [ones(size(III)) III III.^2]; % Quadratic
for i=1:length(Qgrid),
    for j=1:length(III),
        Y(j) = interp1(disch2{j}.Qin,disch2{j}.volts,Qgrid(i));
    end;
    Y= Y(:);  
    %beta = inv(X'*X)*X'*Y;
    beta = X\Y;
    V_0(i)=beta(1);
end;

% Creating a new grid on y-axis as basis for redrawing and interpolation
Vgrid = (minV:0.005:maxV);
Vgrid = union(Vgrid,maxV); 
Vshow = (minV:(maxV-minV)/(100-1):maxV);


% Interpolation on voltage-Qout curves on vertical zone to find emf
I=I(1:3); 
X = [ones(size(I)) I]; % Linear
%X = [ones(size(I)) I I.^2]; % Quadratic
for i=1:length(Vgrid),
    for j=1:length(I),
         Y(j) = interp1(disch2{j}.volts,disch2{j}.Qin,Vgrid(i));
    end;
    Y= Y(:);  
    %beta = inv(X'*X)*X'*Y;
    beta = X\Y;
    Q_0(i)=beta(1);
end;


Qtr = 9.4; Vtr = 3.5;
Qtr = 9.35; Vtr = 3.55;
Vtmpsteep = Vgrid(Vgrid<Vtr);    Qtmpsteep = Q_0(Vgrid<Vtr);
Qtmpflat  = Qgrid(Qgrid<Qtr);    Vtmpflat  = V_0(Qgrid<Qtr);
QQ = [Qtmpflat Qtmpsteep];       VV = [Vtmpflat Vtmpsteep];
figure(21);
for i=1:length(disch2),
   plot(Qgrid, interp1(disch2{i}.Qin,disch2{i}.volts,Qgrid), colarr(i),'LineWidth',1.5 );hold on
end;
plot(QQ,VV,'k.'); grid on;
ylim([2.5 4.3]); xlim([-0.2 13.2]);
ylabel('Voltage [V]');
xlabel('Q_{out}[Ah]');
title(strcat('Voltage variation in different C-rates plus estimated emf during discharge, T_{amb}=',num2str(Tain),'{\circ}C'));

[Qtrans]  = union(Qgrid(Qgrid<Qtr), Q_0(Vgrid<Vtr));
V_Vext  = interp1(Qgrid, V_0, Qtrans);
V_Qext  = interp1(Q_0(isfinite(Q_0)), Vgrid(isfinite(Q_0)), Qtrans);
Vtrans=NaN*ones(size(Qtrans));
Vtrans(V_Qext>Vtr) = V_Vext(V_Qext>Vtr);
Vtrans(Qtrans>Qtr) = V_Qext(Qtrans>Qtr);
ind0 = (Qtrans<=Qtr)&(V_Qext<=Vtr);
ind=ind0(ind0>0); 
wt = cumsum(ind)/(length(ind)+1);
Vtrans( ind0 ) = V_Vext( ind0 ).*(1-wt) + V_Qext( ind0 ).*wt;
Vtrans=smooth(Vtrans, 5, 'loess')';

MaxCap=max(Qtrans)

DoD =Qtrans(isfinite(Qtrans)&isfinite(Vtrans))/MaxCap;
SoC = 1-DoD;
EMF = @(x) interp1(SoC, Vtrans(isfinite(Qtrans)&isfinite(Vtrans)), x, 'linear', 'extrap');

save(strcat('Eeq_qinetiq_',num2str(Tain),'deg.mat'), 'Qtrans', 'Vtrans');

% To obtain overvoltage vs measured time:
% Determine SoC form the measurements and substitute SoC into EMF=@(x) -->
% EMF(SoC). Then you have the EMF versus time. Subsequently substract the
% measured voltage from the EMF. This is the overvoltage. Now you have
% obtained the overvoltage vs measured time. 


%% Extracting SoC from measurements
SoC_ini = 1;%1;
for i = 1:length(disch2)
disch2{:,i}.SoC_mod = SoC_ini - (1/max(QQ))*disch2{1,i}.Qin;
end
% Plot SoC vs Qout
figure;clear ltxt;ic=1;
for i=1:length(disch2),
    plot(disch2{:,i}.Qin,disch2{:,i}.SoC_mod, colarr(i),'LineWidth',2); hold on;
    ltxt(ic,:) = num2str( -disch2{i}.C, '%4.2f C' );ic=ic+1;
end;
ylabel(' SoC [-] ');
ylim([0 1]); grid on;
legend(ltxt,1);xlim([-0.2 13.2]);
xlabel('Q_{out}[Ah]');
title(strcat('SoC vs Q_{out}, T_{amb}=',num2str(Tain),'{\circ}C'));


%% Determing overvoltages by EMF(SoC)-volts(measured)
for i = 1:length(disch2)
disch2{:,i}.eta = EMF(disch2{:,i}.SoC_mod)-disch2{:,i}.volts;
end
% Plot overvoltages
figure;clear ltxt;ic=1;
for i=1:length(disch2),
    plot(disch2{:,i}.Qin,disch2{:,i}.eta, colarr(i),'LineWidth',2); hold on;
    ltxt(ic,:) = num2str( -disch2{i}.C, '%4.2f C' );ic=ic+1;
end;
ylabel(' Discharge over-voltage [V] ');
% ylim([0 0.9]); 
grid on;xlim([-0.2 13.2]);
legend(ltxt,2);
xlabel('Q_{out}[Ah]');
title(strcat('Over potential variation in different C-rates during discharge, ambient temperature around ',num2str(Tain),'{\circ}C'));


%%
load socgrd_fit.mat
load volts_fit.mat

emf=EMF(socgrd);

figure(31);clear ltxt;ic=1;
plot(socgrd*12.7,emf(end:-1:1),'--k','LineWidth',1);hold on;ltxt(1,:) = 'EMF ';
for i=1:length(disch2),
   plot(Qgrid, interp1(disch2{i}.Qin,disch2{i}.volts,Qgrid), colarr(i),'LineWidth',1.5 );hold on
%     ltxt(ic,:) = num2str( -disch2{i}.C, '%4.2f  C' );ic=ic+1;   
end;
hold on
plot(socgrd(1:10:10000)*12.7,V_fit(10000:-10:1),'--r','LineWidth',2)

h=legend('EMF','0.1C','0.2C','0.3C','0.5C','0.75C','1C','1.25C','Fit EMF','Location','SouthWest');
set(h,'Fontsize',12);
ylim([2.65 4.2]);
set(gca,'ytick',2.7:0.3:4.2)
% xlim([-0.2 13.2]);
ylabel(' Voltage [V]');
xlabel('Q_{out}[Ah]');
% title('Voltage variation in different C-rates,EMF plus Fit EMF during discharge');
xlim([0,12.7])
%title('(a)'); % Title for in report
