```@meta
CurrentModule = CounterfactualExplanations 
```

# Contributing

Our goal is to provide a go-to place for counterfactual explanations in Julia. To this end, the following is a non-exhaustive list of exciting feature developments we envision:

1. Additional counterfactual generators and predictive models.
2. Additional datasets for testing, evaluation and benchmarking.
3. Improved preprocessing including native support for categorical features.
4. Support for regression models.

We are also interested in suggestions on how to adjust and improve the inner workings of our package. To facilitate this process the following page explain and justify the package architecture and the design choices we have made. 

## How to contribute?

All of the following contributions are welcome:

1. Should you spot any errors or something is not working, please just open an [issue](https://github.com/pat-alt/CounterfactualExplanations.jl/issues).
2. If you want to contribute your own code, please proceed as follows:
   - Fork this repo and clone your fork: `git clone https://github.com/your_username/CounterfactualExplanations.jl`.
   - Add a remote corresponding to this repository: `git remote add upstream https://github.com/pat-alt/CounterfactualExplanations.jl.git`
   - Implement your modifications and submit a pull request.
3. For any other questions or comments you can also start a [discussion](https://github.com/pat-alt/CounterfactualExplanations.jl/discussions).