# Code and data from the CPAIOR 2021 paper "Learning Variable Activity Initialisation for Lazy Clause Generation Solvers"
#
# Ronald van Driel et al.
# Delft University of Technology, NL
# April 2021
# copyright (c) 2020-2021 by R. van Driel et al.
# GNU General Public Licence 3
#
# contact: n.yorke-smith@tudelft.nl


import subprocess
import glob
import time
import re
from multiprocessing import Pool
import os.path
import sys


flatZincPaths = "FlatZincPaths/"
modelFiles = glob.glob("FlatZincUnsat/*.fzn.gz")
basecommand = '/Applications/Dev/MiniZincIDE.app/Contents/Resources/bin/findMUS'
outputfile = 'MUC/'

completed = 0
total = len(modelFiles)


def track_job(job, update_interval=60):
    while job._number_left > 0:
        print("Tasks remaining = {0}".format(job._number_left * job._chunksize))
        time.sleep(update_interval)

def runChuffed(fznFile):
    global flatZincPaths, outputfile

    fileNameWithGz = fznFile
    fileNameWithoutGz = fileNameWithGz.rsplit( ".", 1 )[ 0 ]  # remove .gz extension
    fileName = fileNameWithoutGz[fileNameWithoutGz.rfind('/')+1:][:(fileNameWithoutGz[fileNameWithoutGz.rfind('/')+1:]).rfind('.')]

    if not os.path.exists(outputfile+fileName+"_MUC.txt"):
        pathFile = glob.glob(flatZincPaths + "*/" + fileName + ".paths.gz")
        if pathFile:
            try:
                # gunzip paths to pathsWithout
                paths = pathFile[0]
                pathsWithout = paths.rsplit( ".", 1 )[ 0 ]  # remove .gz extension
                if not os.path.exists(pathsWithout):
                    print(pathsWithout + " doesn't exist. Attempting to gunzip " + paths)
                    r_gunzip = subprocess.call("gunzip -k -f " + paths, shell=True)
                if not os.path.exists(fileNameWithoutGz):
                    print(fileNameWithoutGz + " doesn't exist. Attempting to gunzip " + fileNameWithGz)
                    r_gunzip = subprocess.call("gunzip -k -f " + fileNameWithoutGz, shell=True)

                    print(fileName)
                    r = subprocess.run([basecommand, '--paramset', 'fzn', '-a', '--subsolver', 'chuffed', '--soft-defines', '--solver-timelimit', '100000000', '-t', '100800000', str(fileNameWithoutGz), str(pathsWithout)], universal_newlines=True, stdout=subprocess.PIPE)
                    p = r.stdout
                    print(str(p))
            finally:
                # delete pathsWithout and fileNameWithoutGz
                if os.path.exists(pathsWithout):
                    print(pathsWithout + " exists. Attempting to delete it (might fail if another thread does it first)")
                    r_delete = subprocess.call("rm " + pathsWithout, shell=True)
                if os.path.exists(fileNameWithoutGz):
                    print(fileNameWithoutGz + " exists. Attempting to delete it (might fail if another thread does it first)")
                    r_delete = subprocess.call("rm " + fileNameWithoutGz, shell=True)

            pattern = re.compile('(?<=MUS: )[0-9 ]+', re.MULTILINE)
            MUC = list(pattern.findall(str(p)))
            f = open(outputfile + fileName + "_MUC.txt", "w+")
            if MUC:
                for m in MUC:
                    f.write(m + '\n')


## main

if __name__ == '__main__':
        modelFiles = list(map(lambda x: x.replace('\\', '/'), modelFiles))
        uncompletedFiles = modelFiles[:]
        for fznFile in modelFiles:
            fileNameWithGz = fznFile
            fileNameWithoutGz = fileNameWithGz.rsplit( ".", 1 )[ 0 ]  # remove .gz extension
            fileName = fileNameWithoutGz[fileNameWithoutGz.rfind('/') + 1:][:(fileNameWithoutGz[fileNameWithoutGz.rfind('/') + 1:]).rfind('.')]
            if os.path.exists(outputfile+fileName+"_MUC.txt"):
                uncompletedFiles.remove(fznFile)
                completed += 1

        print("Processed " + str(completed) + " out of " + str(total) + " files. ")
        pool = Pool()
        result = pool.map_async(runChuffed, uncompletedFiles)
        pool.close()
        pool.join()
