# Code and data from the CPAIOR 2021 paper "Learning Variable Activity Initialisation for Lazy Clause Generation Solvers"

Ronald van Driel et al.
Delft University of Technology, NL
April 2021
copyright (c) 2020-2021 by R. van Driel et al.
GNU General Public Licence 3

contact: n.yorke-smith@tudelft.nl


## Description

This code accompanies the CPAIOR 2021 paper "Learning Variable Activity Initialisation for Lazy Clause Generation Solvers".

The paper is derived from the MSc thesis of Ronald van Driel.  The thesis is available from the TU Delft repository: https://repository.tudelft.nl/islandora/object/uuid%3A18359282-e769-47d5-ac62-4ee6e1ec454e?collection=education


## Dependencies at least

* Chuffed: https://github.com/chuffed/chuffed

* GCN: https://github.com/tkipf/gcn

* MiniZinc benchmarks: https://github.com/MiniZinc/minizinc-benchmarks

* MiniZinc toolchain, version 2.3

* Tensorflow


## Process and files

1. Download full minizinc benchmark dataset: https://github.com/MiniZinc/minizinc-benchmarks

2. Flatten all minizinc/data files to .fzn files while saving the .paths files: minizinc --solver chuffed --output-paths-to-file path_to/output.paths -I path_to/mznlib -o path_to/output.fzn -c path_to/minizinc.mznpath_to/data.dzn

3. Remove any instance containing “Satisfy” so that only minimization and maximization instances remain.

4. Remove any instance type causing chuffed to crash (such as trucking_hl).

5. Solve all remaining instances: fzn-chuffed -s -f -t 10800000 path_to/instance.fzn and save results to file.  Format: (timeout, optimal objective value, runtime)

6. Modify the .fzn files to become unsatisfiable by setting the domain of the objective value to never be able to reach the optimal objective value.

7. Extract and save the MUC from unsatisfiable instances and previously generated .paths files: findMUS -a --ignore-sat-model path_to/instance.fznpath_to/paths.paths.  Script: findMUS2.py

8. Use python script to translate the MUC information and unsatisfiable .fzn instances to data features and labels: trainingFlatzincToML.py

9. Train a classifier on the data features and labels (GCN, 200 epochs, 16 hidden layers, early stopping, dropout): gcn/gcn/train.py (run it in gcn/gcn folder, not gcn/ folder).  The GCN code is from Kipf and Welling: https://github.com/tkipf/gcn

10. Use a trained classifier to predict MUC of satisfiable instance: gcn/gcn/train.py (uses tensorflow)

11. Modify Chuffed to use prediction confidences as initial activity score for VSIDS heuristic.

12. Solve instances using modified version of Chuffed: runExperiments.py
