clear all
close all
clc
OCTC=0.958;
% number of points were we want to calculate the mie response
npoints=51;
n_medium=1;
% radii in nm
radius=[375/2, 375/2];
% wavelength in nm 
lamda_min=300;
lamda_max=800;
lamda=linspace(lamda_min,lamda_max,npoints);
% Create space for results and input parameter
qext=zeros(npoints,length(radius));
qext_norm=zeros(npoints,length(radius));
qsca=zeros(npoints,length(radius));
qabs=zeros(npoints,length(radius));
qback=zeros(npoints,length(radius));
gsca=zeros(npoints,length(radius));

% Calculation of the refractive indices
load CB_OCTC_958c.txt
data=zeros(length(CB_OCTC_958c(:,1)),3);
CB_evap_only_numbers=CB_OCTC_958c;
for i=1:length(CB_evap_only_numbers(:,1))
    
    % save the wavelength in decending order
    data(i,1)=CB_evap_only_numbers(length(CB_evap_only_numbers(:,1))-i+1,1)*1000;
    %save real part of the refractive index
    data(i,2)=CB_evap_only_numbers(length(CB_evap_only_numbers(:,1))-i+1,2);
    % save imaginary part of the refractive index
    data(i,3)=CB_evap_only_numbers(length(CB_evap_only_numbers(:,1))-i+1,3);   
    
end

clear CB_evap_only_numbers
real_part=interp1(data(:,1),data(:,2),lamda);
imag_part=interp1(data(:,1),data(:,3),lamda);
figure
plot(data(:,1),data(:,2),lamda,real_part)
%clear data

for i=1:length(radius)
    
    r=radius(i);
    for j=1:length(lamda)
        
        l=lamda(j)/n_medium;
        x=2*r*pi/l;
        refr=(real_part(j)+1i*imag_part(j))/n_medium;
        [s1,s2,qext(j,i),qsca(j,i),qback(j,i),gsca(j,i)]=mie(x,refr,4);
        
    end 
    qext_norm(:,i) =  qext(:,i) ./ max(qext(:,i));
    qabs(:,i)  = qext(:,i) - qsca(:,i);
end 
rho=1300*OCTC+1800*(1-OCTC);
MAC=1.5.*qabs./(2.*radius(1,1).*1e-9*rho*1000);
MSC=1.5.*qsca./(2.*radius(1,1).*1e-9*rho*1000);
SSA=qsca./qext;

figure()
plot(lamda ,MSC(:,1))
ylim([0 10])
hold on
plot(lamda ,MSC(:,2))
hold off
xlabel("Wavelength [nm]")
ylabel("MSC, m2/g")


figure()
plot(lamda ,MAC(:,1))
hold on
plot(lamda ,MAC(:,2))
hold off
xlabel("Wavelength [nm]")
ylabel("MAC, m2/g")

figure()
plot(lamda ,gsca(:,1))
hold off
xlabel("Wavelength [nm]")
ylabel("Asymmetry factor, g")

figure()
plot(lamda ,SSA(:,1))
hold off
xlabel("Wavelength [nm]")
ylabel("SSA")

% % create a excel file
lamda=lamda';
raw=zeros(size(MAC,1),5);

raw(:,1)=lamda(:,1);
raw(:,2)=MAC(:,1);
raw(:,3)=MSC(:,1);
raw(:,4)=gsca(:,1);
raw(:,5)=SSA(:,1);

filename_1='Mie_theory_sphere_CB_dp375nm_OCTC_958.xlsx';
sheet=1;
range='A1';
xlswrite(filename_1,raw,sheet,range);