README
======

Dataset title:  
    **Glacier surface elevation dataset accompanying the article "Monthly surface elevation data of arctic mountain glaciers"**

Files:

- `Glacier_surface_elevation__Alaska__Alaska_Peninsula-Aleutians__monthly_500x500m.nc`
- `Glacier_surface_elevation__Alaska__Alaska_Range-Wrangell-Kilbuck__monthly_500x500m.nc`
- `Glacier_surface_elevation__Alaska__North_Alaska__monthly_500x500m.nc`
- `Glacier_surface_elevation__Alaska__North_Coast_Ranges__monthly_500x500m.nc`
- `Glacier_surface_elevation__Alaska__Saint_Elias_Mountains__monthly_500x500m.nc`
- `Glacier_surface_elevation__Alaska__West_Chugach_Mountains-Talkeetna__monthly_500x500m.nc`
- `Glacier_surface_elevation__Arctic_Canada_North__Axel_Heiberg_and_Meighen_Is__monthly_500x500m.nc`
- `Glacier_surface_elevation__Arctic_Canada_North__Devon_Island__monthly_500x500m.nc`
- `Glacier_surface_elevation__Arctic_Canada_North__Melville_Island__monthly_500x500m.nc`
- `Glacier_surface_elevation__Arctic_Canada_North__North_Central_Ellesmere_Island__monthly_500x500m.nc`
- `Glacier_surface_elevation__Arctic_Canada_North__North_Ellesmere_Island__monthly_500x500m.nc`
- `Glacier_surface_elevation__Arctic_Canada_North__South_Central_Ellesmere_Island__monthly_500x500m.nc`
- `Glacier_surface_elevation__Arctic_Canada_North__South_Ellesmere_Island-Northwest_Devon__monthly_500x500m.nc`
- `Glacier_surface_elevation__Arctic_Canada_South__Bylot_Island__monthly_500x500m.nc`
- `Glacier_surface_elevation__Arctic_Canada_South__Cumberland_Sound__monthly_500x500m.nc`
- `Glacier_surface_elevation__Arctic_Canada_South__East_Central_Baffin_Island__monthly_500x500m.nc`
- `Glacier_surface_elevation__Arctic_Canada_South__Frobisher_Bay__monthly_500x500m.nc`
- `Glacier_surface_elevation__Arctic_Canada_South__North_Baffin_Island__monthly_500x500m.nc`
- `Glacier_surface_elevation__Arctic_Canada_South__Northeast_Baffin_Island__monthly_500x500m.nc`
- `Glacier_surface_elevation__Arctic_Canada_South__South_East_Baffin_Island__monthly_500x500m.nc`
- `Glacier_surface_elevation__Arctic_Canada_South__West_Baffin_Island__monthly_500x500m.nc`
- `Glacier_surface_elevation__Greenland_Periphery__East_Greenland__monthly_500x500m.nc`
- `Glacier_surface_elevation__Greenland_Periphery__North_Greenland__monthly_500x500m.nc`
- `Glacier_surface_elevation__Greenland_Periphery__South_East_Greenland__monthly_500x500m.nc`
- `Glacier_surface_elevation__Greenland_Periphery__South_West_Greenland__monthly_500x500m.nc`
- `Glacier_surface_elevation__Greenland_Periphery__West_Greenland__monthly_500x500m.nc`
- `Glacier_surface_elevation__Iceland__Iceland__monthly_500x500m.nc`
- `Glacier_surface_elevation__Russian_Arctic__Franz_Josef_Land__monthly_500x500m.nc`
- `Glacier_surface_elevation__Russian_Arctic__Novaya_Zemlya__monthly_500x500m.nc`
- `Glacier_surface_elevation__Russian_Arctic__Severnaya_Zemlya__monthly_500x500m.nc`
- `Glacier_surface_elevation__Scandinavia__North_Scandinavia__monthly_500x500m.nc`
- `Glacier_surface_elevation__Scandinavia__Southeast_Scandinavia__monthly_500x500m.nc`
- `Glacier_surface_elevation__Scandinavia__Southwest_Scandinavia__monthly_500x500m.nc`
- `Glacier_surface_elevation__Svalbard_and_Jan_Mayen__Svalbard__monthly_500x500m.nc`

The files of this dataset are formatted as NetCDF4 and follow NetCDF
Climate and Forecast (CF) Metadata Conventions CF-1.12. The distinctive
parts of the file names refer to the first and second order region names
according to the Randolph Glacier Inventory (RGI) version 7.0 \[1\]. The
explicit file name format is: Glacier_surface_elevation__\<first order
region name\>__\<second order region name\>__monthly_500x500m.nc. For
more information, please refer to the "Data" section below.

License: CC-BY-4.0

Contact: <j.m.haacker@tudelft.nl>

Summary
-------

Most glaciers currently decline because of the rapid climate change.
This dataset aims to aid glacier research by providing glacier surface
elevation estimates from radar altimetry. The dataset includes all
glaciers in the Arctic that are index in the Randolph Glacier Inventory
(RGI) version 7.0 \[1\]. The data are derived from the European Space
Agency's (ESA) mission CryoSat-2 \[2\], which is best suited for
glaciers covering several square kilometers. Where no observations were
available we interpolated using statistical methods. The present dataset
allows insights into dynamics of single glaciers, as well as into
regional or Arctic-wide trends.

The source data were provided by ESA.

Method
------

The open source Python software cryoswath equivalent to version
0.2.2.post3 \[3\] was used to produce the data. Installation
instructions are available on GitHub \[4\]. If you were to produce the
data yourself, you would need to execute the commands following this
paragraph in a Python shell after having installed cryoswath and its
dependencies. Further, you would need to loop over all the RGI v7.0
second order region codes that you wish to process. For the Scandinavian
glaciers, you should consider the first order region including all
glaciers until filling the voids in the last step, where you, in analogy
to other regions, should consider second order regions.

```python
for region_id in ["01-01", "01-02", "08_scandinavia", ]:
    cryoswath.l1b.download_wrapper(region_id, buffer_region_by=30_000)
    cryoswath.l3.cache_l2_data(region_id)
    cryoswath.l3.build_dataset(region_id)
for o2region in ["01-01", "01-02", "08-01", ]:
    cryoswath.l4.fill_l3_voids(o2region)
cryoswath.l4.add_meta_to_default_finalized_l3("../data/results")
```

The above would create the files provided with this dataset in the
directory "../data/results" (assuming that you run the code from the
"scripts" directory and created the "results" directory before hand).

Please refer to the associated article for detailed information.

Data
----

The NetCDF files contain variables as data arrays that are structured
along named dimensions.

Dimensions:

- `time`: 174 values as "days since 2010-06-01 00:00:00" indicating the
  concerned month
- `x`: Projected coordinates referring to the projection in the global
  attribute `spatial_ref`.
- `y`: The second projected coordinate (see `x`).

Variables:

- `elev_diff`: Glacier surface height in meter above a reference
  elevation. The reference elevation is stored in variable
  `elev_diff_ref`. The sum of both gives the height above the WGS84
  ellipsoid.
- `elev_diff_ref`: Reference surface height above the WGS84 ellipsoid.
  This variable is derived from ArcticDEM v4.1 100 m mosaik by linear
  interpolation to the current raster.
- `elev_diff_error`: Standard deviation of height observations. It is
  derived from the interquartile range of those point height estimates
  that are aggregated into the current raster cell.
- `elev_diff_obs_count`: Number of point height estimates that are
  aggregated into the current raster cell. Note: this is not the number
  of independent measurements.
- `elev_diff_interp_flag`: This flag indicates how voids were filled.
  - -2: \"failed\" indicates failure of the interpolation (should not
  occur)
  - -1: \"no data\" outside of glaciers (overridden by _FillValue)
  - 0: \"observed\" were not filled
  - 1: \"cell-based\" use a season-aware linear trend model
  - 2: \"basin-based\" use a hypsometric model per time step
  - 3: \"group-based\" are like (2) but fit the model to all cells in a
  group of basins
  - 4: \"linear 1 year\" linearly interpolates values within the period
  of 1 year per cell
  - 5: \"subregion-wide\" does the same as (2) and (3) using all cells
  per time step
  - 6: \"linear/const cell-based\" fills all remaining gaps per cell
  with the temporally interpolated value and with the nearest value at
  the start and end of the dataset.
- `basin_id`: Integer value used to identify RGI version 7.0 glaciers.
  The values are unique within first order RGI regions. They are the
  same as used by RGI as last part of the RGI glacier identifier.
- `group_id`: Integer value used to identify groups of RGI version 7.0
  glaciers. The values are composed of a sign from the groups latitude,
  followed by the glacier terminus type according to RGI v7.0 being
  either 0 for land terminating, 1 for tidewater glacier, or 9 for not
  assigned. Further, the rounded absolute latitude and the rounded
  longitude (0-360 E) are attached.

References
----------

\[1\] RGI 7.0 Consortium, 2023. Randolph Glacier Inventory - A Dataset
    of Global Glacier Outlines, Version 7.0. NSIDC: NASA National Snow
    and Ice Data Center https://doi.org/10.5067/F6JMOVY5NAVZ (2023).  
\[2\] https://www.eoportal.org/satellite-missions/cryosat-2
\[3\] Haacker, J., 2025. cryoswath: Patched v0.2.2 (Version v0.2.2.post3) [Computer software]. Zenodo. https://doi.org/10.5281/ZENODO.16457170
\[4\] https://github.com/j-haacker/cryoswath
