################################################################
#    LD blocks selection and candidate genes                  #
################################################################

#Load the following packages:

#library(SNPRelate)
library(trio)


#First we upload the GWAs object with all the info
# about the genotypes, SNPs, samples: from rice_90k_pipelineFormat.RData

## Data input
load("rice_90k.RData")


# List of rice genotypes studied
genotype <- read.table("genotypes_in_our_study.txt", h = T)

## Generate a list with all SNPs positions (from selected SNPs)
#SNPs_popul <- GWAS.obj$markers[selectedSNPs$snp.name, ]
SNPs_popul <- GWAS.obj$markers
SNPs_popul <- SNPs_popul[, genotype$genotype]
snp <- GWAS.obj$map[rownames(SNPs_popul), ]


################################################################################
### Chromosome search
################################################################################
# Input chromosome data
Chr1 <- read.table("chromosome_search/Chr1.gff3", h = F, sep = "\t")
Chr2 <- read.table("chromosome_search/Chr2.gff3", h = F, sep = "\t")
Chr3 <- read.table("chromosome_search/Chr3.gff3", h = F, sep = "\t")
Chr4 <- read.table("chromosome_search/Chr4.gff3", h = F, sep = "\t")
Chr5 <- read.table("chromosome_search/Chr5.gff3", h = F, sep = "\t")
Chr6 <- read.table("chromosome_search/Chr6.gff3", h = F, sep = "\t")
Chr7 <- read.table("chromosome_search/Chr7.gff3", h = F, sep = "\t")
Chr8 <- read.table("chromosome_search/Chr8.gff3", h = F, sep = "\t")
Chr9 <- read.table("chromosome_search/Chr9.gff3", h = F, sep = "\t")
Chr10 <- read.table("chromosome_search/Chr10.gff3", h = F, sep = "\t")
Chr11 <- read.table("chromosome_search/Chr11.gff3", h = F, sep = "\t")
Chr12 <- read.table("chromosome_search/Chr12.gff3", h = F, sep = "\t")


# With a fixed 75kb confidance interval for all SNPs


windows <- read.table("SNPs_75K_windows_multi_gwas_LOD4_topSNPs", h = T, sep = "\t", row.names = 1)

# create new clumns in 'windows' to store data
windows$ChrFile <- paste("Chr", windows$Chr, sep = "")
windows$nGenes <- rep(NA, nrow(windows))

# create table to store data on genes detected for each SNP
genes <- matrix(NA, ncol = 4)
colnames(genes) <- c("locus", "gene", "description", "SNP")

# obtain data on genes per block (associated to each SNP)
for(i in 1:nrow(windows)){
  x <- get(windows[i, "ChrFile"])
  a <- windows[i, "BlockLeft"]
  b <- windows[i, "BlockRight"]
  x <- x[x$V4 >= a & x$V5 <= b, ]
  x <- x[x$V3 == "gene", ]
  windows$nGenes[i] <- nrow(x)
  if(nrow(x) > 0){
    write.table(x, file = paste(rownames(windows[i, ]), "_genes.csv", sep = ""), sep = ";")
    for(j in 1:nrow(x)){
      genes <- rbind(genes, c(strsplit(as.character(x$V9[j]), split = ";")[[1]], rownames(windows[i, ])))
    }
  }
}

# format table with genes 
genes <- genes[-1, ]
genes <- as.data.frame(genes)


# save results to file
write.table(windows, file = "LDblocks_multitrait_topSNPs.csv", sep = ";")
write.table(genes, file = "genes_multitrait_topSNPs.csv", sep = ";")



