require(tidyverse)
require(ggplot2)

load(file.path("data","processed","wsnew.Rdata"))

tbs <- wsnew %>%
  filter(seizoen=="Najaar")%>%
  mutate(zout=ifelse(rd_x>60000 & rd_y < 379000+rd_x-60000,"brak","zout" )) %>%
  group_by(soortnaam,monster_id,rd_x,rd_y,zout,positie,dynamiek,diepte_hoo,jaar)%>%
  summarise(sumbiom=sum(biomassa_mg_m2,na.rm=T)/1000) 

freq<-tbs %>% group_by(soortnaam) %>% summarize(n=n()) 
write.csv(freq,file=file.path("data","processed","freq.Csv"))
freq<-read.csv(file.path("data","processed","freq_edit.csv")) #grouping of taxa manually edited in file
for (i in 1:nrow(freq)){
  nieuw<-freq$vervang[i]
  oud<-freq$soortnaam[i]
  if (nieuw!=""){
    if(nieuw=='none'){tbs<-tbs[-which(tbs$soortnaam==oud),]
    } else {tbs$soortnaam[tbs$soortnaam==oud]<-nieuw}
  } 
}
sp_gr<-read.csv(file.path("data","processed","sp_gr2.csv"))
names(sp_gr)<-c("soortnaam","groep")
grps<-unique(sp_gr$groep)
tbs <- tbs %>%
  group_by(soortnaam,monster_id,rd_x,rd_y,zout,positie,dynamiek,diepte_hoo,jaar)%>%
  summarise(sumbiom=sum(sumbiom,na.rm=T)) %>%
  ungroup()%>%
  left_join(sp_gr,by="soortnaam")

tbg <- tbs %>%
  group_by(groep,monster_id,rd_x,rd_y,zout,positie,dynamiek,diepte_hoo,jaar)%>%
  summarise(sumbiom=sum(sumbiom,na.rm=T)) %>%
  ungroup()
  

freq<-tbs %>% group_by(soortnaam) %>% summarize(n=n(),smb=sum(sumbiom)) %>% arrange(desc(smb))

cumser<-freq$smb
for(i in 2:length(cumser))cumser[i]<-cumser[i]+cumser[i-1]
n95<-min(which(cumser>cumser[length(cumser)]*0.95))
smps <- tbs %>%
  select(-sumbiom,-soortnaam,-groep) %>% 
  distinct(monster_id,.keep_all = TRUE)

pdf(file.path("output","trends_by_species.pdf"))

# eerste 24 zijn samen >95% van de totale gevangen biomassa
for(i in 1:(n95+length(grps))){
  for(z in c("zout","brak")){
    for (pos in c("sublitoraal","litoraal")){
      tit<- paste(z,pos,ifelse(i<=n95,freq$soortnaam[i],grps[i-n95]))
      if(i<=n95){
        tt <- tbs %>%
          filter(zout==z & positie == pos & jaar>2008 & soortnaam==freq$soortnaam[i]) %>%
          select(monster_id,sumbiom)
      } else {
        tt <- tbg %>%
          filter(zout==z & positie == pos & jaar>2008 & groep==grps[i-n95]) %>%
          select(monster_id,sumbiom)
      }
      tt <- smps %>% 
        filter(zout==z & positie == pos & jaar>2008) %>%
        left_join(tt,by="monster_id") %>%
        mutate(sumbiom=ifelse(is.na(sumbiom),0,sumbiom))
      ttt<- tt %>%
        group_by(jaar) %>%
        summarize(mn=mean(sumbiom),sds=sd(sumbiom),n=n())%>%
        mutate(se=sds/sqrt(n))
      if(class(try(loess(sumbiom~jaar,tt)))=="loess"){
        ll<-loess(sumbiom~jaar,tt)
        if(class(try(predict(ll,seq(2009,2020,by=0.1),se=T)))!="try-error"){
          predll<-predict(ll,seq(2009,2020,by=0.1),se=T)
          lin<-data.frame(x=seq(2009,2020,by=0.1),
                          y=predll$fit,
                          ymin=predll$fit-predll$se.fit,
                          ymax=predll$fit+predll$se.fit)
          #      lims<-c(0,ifelse(grepl("sub",tit),200,60))
          
          p<-ggplot()+
            scale_y_continuous()+ #(limits=lims)+
            geom_point(ttt,mapping=aes(x=jaar,y=mn))+
            geom_errorbar(ttt,mapping=aes(x=jaar,ymin=mn-se,ymax=mn+se))+
            geom_line(lin,mapping=aes(x=x,y=y),color='blue',lwd=1)+
            geom_ribbon(lin,mapping=aes(x=x,ymin=ymin,ymax=ymax),
                        alpha=0.1, linetype="dashed",color="grey")+
            ggtitle(tit)+xlab("Jaar")+ylab("Totale Biomassa")
          print(p)
        }
      }
    }
  }
}

tt1 <- tbg %>%
  filter(jaar>2008) %>%
  select(monster_id,sumbiom,groep,zout,positie)
tt2 <- smps %>% 
  filter(jaar>2008) %>%
  select(-zout,-positie) %>%
  left_join(tt1,by="monster_id")  %>%
  mutate(sumbiom=ifelse(is.na(sumbiom),0,sumbiom)) %>%
  pivot_wider(names_from = groep,values_from = sumbiom)%>%
  mutate(Crustacea=ifelse(is.na(Crustacea),0,Crustacea),
         Mollusca=ifelse(is.na(Mollusca),0,Mollusca),
         Other=ifelse(is.na(Other),0,Other),
         Polychaeta=ifelse(is.na(Polychaeta),0,Polychaeta),
         Echinodermata=ifelse(is.na(Echinodermata),0,Echinodermata)) %>%
  pivot_longer(cols=c("Crustacea","Mollusca","Other","Polychaeta","Echinodermata"),
               names_to="groep",values_to="sumbiom") %>%
  group_by(zout,positie,jaar,groep) %>%
  summarize(mn=mean(sumbiom))
for(z in c("zout","brak")){
  for(pos in c("litoraal","sublitoraal")){
    tt3<-tt2 %>% filter(positie==pos,zout==z)
    p<- ggplot(tt3,aes(x=jaar,y=mn,fill=groep))+
      geom_area()+
      ggtitle(paste(z,pos))+xlab("Jaar")+ylab("Totale Biomassa")
    print(p)
  }
}


dev.off()
