%% Useful Links about PSO
% https://nl.mathworks.com/help/gads/particleswarm.html
% https://nl.mathworks.com/help/gads/tune-particleswarm-optimization-process.html
load ('bangap_PSO.mat');
co_min = 11301;
co_max = 12000;
Result_PSO = zeros(co_max-co_min+1,7);                   %prealocation
OutputMessage_PSO = cell(co_max-co_min+1,1);             %prealocation
format long;
for LandCoordIndex=co_min:1:co_max
tic; 
lower_boundry = [bangap_PSO(LandCoordIndex,1)-0.05, 1, 1e12, LandCoordIndex];
upper_boundry = [bangap_PSO(LandCoordIndex,1)+0.05, 1000, 1e12, LandCoordIndex];
rng default  % For reproducibility
% options = optimoptions('particleswarm', 'SwarmSize',20, 'MaxIterations',20, 'MaxStallTime', 10*60, 'MaxStallIterations', 10, 'InertiaRange', [0.05,1.1], 'FunctionTolerance',1e-6);
% options = optimoptions('particleswarm', 'SwarmSize',20, 'PlotFcn',@pswplotbestf, 'MaxIterations',20, 'MaxStallTime', 10*60, 'MaxStallIterations', 10, 'InertiaRange', [0.05,1.1], 'HybridFcn', @fmincon, 'Display','iter','FunctionTolerance',1e-6);
options = optimoptions('particleswarm', 'SwarmSize',20, 'MaxIterations',20, 'MaxStallTime', 10*60, 'MaxStallIterations', 10, 'InertiaRange', [0.05,1.1], 'HybridFcn', @fmincon, 'FunctionTolerance',1e-6);
[x,fval,exitflag,output] = particleswarm(@ObjFunc_PSO3,4,lower_boundry,upper_boundry,options);
% fprintf(formatstring,fval,output.funccount);
elapsedTime = toc;
Result_PSO(LandCoordIndex,:) = [round(elapsedTime/60) output.funccount 1-fval x];
OutputMessage_PSO{LandCoordIndex,:} = output;
end
clearvars -except Result_PSO OutputMessage_PSO co_min co_max
save('Q:\hesanziar\Ideas\2021-World map efficiency\Tanja_SMARTS\All world results\Tandem\Result_tandem_2T_PSO3_OptimumPoints.mat');
mkdir(fullfile(sprintf('%s_%d-%d', 'Results_1x1',co_min,co_max))); %makes a folder including range of the target coordinates
movefile ('Result_tandem_2T_PSO3_OptimumPoints.mat', fullfile(sprintf('%s_%d-%d', 'Results_1x1',co_min,co_max))) %moves all .mat files to the result folder, if folder already exists it overwites


