function [ eta ] = Detailed_Limit( lamda_nm, E_global_lamda, Tc, Eg, Fg)
%This fuction calculate solar cell theoretical efficiency using the approach 
% described in 
% paper: Reassessment of the limiting efficiency for crystalline silicon solar cells
% IEEE JPV (2013)
% Code is written by Hesan Ziar
%% Initialization
clear all;
c = 299792458;                                                              % Speed of light (m/s)
k = 1.38064852e-23;                                                         % Boltzmann constant (m2 kg/s2 K) 
q= 1.60217662e-19;                                                          % Electron charge (Coulombs)
h = 6.62607004e-34;                                                         % Plack constant (m2 kg / s  or Joule.Second)
addpath('Q:\hesanziar\Ideas\2021-World map efficiency\Tanja_SMARTS\All world results\global silicon PV efficiency');
%addpath('H:\My Documents\MATLAB');
load ('ASTMG173.mat');                                                      % 'lamda_nm' , 'E_global_lamda', and 'E_beam_lamda' are the variable inputs from ASTMG173
% load ('G_POA_1h_2019_avg_raw_BRL_world.mat');
% load ('Ex_global_lamda_world.mat')
% load ('G_POA_mean_BRL_world.mat');
% load ('Tair_C_Daily_avg_2019_input.mat');
% load ('GPoA_Tamb_Average_WeightedAverage.mat');
% load ('Land_coord.mat');
load ('wvlngth.mat');
lamda_nm = wvlngth;
lamda =1e-9*lamda_nm;
E = (h*c)./lamda;
N_donor = logspace(12,13,3); % n-type doping concenteration
N_acceptor = 0;               % p-type doping concenteration
Width = [1:1:75]*1e-6;          %Width of silicon in m
NOCT = 48;
Eg=1.12;                                                                    %Bandgap of Silicon, used to determine the voltage range for calculation
Vstart=0.000;
Vstep=0.0005;
Vend = Eg;
V = [Vstart:Vstep:Vend];
T_min = 342;   %same temperature range as the work of D. Akira Engelbrecht and Thomas Tiedje, 2021, IEEE JPV
T_max = 400;
T_step = 2;
Result = zeros (((T_max-T_min)/T_step)+1, 14);
counter = 1;
bifacial = 2;    % for bifacial modeling =2, for monofacial modeling = 1;
for CellTemperature=T_min:T_step:T_max
E_global_lamda = E_global_lamda;   
%load ('ASTMG173_HighResolution.mat');                                      % 'lamda_nm' , 'E_global_lamda', and 'E_beam_lamda' are the variable inputs from ASTMG173 >>> High Resolution (0.5 nm)
%load ('ASTMG173_Exergy.mat');                                              % 'lamda_nm' , 'E_global_lamda', and 'E_beam_lamda' are the variable inputs from ASTMG173
%load ('VoltageVector1.mat');

%T = input('insert absorber temperature in Kelvin  = ');                    %temperature kelvin
T = CellTemperature;

%T = 298.15; %temperature kelvin
%N_donor = input('insert the concenteration of the donor atoms in cm-3  = ');    % n-type doping concenteration
%N_donor = logspace(12,17,10);
%N_acceptor = input('insert the concenteration of the acceptor atoms in cm-3  = '); % p-type doping concenteration
%N_acceptor = 0;
%ni_0 = 8.28e9;                                                              % intrinsic carrier concenteration at 25C from the Richter IEEE JPV paper, 2013.
ni_0 = 5.29e19 * ((T/300)^2.54) * exp(-6726/T) ;                             % Temperature dependent intrinsic carrier concentration from K. Misiakos and Tsamakis, D., Journal of Applied Physics, vol. 74, no. 5, p. 3293, 1993.
%delta_Eg = 0;                                                               %assuming there is no bandgap narrowing (need this to intialize)
%Width = input('insert the width of silicon in m  = ');                          %Width of the silicon absorber
%W = [1:1:1000]*1e-6;
%W = logspace(-6,-3,10)


% Vstart = VoltageVector (1,1); 
% Vend = VoltageVector (1,end); 
% V = VoltageVector;

%Ex_global_lamda = G_POA_1h_2019_avg_raw_BRL_world{LandCoordIndex,1};                               %converts AM 1.5 Exergy spectral irradiance into spectral photon flux (C/m2 s)
phi_lamda = ((q.*lamda)./(h*c)).*(E_global_lamda);                      %converts AM 1.5 Exergy spectral irradiance into spectral photon flux (C/m2 s)
total_incoming_radiation = trapz(lamda_nm, E_global_lamda);                %total incoming radiation 
%phi_lamda = ((q.*lamda)./(h*c)).*(E_global_lamda);                          %converts AM 1.5 spectral irradiance into spectral photon flux (C/m2 s)
%phi_lamda = ((q.*lamda)./(h*c)).*(Ex_global_lamda);                        %converts AM 1.5 spectral irradiance into spectral photon flux (C/m2 s)
%normalized_total_incoming_radiation = 1000;                                % in W/m2 
%phi_lamda = (normalized_total_incoming_radiation/total_incoming_radiation)*((q.*lamda)./(h*c)).*(E_global_lamda);      %converts AM 1.5 spectral irradiance into spectral photon flux (C/m2 s) and normalized by 0.1 W/cm2 (1000 W/m2)
%% Pre-allocation
Pmpp = zeros (length(N_donor), length(Width));
eta = zeros (length(N_donor), length(Width));
Jsc_mApercm2 = zeros (length(N_donor), length(Width));
Voc = zeros (length(N_donor), length(Width));
FF = zeros (length(N_donor), length(Width)); 
delta_n_mpp = zeros (length(N_donor), length(Width)); 
Tau_mpp = zeros (length(N_donor), length(Width));
delta_n_oc = zeros (length(N_donor), length(Width));
Vmpp = zeros (length(N_donor), length(Width));

Photon_Rec_Width = zeros (length(Width), length(V));
B_integral_Width = zeros (length(Width), length(V));
BGN_values = zeros (length(N_donor), length(V));
ni_eff_values = zeros (length(N_donor), length(V));
delta_n_values = zeros (length(N_donor), length(V));
%step_absorptance =  zeros (length(lamda), length(N_donor));

minimum = zeros (1, length(Width));
x = zeros (1, length(Width));
y = zeros (1, length(Width));

%% loop
for j = 1:1:length(N_donor)
Nd = N_donor(1,j);
Na = N_acceptor;
% [Nd_plus, Na_minus] = Incompelte_Ioization(Nd, Na, k, T, n, p);           %Incomplte Inoization funtion is inrtegrated within the Carrier_Statistics function
%[n0, p0, n, p, delta_n, ni_eff, delta_Eg] = Carrier_Concentration(Nd, Na, T, V, ni_0, Eg);
[n0, p0, n, p, delta_n, ni_eff, delta_Eg, Nd_plus(j,1), Na_minus(j,1), iid, iia] = Carrier_Statistics(Nd, Na, T, V, ni_0, Eg);

BGN_values (j,:) = delta_Eg;
ni_eff_values (j,:) = ni_eff;
delta_n_values (j,:) = delta_n;
Nd
iid
iid_values (j,:) = iid;
iia_values (j,:) = iia;
ni_eff (:,1)  
delta_Eg (:,1)

% Eg = 1.12 - delta_Eg;
% lamda_g = (h*c)./(q*Eg);
% unitstep (:,j) = lamda>lamda_g;
% step_absorptance (:,j) = ones(1,1)-unitstep (:,j);
[mu_e, mu_h, sigma_e, sigma_h, sigma, rho] = Carrier_Mobility (Nd, Na, n, p, T);


[alpha_bb, n_r] = Silicon_Optical_Constants(T);
[alpha_FCA_n,alpha_FCA_p] = Free_Carrier_Absorption(Nd, Na, T, V, n, p);
alpha_FCA = alpha_FCA_p + alpha_FCA_n;
for i = 1:1:length(Width)
W = Width(1,i);
[R_intr, Photon_Rec, B_integral] = Intrinsic_Recombination_Rate(Nd, Na, T, V, W, n, p, n0, p0, delta_n, ni_eff);
Photon_Rec_Width(i,:) = Photon_Rec;
B_integral_Width(i,:) = B_integral;

A_bb = (alpha_bb*ones(1,length(V))) ./ (alpha_bb*ones(1,length(V)) + alpha_FCA + (bifacial./(4.*((n_r.^2)*W*1e+2)))*ones(1,length(W)));
%A_bb = ((step_absorptance (:,j).*alpha_bb)*ones(1,length(V))) ./ (alpha_bb*ones(1,length(V)) + alpha_FCA + (1./(4.*((n_r.^2)*W*1e+2)))*ones(1,length(W)));
%J_L = q*trapz(flip(E), flip(A_bb.*(E_global_lamda*ones(1,length(W))))); 
J_L_mApercm2 = (1e3/1e4).*trapz(lamda_nm, A_bb.*(phi_lamda*ones(1,length(V))));     %0.1 coeffieinct is to convert A/m2 to mA/cm2
J_mApercm2 = (J_L_mApercm2) - 1000*q*((W*1e+2).*real(R_intr));                     %starngely one time it gave complex numbers for R then I added real(R)!! % qWR is in A/cm2, multiplied by 1000 to convert to mA/cm2                                 %from Richter et al., IEEE JPV (2013)
                                                                                    %It was because delta_n for the very low voltage values gets negative sometimes.        
J_Aperm2 = J_mApercm2*10;
P = J_Aperm2.*V;
Pmpp(j,i) = max(P);                                        %Pmpp in W/m2
eta(j,i) = (Pmpp(j,i))./total_incoming_radiation;      
%eta(j,i) = (Pmpp(j,i))./normalized_total_incoming_radiation; 

Jsc_mApercm2 (j,i) = max (J_mApercm2);
minimum (1,i) = min(abs(J_mApercm2));
x(1,i)=find(abs(J_mApercm2) == minimum(1,i));
Voc (j,i) = Vstart+(Vstep.*(x(1,i)-1));
%Voc (j,i) = VoltageVector(1,x(1,i)); 
FF (j,i) = Pmpp(j,i) / (10.*(Voc(j,i)*Jsc_mApercm2(j,i))); 
y(1,i)=find(P == Pmpp(j,i));
delta_n_mpp(j,i) = delta_n(1, y(1,i)); 
Tau_mpp(j,i) = delta_n_mpp(j,i)/R_intr(1, y(1,i));
delta_n_oc(j,i) = delta_n(1, x(1,i)); 
Tau_oc(j,i) = delta_n_oc(j,i)/R_intr(1, x(1,i));
Vmpp(j,i) = V(1, y(1,i));
[CellTemperature,j,i]

Resistivity_sc (j,i)= rho(1,1);             %Resistivity at V=0 (ohm.cm)
Resistivity_oc (j,i)= rho(1,x(1,i));        %Resistivity at V=VOC (ohm.cm)
Resistivity_mpp (j,i)= rho(1,y(1,i));       %Resistivity at V=VMPP (ohm.cm)
L_mpp(j,i) = sqrt((k*T/q)*(mu_h*Tau_mpp(j,i)));            %Minroty carrier diffusion length at Vmpp (cm)
L_oc(j,i) = sqrt((k*T/q)*(mu_h*Tau_oc(j,i)));            %Minroty carrier diffusion length at Voc (cm)

end
end
[index_row,index_column]=find(eta==max(max(eta)));
Result(counter,:) = [eta(index_row,index_column) Voc(index_row,index_column) Jsc_mApercm2(index_row,index_column) 100*FF(index_row,index_column)...
        Vmpp(index_row,index_column) delta_n_mpp(index_row,index_column) delta_n_oc(index_row,index_column) 1e6*Width(1,index_column)...
        BGN_values(index_row,index_column) ni_eff_values(index_row,1) Nd_plus(index_row,1)-Na_minus(index_row,1) Resistivity_mpp(index_row,index_column)...
        (1e4*L_mpp(index_row,index_column))/(1e6*Width(1,index_column)) CellTemperature];
counter = counter + 1;
end
clearvars -except Result T_min T_max
save('Q:\hesanziar\Ideas\2021-World map efficiency\Tanja_SMARTS\All world results\global silicon PV efficiency\Result_siliconPV_efficiency_STC_VariableTemperature_bifacial.mat');
mkdir(fullfile(sprintf('%s_%d-%d', 'Results_STC_VariableTemperature_bifacial',T_min,T_max))); %makes a folder including range of the target coordinates
movefile ('Result_siliconPV_efficiency_STC_VariableTemperature_bifacial.mat', fullfile(sprintf('%s_%d-%d', 'Results_STC_VariableTemperature_bifacial',T_min,T_max))) %moves all .mat files to the result folder, if folder already exists it overwites
end