function [Nd_plus, Na_minus, iid, iia] = Incompelte_Ioization(Nd, Na, k, T, n, p)
%UNTITLED2 Summary of this function goes here
%   Detailed explanation goes here  
%% Incomplete inonization based on Altermatt_2006 el al. (part II of the paper)
q= 1.60217662e-19;                                                          % Electron charge (Coulombs)
E_dop0_SiP = 45.5;      %meV
E_dop0_SiB = 44.39;     
Nref_SiP = 3e18;        %cm-3
Nref_SiB = 1.7e18;
c_SiP = 2;              %no unit
c_SiB = 1.4;            
Nb_SiP = 6e18;          %cm-3
Nb_SiB = 4.5e18;        
d_SiP = 2.3;            %no unit
d_SiB = 2.4;
g_SiP = 0.5;            %no unit
g_SiB = 0.25;

b_SiP = 1/(1+(Nd/Nb_SiP)^d_SiP);
b_SiB = 1/(1+(Na/Nb_SiB)^d_SiB);

E_dop_SiP = (E_dop0_SiP*1e-3*q)/(1+(Nd/Nref_SiP)^c_SiP);
E_dop_SiB = (E_dop0_SiB*1e-3*q)/(1+(Na/Nref_SiB)^c_SiB);

%m0 = 9.11e-31;          %m0 is the "free electron rest mass" equals 9.11e-31 kg
Nc_300K = 2.89e19;       %for crystaline silicon at 300K, unit is cm-3 obtained from PVlighthouse
Nv_300K = 3.14e19;
Nc = Nc_300K * (T/300)^1.5;
Nv = Nv_300K * (T/300)^1.5;

n1 = Nc*exp(-E_dop_SiP/(k*T));
p1 = Nv*exp(-E_dop_SiB/(k*T));

Nd_plus = Nd * (1- (b_SiP*n/(n + g_SiP*n1)));
Na_minus= Na * (1- (b_SiB*p/(p + g_SiB*p1)));
iid = Nd_plus/Nd;
iia = Na_minus/Na;

%save ('Incompelte_Ioization');
%save('C:\hesanziar\Ideas\2018-Thermodynamic Limit\MATLAB results1\Incompelte_Ioization.mat');
end

