function [alpha_FCA_n,alpha_FCA_p] = Free_Carrier_Absorption(Nd, Na, T, V, n, p)
%UNTITLED6 Summary of this function goes here
%   Detailed explanation goes here
% Parametrization for free carrier absoption based on Green fomulation 
% the formulation is described in Rudiger el al. IEEE Trans Electron device (2013) 
% it is assumed that the doping concenteration across the device is uniform
% (Richter 2013 did the same assumption)
load ('Silicon_Absorption_Coeff_300K.mat');
%load('Silicon_Absorption_Coeff_300K_HighRes.mat')
%Example inputs
%%
%Nd = 1e19;
%Na = 0;
%T = 300;
k = 1.38064852e-23;                                                         % Boltzmann constant (m2 kg/s2 K) 
q= 1.60217662e-19;                                                          % Electron charge (Coulombs)
% Eg=1.12;
% Vstart=0.001;
% Vstep=0.001;
% Vend = Eg;
% V = [Vstart:Vstep:Vend];
ni_0 = 8.28e9;                 % intrinsic carrier concenteration at 25C from the Richter IEEE JPV paper, 2013.
%delta_Eg = 0;                   %assuming there is no bandgap narrowing
%%
%[n0, p0, n, p, delta_n, ni_eff] = Carrier_Constants(Nd, Na, ni_0, k, T, V, delta_Eg);

%n0 = 0.5 * ((Nd-Na) + sqrt((Nd-Na)^2 + (4*ni_0^2)));    %where Nd > Na   (n-type)
%p0 = 0.5 * ((Na-Nd) + sqrt((Na-Nd)^2 + (4*ni_0^2)));   %where Na > Nd   (p-type) 
%---
% zeta = 3; 
% phi = 2;
% C_FCA_n = 2.6e-18;
% C_FCA_p = 2.7e-18;                                                                 % Green alpha_FCA model (for <1000nm)
% alpha_FCA_n(1:841,:) = C_FCA_n * ((lamda_um(1:841,:)*1e-6./1e-6).^zeta) * n(:,1:841);      % alpha_FCA unit is cm-1
% alpha_FCA_p(1:841,:) = C_FCA_p * ((lamda_um(1:841,:)*1e-6./1e-6).^phi) * p(:,1:841);        % row 841 corresponds to 1000 nm (better to use find function)
% 
% zeta = 2.6; 
% phi = 2.4;
% C_FCA_n = 1.8e-18;
% C_FCA_p = 2.6e-18;                                                                  % Rudiger alpha_FCA model (for >1000nm)
% alpha_FCA_n(842:end,:) = C_FCA_n * ((lamda_um(842:end,:)*1e-6./1e-6).^zeta) * n(:,842:end);    % alpha_FCA unit is cm-1
% alpha_FCA_p(842:end,:) = C_FCA_p * ((lamda_um(842:end,:)*1e-6./1e-6).^phi) * p(:,842:end);     % row 842 corresponds to the row after 1000 nm (better to use find function)
%---
zeta = 2.6; 
phi = 2.4;
C_FCA_n = 1.8e-18;
C_FCA_p = 2.6e-18;                                                                  % Rudiger alpha_FCA model 
alpha_FCA_n = C_FCA_n * ((lamda_um*1e-6./1e-6).^zeta) * n;                          % alpha_FCA unit is cm-1
alpha_FCA_p = C_FCA_p * ((lamda_um*1e-6./1e-6).^phi) * p;     
%---
% zeta = 3; 
% phi = 2;
% C_FCA_n = 2.6e-18;
% C_FCA_p = 2.7e-18;                                                                 % Green alpha_FCA model (for <1000nm)
% alpha_FCA_n = C_FCA_n * ((lamda_um*1e-6./1e-6).^zeta) * n;      % alpha_FCA unit is cm-1
% alpha_FCA_p = C_FCA_p * ((lamda_um*1e-6./1e-6).^phi) * p;        % row 841 corresponds to 1000 nm (better to use find function)

alpha_FCA = alpha_FCA_p + alpha_FCA_n;

%save ('Free_Carrier_Absorption');
%save('C:\hesanziar\Ideas\2018-Thermodynamic Limit\MATLAB results1\Free_Carrier_Absorption.mat');
end

