function [mu_e, mu_h, sigma_e, sigma_h, sigma, rho] = Carrier_Mobility (Nd, Na, n, p, T)
%UNTITLED2 Summary of this function goes here
% This code calcuates carrier mobility, cinductance and resitivity 
% of silicon based on Arora e. al model (1982) 
% Written by Hesan Ziar April 2021 
q= 1.60217662e-19;                                                          % Electron charge (Coulombs)
N = Nd - Na;
Tn = T/300;
mu_e = 88*(Tn^-0.57) + 7.4e8*(T^-2.33) ./ (1+0.88*(Tn^-0.146).*(N./(1.26e17*(Tn^2.4))));    %electron mobility in silicon in cm2/V.s
mu_h = 54.3*(Tn^-0.57) + 1.36e8*(T^-2.23) ./ (1+0.88*(Tn^-0.146).*(N./(2.35e17*(Tn^2.4)))); %hole mobility in silicon in cm2/V.s 
sigma_e = q.*n.*mu_e;               %conductivity for electrons
sigma_h = q.*p.*mu_h;               %conductivity for holes
sigma = sigma_e + sigma_h;          %total conductivity
rho = 1./sigma;                     %resitivity  (ohm.cm)   
%save ('Carrier_Mobility');
end

