function [delta_Eg, delta_Ev, delta_Ec] = Band_Gap_Narrowing(T, Nd, Na, n, p)
%UNTITLED3 Summary of this function goes here
%   Detailed explanation goes here >>> STILL I HAVE TO WORK ON IT
%Bang gap narrowing (BNG) model_Schenk, applied physics 1998.
%Appendix A of K. R. Mcintosh & P. P. Altermatt conference paper 2012
%% INPUTS
%T = 298.15;
%k = 1.38064852e-23;                                                         % Boltzmann constant (m2 kg/s2 K) 
%q= 1.60217662e-19;                                                          % Electron charge (Coulombs)
% Eg=1.12;
% Vstart=0.001;
% Vstep=0.001;
% Vend = Eg;
% V = [Vstart:Vstep:Vend];
% ni_0 = 8.28e9;       
%Nd = 1e17;
%Na = 0;
% delta_Eg = 0;
% [n0, p0, n, p, delta_n, ni_eff] = Carrier_Constants(Nd, Na, ni_0, k, T, V, delta_Eg);
%n = 9e16;
%p = 1e15;
%Physcal contants
k = 1.38064852e-23; %Boltzmann constant (m2 kg/s2 K) 
q= 1.60217662e-19;  %Electron charge (Coulombs)
%Silicon parameter  (Table I of Schenk's paper)
Ry_ex = 16.55e-3;   %in eV unit "exciton Rydberg energy" for silicon 
alpha_e = 0.5187;   %mu* to me >>> mu* is reduced effecive mass, me is effective mass of electron   
alpha_h = 0.4813;   %mu* to mh >>> mu* is reduced effecive mass, mh is effective mass of hole
g_e = 12;           %degenracy factor for electron
g_h = 4;            %degenracy factor for hole
me_m0 = 0.321;      %efective mass of electron to m0 (m0 is the "free electron rest mass" equals 9.11e-31 kg)
mh_m0 = 0.346;      %efective mass of hole to m0
mu_m0 = 0.1665;     %reduced effective mass to m0
a_ex = 37.19e-8;    %excitonic Bohr radius in cm 
epsilon_s = 11.7;   %static dielectric constant
% electronic (rigid) part   (Table II of Schenk's paper)
b_e = 8;            %Fit parameters for Pade approximation for electronic BGN equation, for both electrons and holes
b_h = 1;
c_e = 1.3346; 
c_h = 1.2365;
d_e = 0.893;
d_h = 1.153;
p_e = 7/30;
p_h = 7/30;
% inoic part        (Table III of Schenk's paper)
%Fit parameters for Pade approximation for ionic BGN equation, for both electrons and holes
h_e = 3.91;   
h_h = 4.20;
j_e = 2.8585;
j_h = 2.9307;
k_e = 0.012;
k_h = 0.19;
q_e = 0.75;
q_h = 0.25;
%% CALCULATIONS
%Calculations of carrier-related parameters
n_e = (a_ex^3)*n;
n_h = (a_ex^3)*p;
n_p = (alpha_e*n_e) + (alpha_h*n_h);
n_sigma = n_e + n_h;
zeta = (k*T)/(Ry_ex*q); 
U_i = (n_sigma.^2)./(zeta^3);
N_sigma = Nd + Na;
n_ionic = (a_ex^3)*N_sigma;   %impurity concenteration 

%calculation of band shifts
delta_e_i = (-n_ionic.*(1+U_i)) ./ (sqrt((zeta.*n_sigma)./(2*pi)).*(1+h_e.*log(1+(sqrt(n_sigma)./zeta))) + j_e.*U_i.*((n_p).^0.75).*(1+k_e.*(n_p.^q_e)));
delta_h_i = (-n_ionic.*(1+U_i)) ./ (sqrt((zeta.*n_sigma)./(2*pi)).*(1+h_h.*log(1+(sqrt(n_sigma)./zeta))) + j_h.*U_i.*((n_p).^0.75).*(1+k_h.*(n_p.^q_h)));
delta_Ec_i = -Ry_ex.*delta_e_i; %ionic quasi-particle shift of conduction band
delta_Ev_i = -Ry_ex.*delta_h_i; %ionic quasi-particle shift of valence band

delta_e_xc = -(((4*pi)^3)*((n_sigma.^2).*(((48*n_e)./(pi*g_e)).^(1/3)+c_e*log(1+d_e.*(n_p.^p_e)))) + (8*pi*alpha_e/g_e).*n_e.*(zeta^2) + sqrt(8*pi.*n_sigma).*(zeta^2.5)) / ...
    (((4*pi)^3)*(n_sigma.^2) + zeta^3 + b_e*sqrt(n_sigma).*(zeta^2) + 40*(n_sigma.^1.5).*zeta);
delta_h_xc = -(((4*pi)^3)*((n_sigma.^2).*(((48*n_h)./(pi*g_h)).^(1/3)+c_h*log(1+d_h.*(n_p.^p_h)))) + (8*pi*alpha_h/g_h).*n_h.*(zeta^2) + sqrt(8*pi.*n_sigma).*(zeta^2.5)) / ...
    (((4*pi)^3)*(n_sigma.^2) + zeta^3 + b_h*sqrt(n_sigma).*(zeta^2) + 40*(n_sigma.^1.5).*zeta);
delta_Ec_xc = -Ry_ex.*delta_e_xc; %electronics (rigid) quasi-particle shift of conduction band
delta_Ev_xc = -Ry_ex.*delta_h_xc; %electronics (rigid) quasi-particle shift of valence band

delta_Ec = delta_Ec_xc + delta_Ec_i; 
delta_Ev = delta_Ev_xc + delta_Ev_i;
BGN = delta_Ec + delta_Ev;
delta_Eg = abs(BGN);
%save ('Band_Gap_Narrowing');
%save('C:\hesanziar\Ideas\2018-Thermodynamic Limit\Test Results\Band_Gap_Narrowing.mat');

end

