function [ eta_tandem ] = tandem_2T_world_PSO3(bandgap,Width,N_donor,LandCoordIndex,...
    lamda_nm,Tair_C_Daily_avg_2019_input,G_POA_mean_BRL_world,Coef_WeightAveToAve_GPoA,Coef_WeightAveToAve_Tair,G_POA_1h_2019_avg_raw_BRL_world)
%This fuction calculate solar cell theoretical efficiency of X-Si tandem 2-termainal solar cell 
% The top cell is calcuated using detailed balanced limit and the bottom cell using 1-D semiconductor modelling 
% By Hesan Ziar (December 2022)
%clear all;
c = 299792458;                                                              % Speed of light (m/s)
k = 1.38064852e-23;                                                         % Boltzmann constant (m2 kg/s2 e1) 
q= 1.60217662e-19;                                                          % Electron charge (Coulombs)
h = 6.62607004e-34;                                                         % Plack constant (m2 kg / s  or Joule.Second)
% addpath('C:\hesanziar\Ideas\2021-World map efficiency\Tanja_SMARTS\All world results\Tandem');
% load ('ASTMG173.mat');                                                      % 'lamda_nm' , 'E_global_lamda', and 'E_beam_lamda' are the variable inputs from ASTMG173
% load ('G_POA_1h_2019_avg_raw_BRL_world.mat');
% load ('G_POA_mean_BRL_world.mat');
% load ('Tair_C_Daily_avg_2019_input.mat');
% load ('GPoA_Tamb_Average_WeightedAverage.mat');
% load ('Land_coord.mat');
% load ('wvlngth.mat');
% f = waitbar(0,'Just started...');
load ('WorldData_OneTime_Load.mat');

% N_donor = logspace(12,12,1);   % n-type doping concenteration
N_acceptor = 0;               % p-type doping concenteration
% Width = [1:1:1000]*1e-6;          %Width of silicon in m
NOCT = 48;
Vstart=0.0;
Vstep=0.0002;
% bandgap = [0.31:0.01:4.42]';
% bandgap = round(input_parameter(1,1),2)
% Width = round(input_parameter(1,2))*1e-6
%Eg = q * [0.31:0.01:4.42]';
Fg = 2;
lamda =1e-9*lamda_nm;
unitstep = zeros(length(lamda),1);     %prealocation
absorbtance = zeros(length(lamda),1);  %prealocation
%E = (h*c)./lamda;
%Result = zeros (length(Land_coord), 13);
% co_min = 2001;
% co_max = 2030;
Result = zeros(1,27); 
%for LandCoordIndex=co_min:co_max
E_global_lamda = G_POA_1h_2019_avg_raw_BRL_world{LandCoordIndex,1}*Coef_WeightAveToAve_GPoA(LandCoordIndex,1);   % the coefficients is added to calculate with weighted average G not its average
Tc = Tair_C_Daily_avg_2019_input(LandCoordIndex,1)*Coef_WeightAveToAve_Tair(LandCoordIndex,1) +...
    (((NOCT-20)/800))*G_POA_mean_BRL_world(LandCoordIndex,1)*Coef_WeightAveToAve_GPoA(LandCoordIndex,1) + 273.15;   % the coefficients are added to calculate with weighted average G and T not their average

    phi_lamda = ((q.*lamda)./(h*c)).*(E_global_lamda);                      %converts AM 1.5 Exergy spectral irradiance into spectral photon flux (C/m2 s)
    total_incoming_radiation_top = trapz(lamda_nm, E_global_lamda);         %total incoming radiation 
    
%     intermediateResult = zeros(1,10);                         % 10 is because of the number of recorded outputs
    counter = 1:1:length(bandgap);       
    Eg = q * bandgap(counter,1);
    %n = length(lamda);                                                          % returnd number of elements in Lamda vector
    lamda_g = (h*c)./Eg;
    %lamda_nm_g = lamda_g .* 1e9;
    for j=1:length(Eg)
        unitstep (:,j) = lamda>lamda_g(j,1);
        absorbtance (:,j) = ones(length(lamda),1)-unitstep(:,j);                                            %to make a step function for absorbtance
    end
    
J_max_Eg = trapz (lamda_nm, absorbtance.*phi_lamda);                       
%J_max_Eg_mApercm2 = (1e3/1e4).*J_max_Eg;                                      %0.1 coeffieinct is to convert A/m2 to mA/cm2

E = h*c./lamda;                                                             % energy of each photon
% Jnr_Eg_V = 0;                                                                % non-radiative recombination is neglected in detailed balance approach
% Jnr_Eg_0 = 0;


voltage = [Vstart:Vstep:bandgap(counter,1)]';  

Jr_Eg_V = zeros(length(voltage),1);         %prealocation
J_ext_Eg_V = zeros(length(voltage),1);      %prealocation
Power_ext_Eg_V = zeros(length(voltage),1);  %prealocation
for j=1:length(Eg)
    Vend=Eg(j,1)/q;
    i=1;
for V=Vstart:Vstep:Vend
Jr_Eg_V (i,j) = Fg * (-q) * trapz (E, (2*pi.*(E.^2)./((h^3)*(c^2))) .* (absorbtance(:,j)./(exp((E-(q*V))./(k*Tc))-1)));    %to find radiative recombination
J_ext_Eg_V (i,j) = J_max_Eg (1,j) - Jr_Eg_V (i,j);
Power_ext_Eg_V (i,j) = (V.*J_ext_Eg_V (i,j));
i=i+1;
end
    if j/length(Eg)>0.5 && j/length(Eg)<0.51                                                       %to monitor the loop progress
    fprintf('first loop, halfway through, progress: %.1f \n %', (j/length(Eg))*100)
    end
end
% disp('first loop, done.')                                                   %to monitor the loop progress


J_ext_Eg_V(J_ext_Eg_V<=0) = nan;
minimum = zeros(1,length(Eg));         %prealocation
maximum = zeros(1,length(Eg));         %prealocation
x = zeros(1,length(Eg));               %prealocation
y = zeros(1,length(Eg));               %prealocation
Voc = zeros(1,length(Eg));             %prealocation
Vmpp = zeros(1,length(Eg));            %prealocation

for j=1:length(Eg)
minimum (1,j) = min(J_ext_Eg_V(:,j));                                                   % to find Voc
x(1,j)=find(J_ext_Eg_V(:,j)==minimum(1,j));
Voc (1,j)= Vstart+(Vstep.*(x(1,j)-1));

maximum (1,j) = max(Power_ext_Eg_V(:,j));                                              % to find Vmpp
y(1,j)=find(Power_ext_Eg_V(:,j)==maximum(1,j));
Vmpp (1,j) = Vstart+(Vstep.*(y(1,j)-1));
end

Jr_Eg_Vmpp = zeros(1,length(Eg));          %prealocation
J_mpp_Eg = zeros(1,length(Eg));            %prealocation
Jr_Eg_0 = zeros(1,length(Eg));             %prealocation
J_sc_Eg = zeros(1,length(Eg));             %prealocation
for j=1:length(Eg)
Jr_Eg_Vmpp (1,j) = Fg * (-q) .* trapz (E, (2*pi.*(E.^2)./((h^3)*(c^2))) .* (absorbtance(:,j)./(exp((E-(q.*Vmpp(1,j)))./(k*Tc))-1)));
J_mpp_Eg (1,j) = J_max_Eg (1,j) - Jr_Eg_Vmpp (1,j);
 
Jr_Eg_0 (1,j) = Fg * (-q) .* trapz (E, (2*pi.*(E.^2)./((h^3)*(c^2))) .* (absorbtance(:,j)./(exp((E-(q*0))./(k*Tc))-1)));
J_sc_Eg (1,j) = J_max_Eg (1,j) - Jr_Eg_0 (1,j);

end
% disp('second loop, done.')                                                   %to monitor the loop progress

Voc_top = Voc; 
Jsc_top = J_sc_Eg;
Vmpp_top = Vmpp;
Jmpp_top = J_mpp_Eg;
FF_top = (Vmpp.*J_mpp_Eg)./(Voc.*J_sc_Eg);                                         %Fill Factor
eta_top = (Vmpp.*J_mpp_Eg)./total_incoming_radiation_top;  
        


%%%%%%%%%%%%%%%%%%%%%%%%%
V = [Vstart:Vstep:bandgap(counter,1)];
T=Tc;
%
ni_0 = 5.29e19 * ((T/300)^2.54) * exp(-6726/T) ;                             % Temperature dependent intrinsic carrier concentration from K. Misiakos and Tsamakis, D., Journal of Applied Physics, vol. 74, no. 5, p. 3293, 1993.
phi_lamda_bottom = (1-absorbtance).*((q.*lamda)./(h*c)).*(E_global_lamda);   % converts AM 1.5 Energy spectral irradiance into spectral photon flux (C/m2 s)
total_incoming_radiation_bottom = trapz(lamda_nm, (1-absorbtance).*E_global_lamda);                  % total incoming radiation 

%% Pre-allocation
Pmpp = zeros (length(N_donor), length(Width));
eta_bottom = zeros (length(N_donor), length(Width));
Jsc_mApercm2 = zeros (length(N_donor), length(Width));
Voc = zeros (length(N_donor), length(Width));
FF = zeros (length(N_donor), length(Width)); 
delta_n_mpp = zeros (length(N_donor), length(Width)); 
Tau_mpp = zeros (length(N_donor), length(Width));
Tau_oc = zeros (length(N_donor), length(Width));
delta_n_oc = zeros (length(N_donor), length(Width));
Vmpp = zeros (length(N_donor), length(Width));

Resistivity_sc = zeros (length(N_donor), length(Width));
Resistivity_oc = zeros (length(N_donor), length(Width));
Resistivity_mpp = zeros (length(N_donor), length(Width));
L_mpp = zeros (length(N_donor), length(Width));
L_oc = zeros (length(N_donor), length(Width));

Photon_Rec_Width = zeros (length(Width), length(V));
B_integral_Width = zeros (length(Width), length(V));
BGN_values = zeros (length(N_donor), length(V));
ni_eff_values = zeros (length(N_donor), length(V));
delta_n_values = zeros (length(N_donor), length(V));
%step_absorptance =  zeros (length(lamda), length(N_donor));

minimum = zeros (1, length(Width));
x = zeros (1, length(Width));
y = zeros (1, length(Width));

Nd_plus = zeros (length(N_donor), 1);
Na_minus = zeros (length(N_donor), 1);

%tandem_values = zeros (length(Width), 10);     % 10 is because of the number of recorded outputs
eta_tandem = zeros (length(N_donor), length(Width));
Voc_tandem = zeros (length(N_donor), length(Width));
Jsc_tandem = zeros (length(N_donor), length(Width));
Vmpp_tandem = zeros (length(N_donor), length(Width));
Jmpp_tandem = zeros (length(N_donor), length(Width));
radiation_top = zeros (length(N_donor), length(Width));
radiation_bottom = zeros (length(N_donor), length(Width));

NoOutputBottomCell_loop_abort_counter=0;
width_loop_abort_counter=0;
%% loop
for j = 1:1:length(N_donor)
Nd = N_donor(1,j);
Na = N_acceptor;
% [Nd_plus, Na_minus] = Incompelte_Ioization(Nd, Na, k, T, n, p);           %Incomplte Inoization is negelected in this code, however, the function is ready
%[n0, p0, n, p, delta_n, ni_eff, delta_Eg] = Carrier_Concentration(Nd, Na, T, V, ni_0, Eg);
[n0, p0, n, p, delta_n, ni_eff, delta_Eg, Nd_plus(j,1), Na_minus(j,1), ~, ~] = Carrier_Statistics(Nd, Na, T, V, ni_0, Eg);

BGN_values (j,:) = delta_Eg;
ni_eff_values (j,:) = ni_eff;
delta_n_values (j,:) = delta_n;
% Nd
% iid
% iid_values (j,:) = iid;
% iia_values (j,:) = iia;
ni_eff (:,1);  
delta_Eg (:,1);

% Eg = 1.12 - delta_Eg;
% lamda_g = (h*c)./(q*Eg);
% unitstep (:,j) = lamda>lamda_g;
% step_absorptance (:,j) = ones(1,1)-unitstep (:,j);
[~, mu_h, ~, ~, ~, rho] = Carrier_Mobility (Nd, Na, n, p, T);


[alpha_bb, n_r] = Silicon_Optical_Constants(T);
[alpha_FCA_n,alpha_FCA_p] = Free_Carrier_Absorption(Nd, Na, T, V, n, p);
alpha_FCA = alpha_FCA_p + alpha_FCA_n;
for i = 1:1:length(Width)
W = Width(1,i);
[R_intr, Photon_Rec, B_integral] = Intrinsic_Recombination_Rate(Nd, Na, T, V, W, n, p, n0, p0, delta_n, ni_eff);
Photon_Rec_Width(i,:) = Photon_Rec;
B_integral_Width(i,:) = B_integral;

A_bb = (alpha_bb*ones(1,length(V))) ./ (alpha_bb*ones(1,length(V)) + alpha_FCA + (1./(4.*((n_r.^2)*W*1e+2)))*ones(1,length(W)));
%A_bb = ((step_absorptance (:,j).*alpha_bb)*ones(1,length(V))) ./ (alpha_bb*ones(1,length(V)) + alpha_FCA + (1./(4.*((n_r.^2)*W*1e+2)))*ones(1,length(W)));
%J_L = q*trapz(flip(E), flip(A_bb.*(E_global_lamda*ones(1,length(W))))); 
J_L_mApercm2 = (1e3/1e4).*trapz(lamda_nm, A_bb.*(phi_lamda_bottom*ones(1,length(V))));     %0.1 coeffieinct is to convert A/m2 to mA/cm2
J_mApercm2 = (J_L_mApercm2) - 1000*q*((W*1e+2).*real(R_intr));                     %starngely one time it gave complex numbers for R then I added real(R)!! % qWR is in A/cm2, multiplied by 1000 to convert to mA/cm2                                 %from Richter et al., IEEE JPV (2013)
                                                                                    %It was because delta_n for the very low voltage values gets negative sometimes.        
J_Aperm2 = J_mApercm2*10;
P = J_Aperm2.*V;
Pmpp(j,i) = max(P);                                        %Pmpp in W/m2
eta_bottom(j,i) = (Pmpp(j,i))./total_incoming_radiation_bottom;      
%eta(j,i) = (Pmpp(j,i))./normalized_total_incoming_radiation; 

Jsc_mApercm2 (j,i) = max (J_mApercm2);
minimum (1,i) = min(abs(J_mApercm2));
x(1,i)=find(abs(J_mApercm2) == minimum(1,i),1, 'last');    % this finds the last value that matches the condition
Voc (j,i) = Vstart+(Vstep.*(x(1,i)-1));
%Voc (j,i) = VoltageVector(1,x(1,i)); 
FF (j,i) = Pmpp(j,i) / (10.*(Voc(j,i)*Jsc_mApercm2(j,i))); 
y(1,i)=find(P == Pmpp(j,i));
delta_n_mpp(j,i) = delta_n(1, y(1,i)); 
Tau_mpp(j,i) = delta_n_mpp(j,i)/R_intr(1, y(1,i));
delta_n_oc(j,i) = delta_n(1, x(1,i)); 
Tau_oc(j,i) = delta_n_oc(j,i)/R_intr(1, x(1,i));
Vmpp(j,i) = V(1, y(1,i));
% [counter, j, i];

Resistivity_sc (j,i)= rho(1,1);             %Resistivity at V=0 (ohm.cm)
Resistivity_oc (j,i)= rho(1,x(1,i));        %Resistivity at V=VOC (ohm.cm)
Resistivity_mpp (j,i)= rho(1,y(1,i));       %Resistivity at V=VMPP (ohm.cm)
L_mpp(j,i) = sqrt((k*T/q)*(mu_h*Tau_mpp(j,i)));            %Minroty carrier diffusion length at Vmpp (cm)
L_oc(j,i) = sqrt((k*T/q)*(mu_h*Tau_oc(j,i)));              %Minroty carrier diffusion length at Voc (cm)



%%%%%%%%%% finding the JV_tandem curve (2 terminals: series connection) %%%%%%%%
JV_top = [voltage 0.1*J_ext_Eg_V];   % 0.1 coeffieinct is to convert A/m2 to mA/cm2
JV_bottom = [V' 0.1*J_Aperm2'];      % 0.1 coeffieinct is to convert A/m2 to mA/cm2

JV_top(isnan(JV_top(:,2)),:)=[];   % to remove nans from JV top
JV_bottom(JV_bottom(:,2)<0,:)=[];   % to remove negative values from JV bottom

    if isempty(JV_bottom)  % if bottom cell gives no output (all light absorbed in the top cell), record all tandem cell values as zero and abort the loop
        Voc_tandem(j,i) = 0;
        Jsc_tandem(j,i) = 0;
        Vmpp_tandem(j,i) = 0;
        Jmpp_tandem(j,i) = 0;
        %Pmpp_tandem(j,i) = PV_tandem(row,2);
        radiation_top(j,i) = total_incoming_radiation_top;
        radiation_bottom(j,i) = total_incoming_radiation_bottom;
        NoOutputBottomCell_loop_abort_counter = NoOutputBottomCell_loop_abort_counter+1;
        continue   % skips the rest of the calcuation and goes to the next iteration of this loop
    end
if max(JV_bottom(:,2)) >= max(JV_top(:,2))   % The JV with the smaller Isc must be extended (as extended as the Voc of the other curve) and the other JV must be flipped. In this way the intersect will happen in nany case
    J_extrapolate = interp1(JV_top(:,1), JV_top(:,2), [-max(JV_bottom(:,1)):Vstep:max(JV_top(:,1))]','linear','extrap');
    JV_extrapolate = [[-max(JV_bottom(:,1)):Vstep:max(JV_top(:,1))]' J_extrapolate];
    JV_flipped = [-JV_bottom(:,1) JV_bottom(:,2)];
else
    J_extrapolate = interp1(JV_bottom(:,1), JV_bottom(:,2), [-max(JV_top(:,1)):Vstep:max(JV_bottom(:,1))]','linear','extrap');
    JV_extrapolate = [[-max(JV_top(:,1)):Vstep:max(JV_bottom(:,1))]' J_extrapolate];
    JV_flipped = [-JV_top(:,1) JV_top(:,2)];
end

decimal_points = 3;
for decimal_counter = 1:decimal_points+1
[C, ~, ib] = intersect(round(JV_extrapolate(:,2),decimal_points),round(JV_flipped(:,2),decimal_points));  % to find the intersection point
if ~isempty(C)  % we reduce the intersction accuracy step by step from 3 decimal points to zero decimal point
break
else
   decimal_points=decimal_points-1;
end
end  
    if isempty(C)  % if there is still no intersection for some reason, just abort this width loop and go to the next thickness width
        width_loop_abort_counter = width_loop_abort_counter+1;
        break
    end
% now we just need to shift the curve
voltage_shift_size = abs(JV_flipped(ib(end),1));
JV_tandem = [JV_extrapolate(:,1)+voltage_shift_size JV_extrapolate(:,2)];
JV_tandem(JV_tandem(:,1)<0,:)=[];  % remove negative values of voltage
%f = waitbar(x,msg)

% % plotting just to check
% plot(JV_flipped(:,1),JV_flipped(:,2));
% hold on;
% plot(JV_extrapolate(:,1),JV_extrapolate(:,2));
% plot(JV_bottom(:,1),JV_bottom(:,2));
% plot(JV_top(:,1),JV_top(:,2));
% plot(JV_tandem(:,1),JV_tandem(:,2));

PV_tandem = [JV_tandem(:,1) 10*(JV_tandem(:,1).*JV_tandem(:,2))];     % 10 is multiplied to convert back from mA/cm2 to A/m2
[row, ~] = find(PV_tandem(:,2)==max(PV_tandem(:,2)));
eta_tandem (j,i) = PV_tandem(row,2)/total_incoming_radiation_top;
%tandem_values(i,:) = [eta_tandem JV_tandem(end,1) JV_tandem(1,2) JV_tandem(row,1) JV_tandem(row,2) PV_tandem(row,2) i bandgap(counter,1) total_incoming_radiation_top total_incoming_radiation_bottom];   %This gives the eta, Voc (V), Jsc (mA/cm2), Vmpp (V), Jmpp (mA/cm2), Pmpp, thickness of bottom silicon cell (um), bandgap of the top cell (eV), total incoming radiation top, total incoming radiation bottom 
Voc_tandem(j,i) = JV_tandem(end,1);
Jsc_tandem(j,i) = JV_tandem(1,2);
Vmpp_tandem(j,i) = JV_tandem(row,1);
Jmpp_tandem(j,i) = JV_tandem(row,2);
%Pmpp_tandem(j,i) = PV_tandem(row,2);
radiation_top(j,i) = total_incoming_radiation_top;
radiation_bottom(j,i) = total_incoming_radiation_bottom;
%%%%%%%%%%%

end
end

[index_row,index_column]=find(eta_tandem==max(max(eta_tandem)),1,'first');
Result(counter,:) = [eta_bottom(index_row,index_column) Voc(index_row,index_column) Jsc_mApercm2(index_row,index_column) 100*FF(index_row,index_column)...
        Vmpp(index_row,index_column) delta_n_mpp(index_row,index_column) delta_n_oc(index_row,index_column) 1e6*Width(1,index_column)...
        BGN_values(index_row,1) ni_eff_values(index_row,1) Nd_plus(index_row,1)-Na_minus(index_row,1) Resistivity_mpp(index_row,index_column)...
        (1e4*L_mpp(index_row,index_column))/(1e6*Width(1,index_column)) eta_tandem(index_row,index_column) Voc_tandem(index_row,index_column)...
        Jsc_tandem(index_row,index_column) Vmpp_tandem(index_row,index_column) Jmpp_tandem(index_row,index_column) radiation_top(index_row,index_column)...
        radiation_bottom(index_row,index_column) bandgap(counter,1) eta_top Voc_top Jsc_top Vmpp_top Jmpp_top 100*FF_top];
  
%     waitbar(counter/length(bandgap),f,'Working on it...')
    % row_number = find(tandem_values(:,1) == max(tandem_values(:,1)));
% intermediateResult(counter,:) = tandem_values(row_number,:);

% [index_row,index_column]=find(eta==max(max(eta)));
% Result(LandCoordIndex,:) = [eta(index_row,index_column) Voc(index_row,index_column) Jsc_mApercm2(index_row,index_column) 100*FF(index_row,index_column)...
%         Vmpp(index_row,index_column) delta_n_mpp(index_row,index_column) delta_n_oc(index_row,index_column) 1e6*Width(1,index_column)...
%         BGN_values(index_row,index_column) ni_eff_values(index_row,1) Nd_plus(index_row,1)-Na_minus(index_row,1) Resistivity_mpp(index_row,index_column)...
%         (1e4*L_mpp(index_row,index_column))/(1e6*Width(1,index_column))];

%end
%saving

% clearvars -except Result 
% save('Q:\hesanziar\Ideas\2021-World map efficiency\Tanja_SMARTS\All world results\Tandem\tandem_2T_STC.mat');

% mkdir(fullfile(sprintf('%s_%d-%d', 'Results_1x1',co_min,co_max))); %makes a folder including range of the target coordinates
% movefile ('Result_siliconPV_global_efficiency.mat', fullfile(sprintf('%s_%d-%d', 'Results_1x1',co_min,co_max))) %moves all .mat files to the result folder, if folder already exists it overwites
eta_tandem = Result(1,14);
end






 
