function [R_intr, Photon_Rec, B_integral] = Intrinsic_Recombination_Rate(Nd, Na, T, V, W, n, p, n0, p0, delta_n, ni_eff)
%UNTITLED2 Summary of this function goes here
%   Detailed explanation goes here
% Calculating intrinsic recombination rate (R_intr)
%Coeffiencts are obtained from Altermatt et al. 5th Conference on Numerical Simulation of Optoelectronic Devices,(2005)
%R_intr equation is obtained from Richter et al. Physical review (2012)
%Example inputs
%%
%Nd = 1e19;
%Na = 0;
%T = 298.15;
k = 1.38064852e-23;                                                         % Boltzmann constant (m2 kg/s2 K) 
q= 1.60217662e-19;                                                          % Electron charge (Coulombs)
% Eg=1.12;
% Vstart=0.001;
% Vstep=0.001;
% Vend = Eg;
% V = [Vstart:Vstep:Vend];
ni_0 = 8.28e9;                 % intrinsic carrier concenteration at 25C from the Richter IEEE JPV paper, 2013.
%delta_Eg = 0;                   %assuming there is no bandgap narrowing
%%
%[n0, p0, n, p, delta_n, ni_eff] = Carrier_Constants(Nd, Na, ni_0, k, T, V, delta_Eg);

b_max = 1.00;               
r_max = 0.20;
s_max = 1.5e18;
w_max = 4.0e18;

r_min = 0.00;
s_min = 1.0e7;
w_min = 1.0e9;

b2 = 0.54; 
r1 = 320;
s1 = 550;
w1 = 365;

b4 = 1.25; 
r2 = 2.50;
s2 = 3.00;
w2 = 3.54;

b_min = r_max + ((r_min - r_max)/(1+((T/r1)^r2))); 
b1 = s_max + ((s_min - s_max)/(1+((T/s1)^s2)));  
b3 = w_max + ((w_min - w_max)/(1+((T/w1)^w2)));

B_rel = b_min + ((b_max - b_min)./(1+(((n+p)./b1).^b2)+(((n+p)./b3).^b4)));      %Altermatt et al.  5th Conference on Numerical Simulation of Optoelectronic Devices,(2005)

[Photon_Rec, P_PR, P_FCA, P_ex, B_integral, B_low_integral] = Photon_Recycling(Nd, Na, T, V, W, n, p, ni_eff);
B_low = B_low_integral;   %radiative recombination coefficient at 300K            %from Tupke et al. J applied physics (2003)
B = B_low .* B_rel;   %radiative recombination coefficient at T

N0_eeh = 3.3e17;  %cm^-3   %from Richter et al. Physical review (2012) 
N0_ehh = 7.0e17;  %cm^-3
g_eeh = 1 + 13*(1-tanh((n0/N0_eeh).^0.66));
g_ehh = 1 + 7.5*(1-tanh((p0/N0_ehh).^0.63));

%W = [1:1:1000]*1e-6;
R_intr = (n.*p - (ni_eff.^2)).*((2.5E-31*g_eeh.*n0) + (8.5E-32*g_ehh.*p0) + (3E-29.*(delta_n.^0.92)) + (B_rel.*B_low).*(1-Photon_Rec));   %from Richter et al. Physical review (2012)
%R_intr = (ni_eff.^2).*(exp((q*V)/(k*T))-1).*((2.5E-31*g_eeh.*n0) + (8.5E-32*g_ehh.*p0) + (3E-29.*(delta_n.^0.92)) + (B_rel.*B_low).*(1-Photon_Rec));   %from Richter et al. Physical review (2012)

%save('Intrinsic_Recombination_Rate');
%save('C:\hesanziar\Ideas\2018-Thermodynamic Limit\MATLAB results1\Intrinsic_Recombination_Rate.mat');
end

