function [n0, p0, n, p, delta_n, ni_eff, delta_Eg, Nd_plus, Na_minus, iid, iia] = Carrier_Statistics(Nd, Na, T, V, ni_0, Eg)
%UNTITLED2 Summary of this function goes here
%   Detailed explanation goes here
% Nd = 0.5e16;
% Na = 1;
% Eg = 1.12;
% Vstart=0.001;
% Vstep=0.01;
% Vend = Eg;
% V = [Vstart:Vstep:Vend];
% T = 298.15;
% ni_0 = 8.28e9;                                                              % intrinsic carrier concenteration at 25C from the Richter IEEE JPV paper, 2013.

k = 1.38064852e-23;                                                         % Boltzmann constant (m2 kg/s2 K) 
q= 1.60217662e-19;                                                          % Electron charge (Coulombs)
Nc_300K = 2.89e19;                                                          %for crystaline silicon at 300K, unit is cm-3 obtained from PVlighthouse
Nv_300K = 3.14e19;                                                          % temperature dependency of Nv and Nc from equations (14) and (15) of Martin Green. ournal of Applied Physics 67, no. 6 (1990): 2944-2954.
Nc = Nc_300K * (T/300)^1.5;
Nv = Nv_300K * (T/300)^1.5;
%seven steps
N = Nd-Na;
n0 = N;
n = n0;
p = (ni_0^2)/n;
t = [0:1e-2:1e2]';
%delta_n = 1e12;
%delta_Eg_result = zeros (10, length(V));
%for loop_counter = 1:1:1
[Nd_plus, Na_minus, iid, iia] = Incompelte_Ioization(Nd, Na, k, T, n, p);
n0 = Nd_plus-Na_minus;
n = n0;
p = (ni_0^2)/n;
[delta_Eg, delta_Ev, delta_Ec] = Band_Gap_Narrowing(T, Nd_plus, Na_minus, n, p);
x0 = log ((n./Nc)/(1+(n./(4*Nc))));
x1 = log ((n./Nc)/(1+(n./(4*Nc)))) - ((q*delta_Ec)./(k*T));
F_1_2_x0 = (2/sqrt(pi)) * trapz(t, (t*ones(1,length(V)).^0.5) ./ (1+ exp(t*ones(1,length(V))-ones(length(t),1)*x0)));
F_1_2_x1 = (2/sqrt(pi)) * trapz(t, (t*ones(1,length(V)).^0.5) ./ (1+ exp(t*ones(1,length(V))-ones(length(t),1)*x1)));
gamma_deg = F_1_2_x1 / exp(x1); 
gamma_BGN = exp (q*delta_Ev./(k*T)) .* (F_1_2_x0 ./ F_1_2_x1);
n0p0 = (ni_0^2) .* gamma_deg .* gamma_BGN;
p0 = n0p0 ./ n0;

%% ni_eff= sqrt(n0p0); 
ni_eff = ni_0 * exp ((q*delta_Eg)./(2*k*T));  
delta_n = -0.5*(n0 + p0) + 0.5*sqrt(((n0 - p0).^2) + 4*(ni_eff.^2).*exp((q*V)./(k*T)));   %excess carrier concentration should be in the range of E+11 to E+19 cm-3
%delta_n = 0;
delta_n(delta_n<0) = 0;

n = n0 + delta_n;
p = p0 + delta_n;

% loop_counter
% n0p0_result (loop_counter, :) = n0p0;
% delta_n_result (loop_counter, :) = delta_n;
% delta_Eg_result (loop_counter, :) = delta_Eg;
% n_result (loop_counter, :) = n;
% p_result (loop_counter, :) = p;
% n0_result (loop_counter, :) = n0;
% p0_result (loop_counter, :) = p0;
% Nd_plus_result (loop_counter, :) = Nd_plus;
% Na_minus_result (loop_counter, :) = Na_minus;
%end
end


