%% Input: 
% datas = nx2 / nx3 / nx4 double 
% - :,1 = measurement 1
% - :,2 = measurement 2
% - :,3 = group
% - :,4 = time (integer) between test-retest.
% ------------------
% h = figure number;
% titlename = title of figure;
% figname = name of figure;

% TODO: Fixx legend!

function trt_plot_alternating(datas,h,figdata)

    set(0,'DefaultFigureWindowStyle','docked');
    
    data=[]; grps=[]; bxpos=[];gr=0;
    for i=1:size(datas,2)
        grps=[grps ones(1,size(datas{i}(:,1),1))*gr]; gr=gr+1;
        data=[data; datas{i}(:,1)];
        grps=[grps ones(1,size(datas{i}(:,2),1))*gr]; gr=gr+1;
        data=[data; datas{i}(:,2)];
        
        bxpos=[bxpos ((i-1)*5)+1 ((i-1)*5)+4];
        xpos=[((i-1)*5)+2 ((i-1)*5)+3];
        
        figure(h)
        hold on
        plot(xpos, datas{i}, 'bo-'); 
    end
    
    boxplot(data, grps, 'positions', bxpos);
    xticks = [0:0.5:(max(bxpos)+1)];
    lblpos=[6:10:66];
    for i=1:size(xticks,2)
        xticklabels{i} = ''; a=find(lblpos==i,1);
        if ~isempty(a)
            xticklabels{i} = figdata.xticklabels{a}; 
        end
    end
    
    title([figdata.title]); ylabel([figdata.ylabel]); xlabel([figdata.xlabel]);
    ylim([0 20]); set(gca, 'xtick', xticks, 'xticklabel', xticklabels);
    hold off; 
    
    set(findobj(gcf, 'type', 'axes'), 'fontsize', 20, 'fontname', 'Corbel');
    
    %filename=strcat([path, '\' figdata.figname]);
    %savefig(filename);
end