%% Input: 
% datas = nx2 / nx3 / nx4 double 
% - :,1 = measurement 1
% - :,2 = measurement 2
% - :,3 = group
% - :,4 = time (integer) between test-retest.
% ------------------
% h = figure number;
% titlename = title of figure;
% figname = name of figure;

% TODO: Fixx legend!

function trt_plot_alternating(datas,h,figdata)

    set(0,'DefaultFigureWindowStyle','docked');
    
    data=[]; grps=[]; bxpos=[]; gr=0; clrs = {'b','r','k'};
    figure(h); ax1 = subplot(1,2,1); ax2 = subplot(1,2,2); 
    hold on;
    for i=1:size(datas,2)
        grps=[grps ones(1,size(datas{i}(:,1),1))*gr]; gr=gr+1;
        data=[data; datas{i}(:,1)];
        grps=[grps ones(1,size(datas{i}(:,2),1))*gr]; gr=gr+1;
        data=[data; datas{i}(:,2)];
        
        BA.MeanDiff(i) = nanmean(diff(datas{i},1,2));
        
        axes(ax2);
        h(i) = scatter(nanmean(datas{i}'), diff(datas{i}'), 100, 'filled', clrs{i});
        yline(BA.MeanDiff(i), ['-' clrs{i}]);
        
        if sum(~isnan(diff(datas{i},1,2)))>1
            [~, BA.SysErr(i)] = ttest(diff(datas{i},1,2));          
            BA.SDDiff(i) = nanstd(diff(datas{i},1,2));
        
            yline(BA.MeanDiff(i)+1.96*BA.SDDiff(i), ['--' clrs{i}]);
            yline(BA.MeanDiff(i)-1.96*BA.SDDiff(i), ['--' clrs{i}]);
        end

        bxpos=[bxpos ((i-1)*5)+1 ((i-1)*5)+4];
        xpos=[((i-1)*5)+2 ((i-1)*5)+3];
        
        axes(ax1); hold on
        plot(xpos, datas{i}, [clrs{i} '-']); 
        scatter(repmat(xpos(1),size(datas{i}(:,1),1),1), datas{i}(:,1), 100, 'filled', clrs{i})
        scatter(repmat(xpos(2),size(datas{i}(:,2),1),1), datas{i}(:,2), 100, 'filled', clrs{i})
    end
    legend(h(1:3), {'A-RD','B-RD','B-CS'})
    
    boxplot(data, grps, 'positions', bxpos);
    xticks = [0:0.5:(max(bxpos)+1)];
    lblpos=[6:10:66];
    for i=1:size(xticks,2)
        xticklabels{i} = ''; a=find(lblpos==i,1);
        if ~isempty(a)
            xticklabels{i} = figdata.xticklabels{a}; 
        end
    end
    ylim([0 20]); set(gca, 'xtick', xticks, 'xticklabel', xticklabels);  
    sgtitle([figdata.title], 'fontsize', 40, 'fontname', 'Corbel'); ylabel([figdata.ylabel]); xlabel([figdata.xlabel]);
    hold off; 
    
    set(findobj(gcf, 'type', 'axes'), 'fontsize', 40, 'fontname', 'Corbel');
    
    %filename=strcat([path, '\' figdata.figname]);
    %savefig(filename);
end