function QS_Analysis_GroupedBoxPlots_OneCategory_TRT(input)

%% Restructering data
% Has to fit with:
% Data{n} = jx2 double
%
% wherein:
% n = number of groups (sets) of the TRT plot
% j = number of TRT pairs.
% In case of no TRT pair, one of the values is NaN

if isfield(input,'data')==0
    disp('... ERROR: No data provided, please do this!');
    return
end

if isfield(input,'msrmnt')==0
    disp('... ERROR: No measurement number provided, please do this!');
    return
end

if isfield(input,'grps')==0
    disp('... ERROR: No groups provided, please do this!');
    return
end

if isfield(input,'fig')==0
    input.fig=struct;
end

if isfield(input.fig,'categories')==0
    input.fig.categories={'A' 'B' 'C' 'D'};
elseif size(input.fig.categories,2)~=4
    disp('... ERROR: The categories should be equal to 4, please do this!');
    return    
end 

if size(input.msrmnt,2)~=2
    disp(['... ERROR: Two measurements have to be inputted!']);
    return 
end

Dataset=input.data;
grps=input.grps;
msrmnt=input.msrmnt;

cats={'A','B','C','D'};
for i=1:size(grps,2)
    for j=1:size(Dataset{grps(i)},2)
        for k=1:4
            
            resm1=find(ismember(Dataset{grps(i)}(j).Tcat{msrmnt(1)},cats{k}));
            resm2=find(ismember(Dataset{grps(i)}(j).Tcat{msrmnt(2)},cats{k}));

            figdata.(cats{k}).title = ['One week test-retest responses with category: ', cats{k}];
            %figdata.(cats{k}).figname = strcat(figdata.figname, '_', cats{k});
            figdata.(cats{k}).xlabel = '';
            figdata.(cats{k}).ylabel = 'Electrical current [mA]';
            figdata.(cats{k}).xticklabels = input.fig.names;
            
            if ~isempty(resm1)
                Data.(cats{k}){i}(j,1) = cell2mat(Dataset{grps(i)}(j).TmA{msrmnt(1)}(resm1(1)));
            else
                Data.(cats{k}){i}(j,1) = NaN; 
            end
            
            if ~isempty(resm2)
                Data.(cats{k}){i}(j,2) = cell2mat(Dataset{grps(i)}(j).TmA{msrmnt(2)}(resm2(1)));
            else
                Data.(cats{k}){i}(j,2) = NaN; 
            end
        end       
    end
end

trt_plot_alternating(Data.(cats{1}),1,figdata.(cats{1}));
trt_plot_alternating(Data.(cats{2}),2,figdata.(cats{2}));
trt_plot_alternating(Data.(cats{3}),3,figdata.(cats{3}));
trt_plot_alternating(Data.(cats{4}),4,figdata.(cats{4}));

for cat=1:4
    disp(['CATEGORY ' cats{cat}])
    disp('ICC(2,1)');
    
    [R, LB, UB] = ICC(rmmissing([Data.(cats{cat}){1}(:,1) Data.(cats{cat}){1}(:,2)]), 'A-1');
    disp(['A-RD: ' num2str(R), ' (' num2str(LB), '-', num2str(UB), ')']);
    [R, LB, UB] = ICC(rmmissing([Data.(cats{cat}){2}(:,1) Data.(cats{cat}){2}(:,2)]), 'A-1');
    disp(['B-RD: ' num2str(R), ' (' num2str(LB), '-', num2str(UB), ')']);
    [R, LB, UB] = ICC(rmmissing([Data.(cats{cat}){3}(:,1) Data.(cats{cat}){3}(:,2)]), 'A-1');
    disp(['B-CS: ' num2str(R), ' (' num2str(LB), '-', num2str(UB), ')']);    
    
    disp('SEM');
    SEm = std(diff(rmmissing([Data.(cats{cat}){1}(:,1) Data.(cats{cat}){1}(:,2)]),1,2))/sqrt(2);
    SEmPerc = (SEm/mean(mean(rmmissing([Data.(cats{cat}){1}(:,1) Data.(cats{cat}){1}(:,2)]))))*100;
    disp(['A-RD: ' num2str(SEm) '(', num2str(SEmPerc), ')']);
    SEm = std(diff(rmmissing([Data.(cats{cat}){2}(:,1) Data.(cats{cat}){2}(:,2)]),1,2))/sqrt(2);
    SEmPerc = (SEm/mean(mean(rmmissing([Data.(cats{cat}){2}(:,1) Data.(cats{cat}){2}(:,2)]))))*100;
    disp(['B-RD: ' num2str(SEm) '(', num2str(SEmPerc), ')']);
    SEm = std(diff(rmmissing([Data.(cats{cat}){3}(:,1) Data.(cats{cat}){3}(:,2)]),1,2))/sqrt(2);
    SEmPerc = (SEm/mean(mean(rmmissing([Data.(cats{cat}){3}(:,1) Data.(cats{cat}){3}(:,2)]))))*100;
    disp(['B-CS: ' num2str(SEm) '(', num2str(SEmPerc), ')']);
    
    DataSelect1 = rmmissing([Data.(cats{cat}){1}(:,1) Data.(cats{cat}){1}(:,2)]);
    DataSelect2 = rmmissing([Data.(cats{cat}){2}(:,1) Data.(cats{cat}){2}(:,2)]);
    DataSelect3 = rmmissing([Data.(cats{cat}){3}(:,1) Data.(cats{cat}){3}(:,2)]);
    disp('CV');
    CV = mean((std(DataSelect1')./mean(DataSelect1')))*100;
    disp(['A-RD: ' num2str(CV)]);
    CV = mean((std(DataSelect2')./mean(DataSelect2')))*100;
    disp(['B-RD: ' num2str(CV)]);
    CV = mean((std(DataSelect3')./mean(DataSelect3')))*100;
    disp(['B-CS: ' num2str(CV)]);
end
    
    
