%% Extract complete QScale dataset
% Shows the individual choosings per study group.
% Study group needs to be manually inputted.
%%%%%
% GROUPS:
% [1]: (QSA Red Dot)
% [2]: (QSB Red Dot)
% [3]: (QSB CutaStim)
% [4]: (QSA Verbal)
%%%%%
% MEASUREMENTS:
% [1]: (Pre-CPT,  M1)
% [2]: (Post-CPT, M1)
% [3]: (Pre-CPT,  M2)
% [4]: (Post-CPT, M2)
%%%%%

clear all; clc;
set(0,'DefaultFigureWindowStyle','docked');

% Define excel file
filename    = '... \Datasets\Dataset - Experiment 3.xlsx';
msrmnts     = {'preCPT_Test', 'postCPT_Test', 'preCPT_Retest', 'postCPT_Retest'};
grps        = {'QSA-RD', 'QSB-RD', 'QSA-CS'};

% Extract all QSdata
[~,~,RawData]= xlsread(filename,'A2:CY61');

%% Define  the data..
grp(1).data = [1:15];  
grp(2).data = [31:44]; 
grp(3).data = [45:59];
grp(4).data = [16:30]; 

% Define the data points
data.mA.fam_Test            = 44;
data.mA.fam_Retest          = 45;
data.cats.preCPT_Test       = [46 48 50 52 54];
data.cats.preCPT_Retest     = [47 49 51 53 55];
data.mA.preCPT_Test         = [56 58 60 62 64];
data.mA.preCPT_Retest       = [57 59 61 63 65];
data.cats.postCPT_Test      = [74 76 78 80 82];
data.cats.postCPT_Retest    = [75 77 79 81 83];
data.mA.postCPT_Test        = [84 86 88 90 92];
data.mA.postCPT_Retest      = [85 87 89 91 93];

data.verbal_PT                 = [15 23 31 39];
data.verbal_DT                 = [19 27 35 43];

%% Generate the organized data..
% QScale data..
Dataset=table(); n=0; IncorrectEntries=0; subj=0;
grps = [1 2 2]; CPT = [1 2 1 2]; Electrode = [1 1 2];
Measurements = [1 1 2 2];
Categories={'A','B','C','D'};
for i=1:3
    for j=1:size(grp(i).data,2)
        subj=subj+1;
        for k=1:4
            x = RawData(grp(i).data(j),data.cats.(msrmnts{k})); 
            y = RawData(grp(i).data(j),data.mA.(msrmnts{k}));      
            x(cellfun(@(x) any(isnan(x)),x)) = [];
            yl = bsxfun(@eq,[y{:}],0);
            y(yl)={[]}; y=y(~cellfun('isempty',y));
            y(cellfun(@(y) any(isnan(y)),y)) = [];

            Groups{i}(j).subject_no = cell2mat(RawData(grp(i).data(j),1));
            Groups{i}(j).Tcat{k} = x;
            Groups{i}(j).TmA{k} = y;
            Groups{i}(j).Fam{1} = RawData(grp(i).data(j),data.mA.fam_Test);
            Groups{i}(j).Fam{2} = RawData(grp(i).data(j),data.mA.fam_Test);
            Groups{i}(j).Fam{3} = RawData(grp(i).data(j),data.mA.fam_Retest);
            Groups{i}(j).Fam{4} = RawData(grp(i).data(j),data.mA.fam_Retest);
            
            for c=1:size(x,2)
                if sum(contains(Categories,x{c}))>0
                    n=n+1;
                    % Temporary fixx. Look at CRF!
                    if n==444
                        y{3}=NaN;
                    end
                    Dataset.Subject(n)         = subj;
                    Dataset.Group(n)           = grps(i);
                    Dataset.Measurement(n)     = Measurements(k);
                    Dataset.Condition(n)       = CPT(k);
                    Dataset.Electrode(n)       = Electrode(i);
                    Dataset.QSCat(n)           = find(contains(Categories,x{c}));
                    Dataset.QSValue(n)         = y{c};
                else
                    IncorrectEntries=IncorrectEntries+1;
                end
            end
        end
    end
    QSData{i}=Groups{i};
end

% Verbal data..
i=4;
for j=1:size(grp(i).data,2)
    for k=1:4
        Groups{i}(j).subject_no = cell2mat(RawData(grp(i).data(j),1));
        Groups{i}(j).TmA_PT{k} = RawData(grp(i).data(j),data.verbal_PT(k));
        Groups{i}(j).TmA_DT{k} = RawData(grp(i).data(j),data.verbal_DT(k));
    end
end
Dataset.QSValueLog = log10(Dataset.QSValue);

%% Visualize TRT Verbal
CPTTimes = cell2mat(RawData(16:30, 102:103));

GrpCmp = [1 3];
for n=1:size(Groups{1,4},2)
    TRTData_PT(n,1) = cell2mat(Groups{1,4}(n).TmA_PT{1,1});
    TRTData_PT(n,2) = cell2mat(Groups{1,4}(n).TmA_PT{1,2});
    TRTData_PT(n,3) = cell2mat(Groups{1,4}(n).TmA_PT{1,3});
    TRTData_PT(n,4) = cell2mat(Groups{1,4}(n).TmA_PT{1,4});
    
    TRTData_DT(n,1) = cell2mat(Groups{1,4}(n).TmA_DT{1,1});
    TRTData_DT(n,2) = cell2mat(Groups{1,4}(n).TmA_DT{1,2});
    TRTData_DT(n,3) = cell2mat(Groups{1,4}(n).TmA_DT{1,3});
    TRTData_DT(n,4) = cell2mat(Groups{1,4}(n).TmA_DT{1,4});
end

% For if the CPTTimes need to be plotted.
% TRTData(:,3) = CPTTimes(:,1);
% TRTData(:,4) = CPTTimes(:,2);

disp(['Verbal PT mean M1 (SD): ' num2str(nanmean(TRTData_PT(:,GrpCmp(1)))), '(' num2str(nanstd(TRTData_PT(:,GrpCmp(1)))) ')']);
disp(['Verbal PT mean M2 (SD): ' num2str(nanmean(TRTData_PT(:,GrpCmp(2)))), '(' num2str(nanstd(TRTData_PT(:,GrpCmp(2)))) ')']);

disp(['Verbal DT mean M1 (SD): ' num2str(nanmean(TRTData_DT(:,GrpCmp(1)))), '(' num2str(nanstd(TRTData_DT(:,GrpCmp(1)))) ')']);
disp(['Verbal DT mean M2 (SD): ' num2str(nanmean(TRTData_DT(:,GrpCmp(2)))), '(' num2str(nanstd(TRTData_DT(:,GrpCmp(2)))) ')']);

[R, LB, UB] = ICC(rmmissing([TRTData_PT(:,GrpCmp(1)) TRTData_PT(:,GrpCmp(2))]), 'A-1');
disp(['Verbal PT ICC: ' num2str(R), '(' num2str(LB), '-', num2str(UB), ')']);
[R, LB, UB] = ICC(rmmissing([TRTData_DT(:,GrpCmp(1)) TRTData_DT(:,GrpCmp(2))]), 'A-1');
disp(['Verbal DT ICC: ' num2str(R), '(' num2str(LB), '-', num2str(UB), ')']);

SEm = std(diff(rmmissing([TRTData_PT(:,GrpCmp(1)) TRTData_PT(:,GrpCmp(2))]),1,2))/sqrt(2);
SEmPerc = (SEm/mean(mean(rmmissing([TRTData_PT(:,GrpCmp(1)) TRTData_PT(:,GrpCmp(2))]))))*100;
disp(['Verbal PT SEM: ' num2str(SEm) '(', num2str(SEmPerc), ')']);
SEm = std(diff(rmmissing([TRTData_DT(:,GrpCmp(1)) TRTData_DT(:,GrpCmp(2))]),1,2))/sqrt(2);
SEmPerc = (SEm/mean(mean(rmmissing([TRTData_DT(:,GrpCmp(1)) TRTData_DT(:,GrpCmp(2))]))))*100;
disp(['Verbal DT SEM: ' num2str(SEm) '(', num2str(SEmPerc), ')']);

CV = mean((std(rmmissing([TRTData_PT(:,GrpCmp(1)) TRTData_PT(:,GrpCmp(2))]')))./(mean(rmmissing([TRTData_PT(:,GrpCmp(1)) TRTData_PT(:,GrpCmp(2))]'))))*100;
disp(['Verbal PT CV: ' num2str(CV)]);
CV = mean((std(rmmissing([TRTData_DT(:,GrpCmp(1)) TRTData_DT(:,GrpCmp(2))]')))./(mean(rmmissing([TRTData_DT(:,GrpCmp(1)) TRTData_DT(:,GrpCmp(2))]'))))*100;
disp(['Verbal DT CV: ' num2str(CV)]);

%% Bland-Altmans
BA.MeanDiff = nanmean(diff(TRTData_PT(:,GrpCmp),1,2));
[~, BA.SysErr] = ttest(diff(TRTData_PT(:,GrpCmp),1,2));
BA.SDDiff = nanstd(diff(TRTData_PT(:,GrpCmp),1,2));

figure(5)
subplot(1,2,1);
hold on;
scatter(ones(size(TRTData_PT(:,GrpCmp(1)),1),1), TRTData_PT(:,GrpCmp(1)), 100, 'filled', 'k');
scatter(ones(size(TRTData_PT(:,GrpCmp(2)),1),1)*2, TRTData_PT(:,GrpCmp(2)), 100, 'filled', 'k');
plot([1 2], [TRTData_PT(:,GrpCmp(1)) TRTData_PT(:,GrpCmp(2))], 'k');
boxplot(TRTData_PT(:,GrpCmp(1)), 'positions', [1]);
boxplot(TRTData_PT(:,GrpCmp(2)), 'positions', [2]);
hold off;
xlim([0.5 2.5]); ylim([0 20]);
xticks([1 2]); xticklabels({'Test','Retest'});
ylabel('Electrical Pain Threshold [mA]'); 

subplot(1,2,2);
hold on;
scatter(nanmean(TRTData_PT(:,GrpCmp)'), diff(TRTData_PT(:,GrpCmp'),1,2), 100, 'filled', 'k')
yline(BA.MeanDiff, '-k', '', 'FontSize', 30, 'LabelHorizontalAlignment', 'right');
yline(BA.MeanDiff+1.96*BA.SDDiff, 'k--');
yline(BA.MeanDiff-1.96*BA.SDDiff, 'k--');
hold off;

set(findobj(gcf, 'type', 'axes'), 'fontsize', 40, 'fontname', 'Corbel');

BA.MeanDiff = nanmean(diff(TRTData_DT(:,GrpCmp),1,2));
[~, BA.SysErr] = ttest(diff(TRTData_DT(:,GrpCmp),1,2));
BA.SDDiff = nanstd(diff(TRTData_DT(:,GrpCmp),1,2));

figure(6)
subplot(1,2,1);
hold on;
scatter(ones(size(TRTData_DT(:,GrpCmp(1)),1),1), TRTData_DT(:,GrpCmp(1)), 100, 'filled', 'k');
scatter(ones(size(TRTData_DT(:,GrpCmp(2)),1),1)*2, TRTData_DT(:,GrpCmp(2)), 100, 'filled', 'k');
plot([1 2], [TRTData_DT(:,GrpCmp(1)) TRTData_DT(:,GrpCmp(2))], 'k');
boxplot(TRTData_DT(:,GrpCmp(1)), 'positions', [1]);
boxplot(TRTData_DT(:,GrpCmp(2)), 'positions', [2]);
hold off;
xlim([0.5 2.5]); ylim([0 5]);
xticks([1 2]); xticklabels({'Test','Retest'});
ylabel('Electrical Detection Threshold [mA]'); 

subplot(1,2,2);
hold on;
scatter(nanmean(TRTData_DT(:,GrpCmp)'), diff(TRTData_DT(:,GrpCmp'),1,2), 100, 'filled', 'k')
yline(BA.MeanDiff, '-k', '', 'FontSize', 30, 'LabelHorizontalAlignment', 'left');
yline(BA.MeanDiff+1.96*BA.SDDiff, 'k--');
yline(BA.MeanDiff-1.96*BA.SDDiff, 'k--');
hold off;

set(findobj(gcf, 'type', 'axes'), 'fontsize', 40, 'fontname', 'Corbel');

%% Perform analyses..
analyses{1}.type    = 'QS_Analysis_GroupedBoxPlots_OneCategory_TRT';
analyses{1}.data    = QSData;
analyses{1}.msrmnt  = [1 3];
analyses{1}.grps    = [1 2 3];

analyses{1}.fig.names    = {'A-RD','B-RD','B-CS','A-RD','B-RD','B-CS'};

analysis_run(analyses,[1]);
