clear all;close all force;clc %#ok<CLALL>
%% Read DSSQ data
[DSSQJLR,CJLR]=xlsread('DSSQ.xlsx','J50:X76');
DSSQJLR(:,2)=0;DSSQJLR=knnimpute(DSSQJLR')'; % impute missing data
CJLR=CJLR(:,1);CJLR=reshape(CJLR,3,9)';CJLR=1*strcmp(CJLR,'B')+2*strcmp(CJLR,'NT')+3*strcmp(CJLR,'T'); % C = 27 x 1 matrix with conditions per PP (1 = Baseline, 2 = NT, 3 = DT)
DSSQJLRr=NaN(9,3,13);
DSSQJLRr(:,1,:)=DSSQJLR(1:3:end,3:end); % DSSQ baseline
DSSQJLRr(:,2,:)=DSSQJLR(2:3:end,3:end); % DSSQ run 1
DSSQJLRr(:,3,:)=DSSQJLR(3:3:end,3:end); % DSSQ run 2
DSSQJLR=DSSQJLRr;clear DSSQJLRr % 9 persons * 3 conditions * 13 item
sdc=squeeze(std(DSSQJLR(:,1,:)));
for i=1:13
    DSSQJLR(:,:,i)=DSSQJLR(:,:,i)-repmat(DSSQJLR(:,1,i),1,3);
    DSSQJLR(:,:,i)=DSSQJLR(:,:,i)./sdc(i);
end
[~,SJLR]=sort(transpose(CJLR)); % S = 3 x 22 matrix, with column 1 = NTR session nr, 2 = VT session nr, 3 = TR session nr
vars2(1)={'DSSQJLR'};
for i=1:9;for i2=1:3;for i3=1:length(vars2);eval([vars2{i3} 'C(i,i2,:)=' vars2{i3} '(i,SJLR(i2,i),:);']);end;end;end % for each dependent variable sort per condition.
% 1. EA = Energetic arousal
% 2. TA = Tense arousal
% 3. HT = Hedonic tone
% 4. AF = Anger / frustration
% 5. SM = Success motivation
% 6. IM = Intrinsic motivation
% 7. OM = Overall motivation
% 8. SFA = Self-focused attention
% 9. SE = Self-esteem
% 10. CON = Concentration
% 11. C&C = Control and Confidence
% 12. TRI = Task-related interference
% 13. TII = Task-irrelevant interference
DSSQJLRS(:,:,1)=(DSSQJLR(:,:,1)+DSSQJLR(:,:,5)+DSSQJLR(:,:,6)+DSSQJLR(:,:,10))/4; % engagement (per run)
DSSQJLRS(:,:,2)=(DSSQJLR(:,:,2) -DSSQJLR(:,:,3) +DSSQJLR(:,:,4) -DSSQJLR(:,:,11))/4; % distress (per run)
DSSQJLRS(:,:,3)=(DSSQJLR(:,:,8) -DSSQJLR(:,:,9) +DSSQJLR(:,:,12) +DSSQJLR(:,:,13))/4; % worry (per run)
DSSQJLRCS(:,:,1)=(DSSQJLRC(:,:,1)+DSSQJLRC(:,:,5)+DSSQJLRC(:,:,6)+DSSQJLRC(:,:,10))/4; % engagement (per condition)
DSSQJLRCS(:,:,2)=(DSSQJLRC(:,:,2) -DSSQJLRC(:,:,3) +DSSQJLRC(:,:,4) -DSSQJLRC(:,:,11))/4; % distress (per condition)
DSSQJLRCS(:,:,3)=(DSSQJLRC(:,:,8) -DSSQJLRC(:,:,9) +DSSQJLRC(:,:,12) +DSSQJLRC(:,:,13))/4; % worry (per condition
%% Read TLX data
[TLXJLR]=xlsread('NASA-TLX.xlsx','C2:H19');
TLXJLR=5*(TLXJLR-1);
TLXJLRr=NaN(9,2,6);TLXJLRr(:,1,:)=TLXJLR(1:2:end,:);TLXJLRr(:,2,:)=TLXJLR(2:2:end,:);
TLXJLRC(1:2:9,1,1:6)=squeeze(TLXJLRr(1:2:9,1,1:6)); % Run 1 = NT
TLXJLRC(1:2:9,2,1:6)=squeeze(TLXJLRr(1:2:9,2,1:6)); % Run 2 = DT
TLXJLRC(2:2:9,1,1:6)=squeeze(TLXJLRr(2:2:9,2,1:6)); % Run 1 = DT
TLXJLRC(2:2:9,2,1:6)=squeeze(TLXJLRr(2:2:9,1,1:6)); % Run 2 = NT
TLXJLRr(:,:,7)=mean(TLXJLRr,3); % Overall workload per run
TLXJLRC(:,:,7)=mean(TLXJLRC,3); % Overall workload per condition
%% Read GPS data
% 1. mAccuracy (We define accuracy as the radius of 68% confidence. In other words, if you draw a circle centered at this location's latitude and longitude, and with a radius equal to the accuracy, then there is a 68% probability that the true location is inside the circle.)
% 2. mAltitude (Get the altitude if available, in meters above the WGS 84 reference ellipsoid.)
% 3. mBearing (Get the bearing, in degrees)
% 4. mDistance
% 5. mElapsedRealtimeNanos (Returns nanoseconds since boot, including time spent in sleep)
% 6. mHasAccuracy (True if this location has an accuracy)
% 7. mHasAltitude (True if this location has an altitude)
% 8. mHasBearing (True if this location has a bearing)
% 9. mHasSpeed (True if this location has a speed)
% 10. mInitialBearing
% 11. mIsFromMockProvider (Returns true if the Location came from a mock provider)
% 12. mLat1
% 13. mLat2
% 14. mLatitude
% 15. mLon1
% 16. mLon2
% 17. mLongitude
% 18. mProvider
% 19. mResults
% 20. mSpeed
% 21. mTime
GPSdate=NaN(9,2,512);GPSlat=NaN(9,2,512);GPSlong=NaN(9,2,512);GPSspeed=NaN(9,2,512);GPSacc=NaN(9,2,512);
for i=1:9 % loop over pp
    for i2=1:2 % loop over run nr
        filename=['Sensor log ppt ' num2str(i) ' run ' num2str(i2) '.xlsx'];
        [X,V]=xlsread(filename,'A3:V1000');
        temp=V(:,end);temp=cell2mat(temp);temp=str2num(temp(:,1:13)); %#ok<ST2NM>
        GPSdate(i,i2,1:length(temp))=temp/86400000+datenum(1970,1,1);
        GPSacc(i,i2,1:length(X))=X(:,1);
        GPSlong(i,i2,1:length(X))=X(:,17);
        GPSlat(i,i2,1:length(X))=X(:,14);
        GPSspeed(i,i2,1:length(X))=X(:,21);
    end
end

GPS_SB=[52.412822	-2.026332 % Southbound (47 bridges)
    52.404563	-2.039626
    52.40318	-2.044748
    52.399057	-2.052403
    52.379126	-2.046285
    52.378101	-2.04674
    52.373264	-2.050364
    52.366247	-2.066552
    52.36236	-2.068369
    52.35961	-2.069266
    52.354787	-2.068245
    52.355738	-2.046542
    52.355615	-2.045214
    52.354558	-2.013801
    52.354441	-1.990698
    52.35625	-1.977913
    52.361892	-1.949708
    52.361931	-1.948107
    52.355348	-1.898495
    52.354904	-1.887007
    52.355019	-1.884882
    52.351701	-1.857531
    52.349131	-1.83725
    52.34765	-1.826388
    52.347747	-1.812377
    52.347692	-1.806465
    52.344704	-1.794419
    52.338768	-1.784704
    52.334691	-1.772102
    52.33328	-1.762165
    52.331837	-1.755228
    52.328198	-1.740416
    52.317778	-1.717666
    52.308147	-1.705593
    52.300324	-1.693067
    52.296008	-1.686562
    52.289799	-1.671209
    52.285271	-1.664264
    52.279292	-1.659329
    52.273719	-1.652491
    52.270453	-1.645688
    52.265121	-1.630459
    52.263481	-1.622742
    52.261673	-1.617416
    52.260745	-1.614928
    52.259568	-1.611886
    52.258789	-1.609451];

GPS_NB=[52.258789	-1.609451 % Northbound (50 bridges)
    52.259568	-1.611886
    52.260745	-1.614928
    52.261673	-1.617416
    52.263481	-1.622742
    52.265121	-1.630459
    52.270453	-1.645688
    52.273719	-1.652491
    52.279292	-1.659329
    52.285271	-1.664264
    52.289799	-1.671209
    52.296008	-1.686562
    52.300324	-1.693067
    52.308147	-1.705593
    52.317778	-1.717666
    52.328198	-1.740416
    52.331837	-1.755228
    52.33328	-1.762165
    52.334691	-1.772102
    52.338768	-1.784704
    52.344704	-1.794419
    52.347692	-1.806465
    52.347747	-1.812377
    52.34765	-1.826388
    52.349131	-1.83725
    52.351701	-1.857531
    52.355019	-1.884882
    52.354904	-1.887007
    52.355348	-1.898495
    52.361931	-1.948107
    52.361892	-1.949708
    52.35625	-1.977913
    52.354441	-1.990698
    52.354558	-2.013801
    52.355615	-2.045214
    52.355738	-2.046542
    52.35961	-2.069266
    52.36236	-2.068369
    52.366247	-2.066552
    52.373264	-2.050364
    52.378101	-2.04674
    52.379126	-2.046285
    52.399057	-2.052403
    52.40318	-2.044748
    52.404563	-2.039626
    52.412822	-2.026332
    52.430781	-2.017685
    52.434865	-2.017537
    52.443196	-2.017997
    52.446815	-2.016913];
% Daniel's comments
%Ppt3's Detection Run had no button press recordings for the first ~10 minutes, because the button wasn't plugged in. Don't you have missing values there then?
%Ppt4's runs were both shorter due to the car's power shortage.
%PP5 pressed button early
%Ppt6's Detection Run had 2 Labchart crashes. I could determine the first and last part, but couldn't match the middle part.
%Ppt8's Detection Run started off bad with the GPS logging, stalling at one point for several minutes or so. Henceforth, the first 6 button presses are all on the same location, GPS wise.
%Ppt8's GPS logs are generally bad. Not sure why. Simply compared: ppt1 run 2 has got 22 missing speed values (5.5%), whereas ppt8 has 100 (22.8%) and 157 (41.6%) for run 1 and 2, respectively.
%Ppt9's run I don't see anything particularly wrong with. The logging starts off nicely, although at the end it starts to deteriorate, and ends up with 94 missing values (36.9%).
%Due to these amounts of missing values, I decided to calculate it for all, just simply the amounts of 0's in the mSpeed column (U):
%%
close all force
% Run 1 = always northbound, Run 2 = always southbound
%1. NT T
%2. T NT
%3. NT T
%4. T NT
%5. NT T
%6. T NT
%7. NT T
%8. T NT
%9. NT T
DL=6*ones(9,2);DL(6,2)=40612;
DIV=8; % number of 5 min partitions of the data
LabVST=NaN(9,2,3);
DT=NaN(9,2,DIV+3);DT2=NaN(9,2,DIV+3);
HR=NaN(9,2,DIV+3);HRv=NaN(9,2,DIV+3);HRv2=NaN(9,2,DIV+3);HRv3=NaN(9,2,DIV+3);HRv4=NaN(9,2,DIV+3);HRv5=NaN(9,2,DIV+3);HRv6=NaN(9,2,DIV+3);HRv7=NaN(9,2,DIV+3);
RR=NaN(9,2,DIV+3);MS=NaN(9,2,DIV+3); % respiratory rate, mean speed
SETime=NaN(9,2,2); % start & end time
hits=NaN(9,50);
BP_stats=NaN(9,4);
BP_overview=NaN(9,50);
TH=1250; % distance threshold in meters
offset=[38 0 -25 0 18 0 5 0 0];
Todo =[     1     1
    1     1
    3     1
    1     1
    2     2
    2     3
    2     2
    2     2
    2     1];
[bb,aa]=butter(2,[0.0002 0.002]); % [0.15 Hz, 1 Hz] % sample rate = 1000 hz, Wn = 1.0 = 500 Hz, Wn = 0.001 = 0.5 Hz, Wn = 0.0005 = 0.25 Hz, Wn = 0.0001 = 0.05 Hz
Accuracy_all=[];
for i=1:9 % loop over participants
    for i2=1:2 % 1 = No task, 2 = Detection task
        clear X S
        X=NaN(1,7);
        disp([i i2])
        if i2==1
            filename=['ppt' num2str(i) '.txt']; % filename of physiological data including button press data for No Task
        elseif i2==2
            filename=['ppt' num2str(i) 't.txt'];% filename of physiological data including button press data for Detection task
        end
        for i4=1:Todo(i,i2)
            if i4==2 && i==6 && i2==2
                filename=['ppt' num2str(i) 't2.txt'];% filename of physiological data including button press data for Detection task
                DL(i,i2)=6;
            elseif i4==3 && i==6 && i2==2
                filename=['ppt' num2str(i) 't3.txt'];% filename of physiological data including button press data for Detection task
                DL(i,i2)=6;
            end
            try % Here we read the start time of the physiological file and convert it to a Matlab (datenum) format
                fileID = fopen(filename,'r'); dataArray = textscan(fileID, '%f%f%f%f%f%f%f%[^\n\r]', 'Delimiter', '\t', 'HeaderLines' ,DL(i,i2)-5, 'ReturnOnError', false); %#ok<NASGU>
            catch error
                temp=error.message;LabVST(i,i2,i4)=(str2num(temp(strfind(temp,'ExcelDateTime=')+15:strfind(temp,'ExcelDateTime=')+38)))-2+datenum('1-1-1900'); %#ok<ST2NM>
            end
            if i==6&&i2==2 && i4<3
                fileID = fopen(filename,'r'); dataArray = textscan(fileID, '%f%f%f%f%f%[^\n\r]', 'Delimiter', '\t', 'HeaderLines' ,DL(i,i2), 'ReturnOnError', true);
                t=cell2mat(dataArray(1:5)); % X = matrix with physiological data (column 1 = Time, 2 = respiratory signal 3 = button volt(?), 4 = ECG, 5 = respiratory rate, 6 = heart rate, 7 = ibi)
                t(:,6)=t(:,5);t(:,7)=t(:,5);
            else
                fileID = fopen(filename,'r'); dataArray = textscan(fileID, '%f%f%f%f%f%f%f%[^\n\r]', 'Delimiter', '\t', 'HeaderLines' ,DL(i,i2), 'ReturnOnError', true);
                t=cell2mat(dataArray(1:7)); % X = matrix with physiological data (column 1 = Time, ...)
            end
            t(:,1)=(t(:,1)+offset(i))/(24*3600)+LabVST(i,i2,i4); % offset between clocks of GPS and ECG
            X=[X;t]; %#ok<AGROW> % append matrix to current matrix
            DL(i,i2)=DL(i,i2)+6+size(t,1);
        end
        X(1,:)=[]; % remove first row
        S=X(1:1:end,:); % resample to every 0.1 s
        if ismember(i,[1 3 5 7 9]) % if participant number is odd (i.e., Run 1 = No task, Run 2 = Detection task)
            GPSx=squeeze(GPSdate(i,i2,:));GPSy1=squeeze(GPSspeed(i,i2,:));GPSy2=squeeze(GPSacc(i,i2,:));GPSy3=squeeze(GPSlat(i,i2,:));GPSy4=squeeze(GPSlong(i,i2,:));
        else % if participant number is even (i.e., Run 1 = Detection task, Run 2 = No task)
            GPSx=squeeze(GPSdate(i,3-i2,:));GPSy1=squeeze(GPSspeed(i,3-i2,:));GPSy2=squeeze(GPSacc(i,3-i2,:));GPSy3=squeeze(GPSlat(i,3-i2,:));GPSy4=squeeze(GPSlong(i,3-i2,:));
        end
        temp=find(~isnan(GPSx) & ~isnan(GPSy1) & ~isnan(GPSy2) & ~isnan(GPSy3) & ~isnan(GPSy4) & [NaN;diff(GPSx)]>0);
        GPSx=GPSx(temp);GPSy1=GPSy1(temp);GPSy2=GPSy2(temp);GPSy3=GPSy3(temp);GPSy4=GPSy4(temp); % remove GPS data if any of the variables contains NaN or if the GPS data are constant in two subsequent samples
        S(:,8)=interp1(GPSx(GPSy1>0),GPSy1(GPSy1>0),S(:,1)); % speed
        S(:,9)=interp1(GPSx,GPSy2,S(:,1)); % accuracy in meters
        S(:,10)=interp1(GPSx,GPSy3,S(:,1)); % latitude in degrees
        S(:,11)=interp1(GPSx,GPSy4,S(:,1)); % longitude in degrees
        if (i2==1 && ismember(i,[1 3 5 7 9])) || (i2==2 && ismember(i,[2 4 6 8])) % if Northbound (i.e., Run 1)
            %            disp(distance([max(GPS_NB(:,1)),max(GPS_NB(:,2))],[max(GPS_NB(:,1)),max(GPS_NB(:,2))+0.0014739])*1000*40075/360)  % distance check (100 m)
            %            disp(distance([max(GPS_NB(:,1)),max(GPS_NB(:,2))],[max(GPS_NB(:,1))+0.0008983,max(GPS_NB(:,2))])*1000*40075/360)
            S=S(find(S(:,11)<max(GPS_NB(:,2)+2*0.0014739) & S(:,9)<9999,1,'first'):find(S(:,10)<max(GPS_NB(:,1)+2*0.0008983) & S(:,9)<9999,1,'last'),:); % Cut part of the route (with 200 m exta before first bridge and after last bridge)
        else % Southbound (i.e., Run 2)
            S=S(find(S(:,10)<max(GPS_SB(:,1)+2*0.0008983)& S(:,9)<9999,1,'first'):find(S(:,11)<max(GPS_SB(:,2)+2*0.0014739)& S(:,9)<9999,1,'last'),:); % Cut part of the route (with 200 m exta before first bridge and after last bridge)
        end
        Accuracy_all=[Accuracy_all;S(:,9)]; %#ok<AGROW>
        SETime(i,i2,1)=min(S(:,1)); % store start time
        SETime(i,i2,2)=max(S(:,1)); % store end time
        if (ismember(i,[1 3 5 7 9]) && i2==2) || (ismember(i,[2 4 6 8]) && i2==1) % Bridge GPS coordinates from Google Maps (detection task southbound, 47 bridges)
            GPSlo=GPS_SB(:,2);GPSla=GPS_SB(:,1);
        else
            GPSlo=GPS_NB(:,2);GPSla=GPS_NB(:,1); % Bridge GPS coordinates from Google Maps (detection task northbound, 50 bridges)
        end
        bp=find(S(:,3)>4);bp=bp(diff([0;bp])>666); % remove duplicate button presses (when within 0.666 s)
        BPt=[S(bp,10) S(bp,11) S(bp,9)];  % Store latitude (deg), longitude (deg), and GPS accuracy (m) for all retained button presses
        BPt2=BPt;MD2=NaN(length(GPSlo),5);temp=1;
        while sum(BPt2(:,1)<99999999) && ~isempty(temp) && i2==2 % loop while there are stil button presses not assigned to bridges, and when there are still bridges with no button press assigned to it
            for i3=1:size(GPSlo(:,1),1) % loop over all bridges
                MD=NaN(length(GPSlo),5);
                for i4=1:length(GPSlo) % loop over all bridges
                    [MD(i4,1),MD(i4,2)]=min(distance([GPSla(i4),GPSlo(i4)],[BPt2(:,1),BPt2(:,2)])*1000*40075/360); % minimum distance between bridge and all button presses
                    MD(i4,3:5)=BPt2(MD(i4,2),1:3); % store the distance between current bridge and all button presses
                end
                temp=find(isnan(MD2(:,1))); % indexes for bridges for which no button press has been assigned yet
                [~,b]=min(MD(temp,1));b=temp(b); % find minimum distance among all bridges
                BPt2(MD(b,2),:)=9999999999; % remove the particular button press so that it cannot be assigned again
                MD2(b,:)=MD(b,:); % store information per bridge
            end
        end
        hits(i,1:length(MD2))=MD2(:,1); % store the hits per person
        BP_stats(i,1)=sum(MD2(:,1)<=TH); % number of hits
        fps=[BPt2(BPt2(:,1)<100,:);MD2(MD2(:,1)>TH & MD2(:,1)<100000,3:5)]; % false alarms (lat, long, accuracy)
        BP_stats(i,2)=size(fps,1); % number of false alarms (= number of button presses not connected to a bridge)
        BP_stats(i,3)=sum(MD2(:,1)>TH); % number of misses (= number of button presses not connected to a bridge)
        BP_overview(i,1:length(MD2(:,1)))=MD2(:,1);
        if i==1&&i2==2 % plot figure for PP1 southbound (DT)
            figure(100+i*2+i2);hold on % make map figure
            if (i2==1 && ismember(i,[1 3 5 7 9])) || (i2==2 && ismember(i,[2 4 6 8])) % if Northbound
                plot(GPS_NB(:,2),GPS_NB(:,1),'s','Markeredgecolor','k','Markersize',10);hold on % plot bridge markers
                if i2==1;title(['Run 1 (Northbound), Participant ' num2str(i) ', No task']);else;title(['Northbound, Participant number = ' num2str(i) ', Detection task']);end
            end
            if (i2==2 && ismember(i,[1 3 5 7 9])) || (i2==1 && ismember(i,[2 4 6 8])) % if Southbound
                plot(GPS_SB(:,2),GPS_SB(:,1),'s','Markeredgecolor','k','Markersize',10);hold on % plot bridge markers
                if i2==1;title(['Run 2 (Southbound), Participant ' num2str(i) ', No task']);else;title(['Southbound, Participant number = ' num2str(i) ', Detection task']);end
            end
            plot(S(S(:,9)<=20,11),S(S(:,9)<=20,10),'k-','Markeredgecolor','k'); % plot road (only if accuracy is high enough)
            plot(S(1,11),S(1,10),'x','Markeredgecolor','b','Markersize',10,'linewidth',2); % plot starting point of physiological measurement
            plot(S(end,11),S(end,10),'o','Markeredgecolor','m','Markersize',10,'linewidth',2); % plot ending point of physiological measurement
            plot(MD2(MD2(:,1)<9999999,4),MD2(MD2(:,1)<9999999,3),'o','markeredgecolor',[0 128 0]/255,'markerfacecolor',[0 128 0]/255,'linewidth',2,'Markersize',6) % plot hit
            plot(fps(:,2),fps(:,1),'d','markeredgecolor','r','markerfacecolor','r','linewidth',2,'Markersize',6) % plot false alarm
            %   for j=1:length(GPSlo);
            %      text(GPSlo(j),0.005+GPSla(j),num2str(j)) % bridge numbers in text
            % end
            pos=[0.1 0.11 0.45 0.85];
            set(gca, 'Position', pos,'ylim',[52.24 52.425])
            xlabel('Longitude (deg)');ylabel('Latitude (deg)')
            legend('Bridge','Road','Start measurement','End measurement','Hit','False alarm')
            fig=gcf;set(findall(fig,'-property','FontName'),'FontName','Arial','Fontsize',18)
            set(gcf, 'PaperPositionMode', 'manual','paperunits','inches','PaperPosition', [0 0 15 10]);
            set(gca, 'LooseInset', [0.01 0.01 0.01 0.01]);
        end
        
        L=length(S);T=3600*24*(S(:,1)-S(1,1));
        S(S(:,6)<10,6)=NaN; % if HR is below 10 then NaN
        if ~isempty(S)
            for i3=1:DIV+3 % loop across DIV segments, plus 3
                if i3<=DIV
                    V=find(T>=(i3-1)*300,1,'first'):find(T<i3*300,1,'last');
                elseif i3==DIV+1
                    V=1:L; % V = all indices
                elseif i3==DIV+2 % V = indices of first half
                    V=1:floor(L/2);
                elseif i3==DIV+3 % V = indices of second half
                    V=floor(L/2)+1:L;
                end
                if ~isempty(V)
                    DT(i,i2,i3)=sum(~isnan(S(V,6))); % available data (pp6 run 2 has 422 seconds of missing data)
                    DT2(i,i2,i3)=(max(S(V,1))-min(S(V,1)))*24*3600; % length of session from beginning to end
                    IBI=60000./S(V(1:end),6); % recalculate IBI (ms)
                    temp=find(diff(IBI)~=0); temp=temp(diff(temp)==1);IBI=IBI(temp)/1000; % extract subsequent IBI intervals while removing interpolated values
                    IBI=HRV.RRfilter(IBI,20);
                    HR(i,i2,i3)=HRV.HR(IBI); % mean heart rate
                    MS(i,i2,i3)=nanmean(S(V,8)); % mean speed
                    HRv(i,i2,i3)=1000*HRV.SDNN(IBI); % SDNN
                    [HRv4(i,i2,i3),HRv5(i,i2,i3),HRv2(i,i2,i3),HRv3(i,i2,i3),HRv6(i,i2,i3),HRv7(i,i2,i3)]=HRV.fft_val_fun(IBI(~isnan(IBI)),1000); % [pLF,pHF,LFHFratio,VLF,LF,HF] = HRV.fft_val_fun(RR,1000)
                    if i==1 && i2==1 && i3==1
                        figure
                        subplot(1,2,1)
                        plot(T,S(:,4),'k');hold on
                        for i4=1:length(temp)
                        plot([T(temp(i4)) T(temp(i4))],[-10 10],'b--');
                        end
                        xlabel('Time (s)');ylabel('ECG signal (-)')
                        set(gca,'xlim',[0 10],'ylim',[-.8 .6])
                        pos = get(gca,'Position');pos(1)=.06;pos(3)=.34;set(gca, 'Position', pos)
                        subplot(1,3,2)
                        V2=.8:.01:1.1;
                        plot(V2+mean(diff(V2)),histc(IBI,V2),'k-o','Linewidth',2);hold on
                        plot([60./HR(i,i2,i3) 60./HR(i,i2,i3)],[0 1000],'b--','Linewidth',2)
                        plot([60./HR(i,i2,i3)-HRv(i,i2,i3)/1000 60./HR(i,i2,i3)-HRv(i,i2,i3)/1000],[0 1000],'r:','Linewidth',2)
                        plot([60./HR(i,i2,i3)+HRv(i,i2,i3)/1000 60./HR(i,i2,i3)+HRv(i,i2,i3)/1000],[0 1000],'r:','Linewidth',2)
                        xlabel('NN interval (s)');ylabel('Number of NN intervals')
                        legend('Distribution of NN intervals','Mean','Mean - 1*SD','Mean + 1*SD','location','northwest')
                        set(gca,'ylim',[0 50],'xlim',[min(V2) max(V2)])
                        pos = get(gca, 'Position');pos(1)=.54;pos(3)=.40;set(gca, 'Position', pos)
                        set(gcf, 'PaperPositionMode', 'manual','paperunits','inches','PaperPosition', [0 0 15 10]);
                        set(gca, 'LooseInset', [0.01 0.01 0.01 0.01]);
                        fig=gcf;set(findall(fig,'-property','FontName'),'FontName','Arial','Fontsize',16)
                    end
                    
                    if  i3==9
                        N=length(S(V,2));
                        f=1000/N*(0:N-1);
                        temp3=zscore(S(V,2));
                        temp5=tiedrank(zscore(filtfilt(bb,aa,temp3)));temp5=temp5./max(temp5);
                        Y = fft(temp5,N);Y=abs(Y);
                        TH2=ceil(find(f<.05,1,'last')); % 0.05 Hz filter order
                        temp6=medfilt1(Y,TH2,'truncate');
                        [~,b]=max(temp6(2:5000));b=b+1; % find peak
                        RR(i,i2,i3)=f(b)*60;
                        
                        figure
                        subplot(1,3,1)
                        plot(T,temp3,'k');hold on
                        set(gca,'xlim',[0 100])
                        ylabel('Respiratory signal (z-score)');xlabel('Time (s)')
                        pos = get(gca, 'Position');pos(1)=.04;pos(3)=.27;set(gca, 'Position', pos)
                        subplot(1,3,2)
                        plot(T,temp5,'k')
                        set(gca,'xlim',[0 100],'ylim',[0 1])
                        pos = get(gca, 'Position');pos(1)=.38;pos(3)=.27;set(gca, 'Position', pos)
                        ylabel('Respiratory signal (0-1)');xlabel('Time (s)')
                        subplot(1,3,3)
                        plot(f(2:end)*60,Y(2:end),'k');hold on
                        plot(f(2:end)*60,temp6(2:end),'r','Linewidth',3);
                        plot(f(b)*60,temp6(b),'go','Markersize',14,'linewidth',3);
                        pos = get(gca, 'Position');pos(1)=.72;pos(3)=.27;set(gca, 'Position', pos)
                        set(gca,'xlim',[0 60])
                        xlabel('Respiratory rate (bpm)');ylabel('Amplitude')
                        legend('Fourier transform','Fourier transform median filtered','Peak value')
                        set(gcf, 'PaperPositionMode', 'manual','paperunits','inches','PaperPosition', [0 0 15 10]);
                        set(gca, 'LooseInset', [0.01 0.01 0.01 0.01]);
                        fig=gcf;set(findall(fig,'-property','FontName'),'FontName','Arial','Fontsize',16)
                    end % end RR plot
                end %% end RR calculation if i3==9
            end %% end if data available
        end
    end
end
disp('50th percentile GPS accuracy')
disp(prctile(Accuracy_all,50));
disp('95th percentile GPS accuracy')
disp(prctile(Accuracy_all,95));
disp('99th percentile GPS accuracy')
disp(prctile(Accuracy_all,99));

% For the S-matrix
% Column 1 = Time in Matlab format
% Column 2 = Respiratory signal
% Column 3 = Button volt
% Column 4 = ECG
% Column 5 = Respiratory rate
% Column 6 = Heart rate
% Column 7 = IBI
% Column 8 = Driving speed
% Column 9 = GPS accuracy
% Column 10 = GPS lateral
% Column 11 = GPS longitudinal
%%
HM=double(hits'<=TH); % matrix of HITS
HM(48:50,1:2:end)=NaN; % PP1, 3, 5, 7, and 9 drove southbound when they performed the detection task. They encountered 47 bridges. The other participants encountered 50 bridges
HM(1:14,3)=NaN; % cable not plugged in for first 14 bridges for PP3
HM(35:end,4)=NaN; % route ended prematurely for PP4
HM([23:27 39:43],6)=NaN; % gaps for PP6
HITS = nansum(HM==1); % number of hits per participant
MISSES=nansum(HM==0); % number of misses per participant
FALSE =BP_stats(:,2)'; % number of false alarms
BRIDGES=sum(~isnan(HM));
BRIDGESMAX=[47 50 47 50 47 50 47 50 47];
disp('Missing bridges for participants 1-9:')
disp(BRIDGESMAX-BRIDGES);
HITR=100*HITS./BRIDGES;
FAR=100*FALSE./BRIDGES;
disp('Mean and SD hit rate (%)')
disp([mean(HITR) std(HITR)])
disp('Mean and SD false alarm rate (%)')
disp([mean(FAR) std(FAR)])
figure;hold on
colormap([.3 .3 .3;.8 .8 .8;1 1 1]);
bar([HITS;BRIDGES-HITS;BRIDGESMAX-BRIDGES]','stacked')
lh=legend('Bridge hits','Bridge misses','No data','location','southeast');
lh.PlotChildren = lh.PlotChildren(3:-1:1);
xlabel('Participant number','FontSize',22,'FontName','Arial')
ylabel('Number of bridges','Fontsize',22)
set(gca,'xlim',[.5 9.5],'LooseInset', [0.01 0.01 0.01 0.01])
fig=gcf;set(findall(fig,'-property','FontName'),'FontName','Arial','Fontsize',22)
set(gcf, 'PaperPositionMode', 'manual','paperunits','inches','PaperPosition', [0 0 15 10]);

FPrate=mean(FAR)/100;
HRrate=mean(HITR)/100;
criterion = -sqrt(2)*erfcinv(-2*FPrate+2);  % here the criterion is expressed with respect to the center of the noise distribution
d = criterion+sqrt(2)*erfcinv(-2*HRrate+2);
b = normpdf(criterion,d,1)./normpdf(criterion,0,1); % calculate beta
disp('Sensitivity index d prime=')
disp(round(d,2))
disp('Response bias beta')
disp(round(b,2))

disp([transpose(1:50) HM])
%%
vars2={'LabVST'
    'DT' % duration
    'DT2' % duration in seconds
    'HR'
    'HRv'
    'HRv2'
    'HRv3'
    'HRv4'
    'HRv5'
    'HRv6'
    'HRv7'
    'RR'
    'MS'
    'SETime'};
for i3=1:length(vars2)
    temp=eval(vars2{i3});
    tempr=[temp(1,1,:) temp(1,2,:) % length of session, sorted per run nr
        temp(2,2,:) temp(2,1,:)
        temp(3,1,:) temp(3,2,:)
        temp(4,2,:) temp(4,1,:)
        temp(5,1,:) temp(5,2,:)
        temp(6,2,:) temp(6,1,:)
        temp(7,1,:) temp(7,2,:)
        temp(8,2,:) temp(8,1,:)
        temp(9,1,:) temp(9,2,:)];
    eval([vars2{i3} 'r=tempr']);
end
%%
clc
OT=xlsread('Lane change and automation disengage data.xlsx','B4:S6');
OT1=OT(:,1:2:end)';OT2=OT(:,2:2:end)';
OTN=OT(:,[1	4	5	8	9	12	13	16	17])';OTT=OT(:,[2	3	6	7	10	11	14	15	18])';

disp(['Total automated lane change for Run 1, Run 2  = ' num2str(sum([OT1(:,1) OT2(:,1)]))])
disp(['SD automated lane change for Run 1, Run 2  = ' num2str(std([OT1(:,1) OT2(:,1)]))])
[~,p13,~,stats13]=ttest(OT1(:,1),OT2(:,1));
disp(['Run 1 vs. Run 2: t = ' sprintf('%0.2f',stats13.tstat) ', df = ' sprintf('%0.0f',stats13.df) ', dz = ' sprintf('%0.2f',stats13.tstat/sqrt(stats13.df+1)) ', p = ' sprintf('%0.3f',p13)])
disp(' ')
disp(['Total manual lane changes for Run 1, Run 2  = ' num2str(sum([OT1(:,2) OT2(:,2)]))])
disp(['SD manual lane changes for Run 1, Run 2  = ' num2str(std([OT1(:,2) OT2(:,2)]))])
[~,p13,~,stats13]=ttest(OT1(:,2),OT2(:,2));
disp(['Run 1 vs. Run 2: t = ' sprintf('%0.2f',stats13.tstat) ', df = ' sprintf('%0.0f',stats13.df) ', dz = ' sprintf('%0.2f',stats13.tstat/sqrt(stats13.df+1)) ', p = ' sprintf('%0.3f',p13)])
disp(' ')
disp(['Total manual interventions for Run 1, Run 2  = ' num2str(sum([OT1(:,3) OT2(:,3)]))])
disp(['SD manual interventions for Run 1, Run 2  = ' num2str(std([OT1(:,3) OT2(:,3)]))])
[~,p13,~,stats13]=ttest(OT1(:,3),OT2(:,3));
disp(['Run 1 vs. Run 2: t = ' sprintf('%0.2f',stats13.tstat) ', df = ' sprintf('%0.0f',stats13.df) ', dz = ' sprintf('%0.2f',stats13.tstat/sqrt(stats13.df+1)) ', p = ' sprintf('%0.3f',p13)])
disp(' ')
disp(['Total automated lane change for No Task, Task  = ' num2str(sum([OTN(:,1) OTT(:,1)]))])
disp(['SD automated lane change for No Task, Task  = ' num2str(std([OTN(:,1) OTT(:,1)]))])
[~,p13,~,stats13]=ttest(OTN(:,1),OTT(:,1));
disp(['NT vs. T: t = ' sprintf('%0.2f',stats13.tstat) ', df = ' sprintf('%0.0f',stats13.df) ', dz = ' sprintf('%0.2f',stats13.tstat/sqrt(stats13.df+1)) ', p = ' sprintf('%0.3f',p13)])

disp(['Total manual lane changes for No Task, Task  = ' num2str(sum([OTN(:,2) OTT(:,2)]))])
disp(['SD manual lane changes for No Task, Task  = ' num2str(std([OTN(:,2) OTT(:,2)]))])
[~,p13,~,stats13]=ttest(OTN(:,2),OTT(:,2));
disp(['NT vs. T: t = ' sprintf('%0.2f',stats13.tstat) ', df = ' sprintf('%0.0f',stats13.df) ', dz = ' sprintf('%0.2f',stats13.tstat/sqrt(stats13.df+1)) ', p = ' sprintf('%0.3f',p13)])

disp(['Total manual interventions for No Task, Task  = ' num2str(sum([OTN(:,3) OTT(:,3)]))])
disp(['SD manual interventions for No Task, Task  = ' num2str(std([OTN(:,3) OTT(:,3)]))])
[~,p13,~,stats13]=ttest(OTN(:,3),OTT(:,3));
disp(['NT vs. T: t = ' sprintf('%0.2f',stats13.tstat) ', df = ' sprintf('%0.0f',stats13.df) ', dz = ' sprintf('%0.2f',stats13.tstat/sqrt(stats13.df+1)) ', p = ' sprintf('%0.3f',p13)])
%% Mean duration
disp(['Mean duration for Run 1, Run 2 (excluding pp4) = ' num2str(nanmean(DT2r([1:3 5:9],:,9)))])
disp(['SD duration for Run 1, Run 2 (excluding pp4) = ' num2str(nanstd(DT2r([1:3 5:9],:,9)))])
[~,p13,~,stats13]=ttest(DT2r([1:3 5:9],1,9),DT2r([1:3 5:9],2,9));
disp(['Run 1 vs. Run 2: t = ' sprintf('%0.2f',stats13.tstat) ', df = ' sprintf('%0.0f',stats13.df) ', dz = ' sprintf('%0.2f',stats13.tstat/sqrt(stats13.df+1)) ', p = ' sprintf('%0.3f',p13)])
disp(' ')
%% Mean speed
disp(['Mean mean speed (km/h) for Run 1, Run 2  = ' num2str(nanmean(3.6*MSr(1:9,:,9)))])
disp(['SD mean speed (km/h) for Run 1, Run 2 = ' num2str(nanstd(3.6*MSr(1:9,:,9)))])
[~,p13,~,stats13]=ttest(3.6*MSr(1:9,1,9),3.6*MSr(1:9,2,9));
disp(['Run 1 vs. Run 2: t = ' sprintf('%0.2f',stats13.tstat) ', df = ' sprintf('%0.0f',stats13.df) ', dz = ' sprintf('%0.2f',stats13.tstat/sqrt(stats13.df+1)) ', p = ' sprintf('%0.3f',p13)])
disp(' ')
%% TLX OW (%)
disp(['Mean TLX overall workload for Run 1, Run 2  = ' num2str(nanmean(TLXJLRr(:,:,7)))])
disp(['SD TLX overall workload for Run 1, Run 2 = ' num2str(nanstd(TLXJLRr(:,:,7)))])
[~,p13,~,stats13]=ttest(TLXJLRr(1:9,1,7),TLXJLRr(1:9,2,7));
disp(['Run 1 vs. Run 2: t = ' sprintf('%0.2f',stats13.tstat) ', df = ' sprintf('%0.0f',stats13.df) ', dz = ' sprintf('%0.2f',stats13.tstat/sqrt(stats13.df+1)) ', p = ' sprintf('%0.3f',p13)])
disp(' ')
%% TLX OW (%)
disp(['Mean TLX overall workload for No Task, Task  = ' num2str(nanmean(TLXJLRC(:,:,7)))])
disp(['SD TLX overall workload for No Task, Task = ' num2str(nanstd(TLXJLRC(:,:,7)))])
[~,p13,~,stats13]=ttest(TLXJLRC(1:9,1,7),TLXJLRC(1:9,2,7));
disp(['Run 1 vs. Run 2: t = ' sprintf('%0.2f',stats13.tstat) ', df = ' sprintf('%0.0f',stats13.df) ', dz = ' sprintf('%0.2f',stats13.tstat/sqrt(stats13.df+1)) ', p = ' sprintf('%0.3f',p13)])
disp(' ')
%% DSSQ engagement
disp(['Mean DSSQ engagement for Run 1, 2 = ' num2str(nanmean(DSSQJLRS(:,2:3,1)))])
disp(['SD DSSQ engagement for Run 1, 2 = ' num2str(nanstd(DSSQJLRS(:,2:3,1)))])
[~,p13,~,stats13]=ttest(DSSQJLRS(:,2,1),DSSQJLRS(:,3,1));
disp(['Run 1 vs. Run 2: t = ' sprintf('%0.2f',stats13.tstat) ', df = ' sprintf('%0.0f',stats13.df) ', dz = ' sprintf('%0.2f',stats13.tstat/sqrt(stats13.df+1)) ', p = ' sprintf('%0.3f',p13)])
disp(' ')
%% DSSQ distress
disp(['Mean DSSQ distress for Run 1, 2 = ' num2str(nanmean(DSSQJLRS(:,2:3,2)))])
disp(['SD DSSQ  distress for Run 1, 2 = ' num2str(nanstd(DSSQJLRS(:,2:3,2)))])
[~,p13,~,stats13]=ttest(DSSQJLRS(:,2,2),DSSQJLRS(:,3,2));
disp(['Run 1 vs. Run 2: t = ' sprintf('%0.2f',stats13.tstat) ', df = ' sprintf('%0.0f',stats13.df) ', dz = ' sprintf('%0.2f',stats13.tstat/sqrt(stats13.df+1)) ', p = ' sprintf('%0.3f',p13)])
disp(' ')
%% DSSQ worry
disp(['Mean DSSQ worry for Run 1, 2 = ' num2str(nanmean(DSSQJLRS(:,2:3,3)))])
disp(['SD DSSQ worry for Run 1, 2 = ' num2str(nanstd(DSSQJLRS(:,2:3,3)))])
[~,p13,~,stats13]=ttest(DSSQJLRS(:,2,3),DSSQJLRS(:,3,3));
disp(['Run 1 vs. Run 2: t = ' sprintf('%0.2f',stats13.tstat) ', df = ' sprintf('%0.0f',stats13.df) ', dz = ' sprintf('%0.2f',stats13.tstat/sqrt(stats13.df+1)) ', p = ' sprintf('%0.3f',p13)])
disp(' ')
%% SDNN
HRvrC=HRvr;HRvrC(round(DT/1000)~=300)=NaN; % only when there is complete info available
disp(['Mean SDNN for Run 1, 2 = ' num2str(nanmean(nanmean(HRvrC(:,:,1:8),3)))])
disp(['SD SDNN for Run 1, 2 = ' num2str(nanstd(nanmean(HRvrC(:,:,1:8),3)))])
[~,p13,~,stats13]=ttest(nanmean(HRvrC(:,1,1:8),3),nanmean(HRvrC(:,2,1:8),3));
disp(['Run 1 vs. Run 2: t = ' sprintf('%0.2f',stats13.tstat) ', df = ' sprintf('%0.0f',stats13.df) ', dz = ' sprintf('%0.2f',stats13.tstat/sqrt(stats13.df+1)) ', p = ' sprintf('%0.3f',p13)])
disp(' ')

y1=squeeze(nanmean(HRr(1:9,1,1:6),1));y2=squeeze(nanmean(HRr(1:9,2,1:6),1));
disp('Heart rate in 5 min segments')
disp([y1 y2])

y1=squeeze(nanmean(HRvrC(1:9,1,1:6),1));y2=squeeze(nanmean(HRvrC(1:9,2,1:6),1));
disp('SDNN in 5 min segments')
disp([y1 y2])

%% LF/HF ratio
disp(['Mean LF/HF ratio for Run 1, 2 = ' num2str(nanmean(nanmean(HRv2r(:,:,9),3)))])
disp(['SD LF/HF ratio for Run 1, 2 = ' num2str(nanstd(nanmean(HRv2r(:,:,9),3)))])
[~,p13,~,stats13]=ttest(nanmean(HRv2r(:,1,9),3),nanmean(HRv2r(:,2,9),3));
disp(['Run 1 vs. Run 2: t = ' sprintf('%0.2f',stats13.tstat) ', df = ' sprintf('%0.0f',stats13.df) ', dz = ' sprintf('%0.2f',stats13.tstat/sqrt(stats13.df+1)) ', p = ' sprintf('%0.3f',p13)])
disp(' ')
%% Respiratory rate
disp(['Mean respiratory rate for Run 1, 2 = ' num2str(nanmean(nanmean(RRr([1 2:9],:,9),3)))])
disp(['SD respiratory rate for Run 1, 2 = ' num2str(nanstd(nanmean(RRr([1 2:9],:,9),3)))])
[~,p13,~,stats13]=ttest(nanmean(RRr([1 2:9],1,9),3),nanmean(RRr([1 2:9],2,9),3));
disp(['Run 1 vs. Run 2: t = ' sprintf('%0.2f',stats13.tstat) ', df = ' sprintf('%0.0f',stats13.df) ', dz = ' sprintf('%0.2f',stats13.tstat/sqrt(stats13.df+1)) ', p = ' sprintf('%0.3f',p13)])
disp(' ')
%%
clc
disp('Start and end times. No Task, Detection Task')
disp([datestr(SETimer(:,1,1)) datestr(SETimer(:,2,1))])
disp('Overall TLX workload Run 1 Run 2')
disp(round(TLXJLRr(:,:,7)))
disp('Mean TLX workload averaged over Runs 1 and 2, per TLX item')
disp(round(squeeze(mean(mean(TLXJLRr(:,:,1:6)),2))))
disp('SD TLX workload averaged over Runs 1 and 2, per TLX item')
disp(round(std(squeeze(mean(TLXJLRr(:,:,1:6),2))))')
disp('Duration of task')
disp(round([DT2r(:,1,end-2) DT2r(:,2,end-2)]))
disp('Mean speed (km/h)')
disp(round([3.6*MSr(:,1,9) 3.6*MSr(:,2,9)],1))
disp('Heart rate (bpm)')
disp(round(nanmean(HRr(:,:,9),3),1))
disp('SDNN (ms)')
disp(round(nanmean(HRvrC(:,:,1:8),3),1))
disp('LF/HF ratio')
disp(round(nanmean(HRv2r(:,:,9),3),2))
disp('Respiratory rate')
disp(round(nanmean(RRr(:,:,9),3),1))
disp('Engagement')
disp(round(DSSQJLRS(:,2:3,1),2))
disp('Distress')
disp(round(DSSQJLRS(:,2:3,2),2))
disp('Worry')
disp(round(DSSQJLRS(:,2:3,3),2))

rho=corr(mean(nanmean(HRr(:,:,9),3),2),mean(nanmean(HRvrC(:,:,1:8),3),2),'type','spearman');
disp('Correlation between heart rate (bpm) and SDNN (ms)')
disp(rho)