function saveFigureAsPDF(path, filename, width_mm, height_mm)
    % SAVEFIGUREASPDF Save the current figure as a high-quality PDF with specified dimensions.
    %
    %   path      - Directory path to save the file.
    %   filename  - Name of the file (e.g., 'figure.pdf').
    %   width_mm  - Width of the figure in millimeters.
    %   height_mm - Height of the figure in millimeters.

    % Convert dimensions to inches (1 inch = 25.4 mm)
    width_in = width_mm / 25.4;
    height_in = height_mm / 25.4;
    
    % Set paper size and position
    set(gcf, 'PaperUnits', 'inches');
    set(gcf, 'PaperSize', [width_in, height_in]); % Paper size for PDF
    set(gcf, 'PaperPosition', [0, 0, width_in, height_in]); % Position of figure on paper

    % Ensure directory exists
    if ~isfolder(path)
        mkdir(path);
    end
    
    % Construct the full file path
    fullFilePath = fullfile(path, filename);
    
    % Save as high-quality PDF
    print(fullFilePath, '-dpdf', '-r300'); % High-resolution PDF (300 DPI)
    
    % Display a message confirming save
    fprintf('Figure saved as PDF: %s\n', fullFilePath);
end