clear all
addpath(fullfile(pwd,'sw'))
pathstr = fullfile(pwd,'images');       
%%
syms s k1_rm_pos k2_rm_pos k3_rm_pos k1_rm_att k2_rm_att k3_rm_att k1_ec_pos k2_ec_pos k3_ec_pos  k1_ec_att k2_ec_att k3_ec_att omega_u p_1_att p_2_att p_3_att p_att
H_att_E_indi = (omega_u*(s^2 + k2_ec_att*s + k1_ec_att*k2_ec_att))/(s^3 + omega_u*s^2 + k2_ec_att*omega_u*s + k1_ec_att*k2_ec_att*omega_u) %[output:9a5415b3]
H_att_E_andi = 1;
H_att_RM     = (k1_rm_att*k2_rm_att*k3_rm_att)/(s^3+k3_rm_att*s^2+k2_rm_att*k3_rm_att*s+k1_rm_att*k2_rm_att*k3_rm_att) %[output:48bcda57]
H_att_indi = collect(simplify(expand(H_att_RM * H_att_E_indi)),s) %[output:2710757c]
H_att_andi = collect(simplify(expand(H_att_RM * H_att_E_andi)),s) %[output:5de54a82]
%%
%[text] Define Functions to get the RM and EC gains based on desired poles
k_1_3_f = @(omega_n,zeta,p_1)(omega_n^2*p_1)/(omega_n^2+2*zeta*omega_n*p_1);
k_2_3_f = @(omega_n,zeta,p_1)(omega_n^2+2*zeta*omega_n*p_1)/(2*zeta*omega_n+p_1);
k_3_3_f = @(omega_n,zeta,p_1)2*zeta*omega_n+p_1;

k_1_2_f = @(omega_n,zeta) omega_n / (2*zeta);
k_2_2_f = @(omega_n,zeta) 2*zeta*omega_n;
k_3_2_f = @(omega_n,zeta) 1;
%[text] Define the poles of the Attitude Dynamics
omega_motor    = 10.1;
omega_n_att_rm = 4.71;
zeta_att_rm    = 1.0;
omega_n_att_ec = 4.5; %sqrt(7.68^3/omega_motor);
zeta_att_ec    = 1.0;


w_att      = omega_n_att_rm*zeta_att_rm/3;
FO_att     = tf(w_att,[1,w_att]);
k_1_rm_att = k_1_3_f(omega_n_att_rm,zeta_att_rm,omega_n_att_rm*zeta_att_rm);
k_2_rm_att = k_2_3_f(omega_n_att_rm,zeta_att_rm,omega_n_att_rm*zeta_att_rm);
k_3_rm_att = k_3_3_f(omega_n_att_rm,zeta_att_rm,omega_n_att_rm*zeta_att_rm);
k_att_rm   = [k_1_rm_att,k_2_rm_att,k_3_rm_att];

k_1_ec_att = k_1_3_f(omega_n_att_ec,zeta_att_ec,omega_motor);
k_2_ec_att = k_2_3_f(omega_n_att_ec,zeta_att_ec,omega_motor);
k_3_ec_att = k_3_3_f(omega_n_att_ec,zeta_att_ec,omega_motor);
k_att_ec   = [k_1_ec_att,k_2_ec_att,k_3_ec_att];

k_1_ec_att_indi = k_1_2_f(omega_n_att_ec,zeta_att_ec);
k_2_ec_att_indi = k_2_2_f(omega_n_att_ec,zeta_att_ec);
k_3_ec_att_indi = k_3_2_f(omega_n_att_ec,zeta_att_ec);
k_att_ec_indi   = [k_1_ec_att_indi, k_2_ec_att_indi, k_3_ec_att_indi];
%[text] Calculate the numerical TF of the attitude loop RM:
att_rm_num = subs(H_att_RM,k1_rm_att,k_1_rm_att);
att_rm_num = subs(att_rm_num,k2_rm_att,k_2_rm_att);
att_rm_num = subs(att_rm_num,k3_rm_att,k_3_rm_att);
att_rm_num = collect(simplify(att_rm_num),s);
[num,den]  = numden(att_rm_num);
num_coefs  = sym2poly(num);
den_coefs  = sym2poly(den);
sys_att_rm = tf(num_coefs, den_coefs);
%[text] Calculate the ANDI and INDI attitude actual/des TF
att_andi  = subs(H_att_andi,k1_rm_att,k_1_rm_att);
att_andi  = subs(att_andi,k2_rm_att,k_2_rm_att);
att_andi  = subs(att_andi,k3_rm_att,k_3_rm_att);
att_andi  = collect(simplify(att_andi),s);
[num,den] = numden(att_andi);
num_coefs = sym2poly(num);
den_coefs = sym2poly(den);
sys_att_andi = tf(num_coefs, den_coefs);

att_indi = subs(H_att_indi,k1_rm_att,k_1_rm_att);
att_indi = subs(att_indi,k2_rm_att,k_2_rm_att);
att_indi = subs(att_indi,k3_rm_att,k_3_rm_att);
att_indi = subs(att_indi,k1_ec_att,k_1_ec_att);
att_indi = subs(att_indi,k2_ec_att,k_2_ec_att);
att_indi = subs(att_indi,omega_u,omega_motor);
att_indi = collect(simplify(att_indi),s);
[num,den] = numden(att_indi);
num_coefs = sym2poly(num);
den_coefs = sym2poly(den);
sys_att_indi = tf(num_coefs, den_coefs);
%%
LineWidth = 2.0;
FontSize = 10;
%%
% Extract Bode data for the two systems
[mag_sys1, phase_sys1, w_sys1] = bode(sys_att_rm); % System 1
[mag_sys2, phase_sys2, w_sys2] = bode(FO_att);     % System 2

% Reshape the magnitude and phase data if needed
mag_sys1 = squeeze(mag_sys1); % Convert to 2D if multi-dimensional
phase_sys1 = squeeze(phase_sys1);
mag_sys2 = squeeze(mag_sys2);
phase_sys2 = squeeze(phase_sys2);

% Create figure and tiled layout
fig = figure(10); %[output:00a81b7b]
clf; %[output:00a81b7b]
t = tiledlayout(2, 1, 'TileSpacing', 'Compact', 'Padding', 'Compact'); %[output:00a81b7b]

% Plot Magnitude for both systems
nexttile; %[output:00a81b7b]
semilogx(w_sys1, 20*log10(mag_sys1), 'b', 'LineWidth', LineWidth); % Sys 1 %[output:00a81b7b]
hold on; %[output:00a81b7b]
semilogx(w_sys2, 20*log10(mag_sys2), 'r--', 'LineWidth', LineWidth); % Sys 2 %[output:00a81b7b]
grid on; %[output:00a81b7b]
ylabel('Magnitude ($dB$)', 'Interpreter', 'latex', 'FontSize', FontSize); %[output:00a81b7b]
set(gca, 'FontSize', FontSize); %[output:00a81b7b]
hold off; %[output:00a81b7b]
xlim([0.1,100]) %[output:00a81b7b]

% Plot Phase for both systems
nexttile; %[output:00a81b7b]
semilogx(w_sys1, phase_sys1, 'b', 'LineWidth', LineWidth); % Sys 1 %[output:00a81b7b]
hold on; %[output:00a81b7b]
semilogx(w_sys2, phase_sys2, 'r--', 'LineWidth', LineWidth); % Sys 2 %[output:00a81b7b]
grid on; %[output:00a81b7b]
xlabel('Frequency ($\frac{rad}{s}$)', 'Interpreter', 'latex', 'FontSize', FontSize); %[output:00a81b7b]
ylabel('Phase ($^\circ$)', 'Interpreter', 'latex', 'FontSize', FontSize); %[output:00a81b7b]
set(gca, 'FontSize', FontSize); %[output:00a81b7b]
hold off; %[output:00a81b7b]
xlim([0.1,100]) %[output:00a81b7b]

% Add a legend
leg = legend('$H_{3rd}$', '$H_{1st}$', 'Interpreter', 'latex', 'Location', 'southwest'); %[output:00a81b7b]
set(leg, 'ItemTokenSize', [18, 1]); % Adjust legend line length %[output:00a81b7b]

% Save the figure
saveFigureAsPDF(pathstr, 'actuator_order_comparison.pdf', 83, 83); %[output:00a81b7b] %[output:2b427f9c]

%%
% Extract Bode data for the two systems
[mag_sys1, phase_sys1, w_sys1] = bode(sys_att_andi); % ANDI System
[mag_sys2, phase_sys2, w_sys2] = bode(sys_att_indi); % INDI System

% Reshape the magnitude and phase data if needed
mag_sys1 = squeeze(mag_sys1); % Convert to 2D if multi-dimensional
phase_sys1 = squeeze(phase_sys1);
mag_sys2 = squeeze(mag_sys2);
phase_sys2 = squeeze(phase_sys2);

% Create figure and tiled layout
fig = figure(2); %[output:63735fac]
clf; %[output:63735fac]
t = tiledlayout(2, 1, 'TileSpacing', 'Compact', 'Padding', 'Compact'); %[output:63735fac]

% Plot Magnitude for both systems
nexttile; %[output:63735fac]
semilogx(w_sys1, 20*log10(mag_sys1), 'b', 'LineWidth', LineWidth); % ANDI %[output:63735fac]
hold on; %[output:63735fac]
semilogx(w_sys2, 20*log10(mag_sys2), 'r--', 'LineWidth', LineWidth); % INDI %[output:63735fac]
grid on; %[output:63735fac]
ylabel('Magnitude ($dB$)', 'Interpreter', 'latex', 'FontSize', FontSize); %[output:63735fac]
set(gca, 'FontSize', FontSize); %[output:63735fac]
hold off; %[output:63735fac]
xlim([0.1, 100]); %[output:63735fac]

% Plot Phase for both systems
nexttile; %[output:63735fac]
semilogx(w_sys1, phase_sys1, 'b', 'LineWidth', LineWidth); % ANDI %[output:63735fac]
hold on; %[output:63735fac]
semilogx(w_sys2, phase_sys2, 'r--', 'LineWidth', LineWidth); % INDI %[output:63735fac]
grid on; %[output:63735fac]
xlabel('Frequency ($\frac{rad}{s}$)', 'Interpreter', 'latex', 'FontSize', FontSize); %[output:63735fac]
ylabel('Phase ($^\circ$)', 'Interpreter', 'latex', 'FontSize', FontSize); %[output:63735fac]
set(gca, 'FontSize', FontSize); %[output:63735fac]
hold off; %[output:63735fac]
xlim([0.1, 100]); %[output:63735fac]

% Add a legend
leg = legend('ANDI', 'INDI', 'Interpreter', 'latex', 'Location', 'southwest'); %[output:63735fac]
set(leg, 'ItemTokenSize', [18, 1]); % Adjust legend line length %[output:63735fac]

% Save the figure as a high-quality PDF
saveFigureAsPDF(pathstr, 'H_att_andi_indi.pdf', 83, 83); %[output:63735fac] %[output:6163506d]
%%
%[text] Define the Poles of the Position Dynamics
omega_pos_ec = 1.0; %sqrt(1.41^3/w_att);
zeta_pos_ec  = 1.0;
omega_pos_rm = 0.93;
zeta_pos_rm  = 1.0;
%[text] Calculate the RM gains
k_1_rm_pos = k_1_3_f(omega_pos_rm,zeta_pos_rm,omega_pos_rm*zeta_pos_rm);
k_2_rm_pos = k_2_3_f(omega_pos_rm,zeta_pos_rm,omega_pos_rm*zeta_pos_rm);
k_3_rm_pos = k_3_3_f(omega_pos_rm,zeta_pos_rm,omega_pos_rm*zeta_pos_rm);
k_pos_rm   = [k_1_rm_pos, k_2_rm_pos, k_3_rm_pos];

k_1_ec_pos = k_1_3_f(omega_pos_ec,zeta_pos_ec,w_att);
k_2_ec_pos = k_2_3_f(omega_pos_ec,zeta_pos_ec,w_att);
k_3_ec_pos = k_3_3_f(omega_pos_ec,zeta_pos_ec,w_att);
k_pos_ec   = [k_1_ec_pos, k_2_ec_pos, k_3_ec_pos];

k_1_ec_pos_indi = k_1_2_f(omega_pos_ec,zeta_pos_ec);
k_2_ec_pos_indi = k_2_2_f(omega_pos_ec,zeta_pos_ec);
k_3_ec_pos_indi = k_3_2_f(omega_pos_ec,zeta_pos_ec);
k_pos_ec_indi   = [k_1_ec_pos_indi, k_2_ec_pos_indi, k_3_ec_pos_indi];
%[text] ANDI 
% H_pos_E_andi = ((p_1_att*p_2_att + p_1_att*p_3_att + p_2_att*p_3_att)*s^3 + (k3_e_pos*p_1_att*p_2_att + k3_e_pos*p_1_att*p_3_att + k3_e_pos*p_2_att*p_3_att)*s^2 + (k2_e_pos*p_1_att*p_2_att + k2_e_pos*p_1_att*p_3_att + k2_e_pos*p_2_att*p_3_att)*s + k1_e_pos*p_1_att*p_2_att + k1_e_pos*p_1_att*p_3_att + k1_e_pos*p_2_att*p_3_att)/(s^5 + (p_1_att + p_2_att + p_3_att)*s^4 + (p_1_att*p_2_att + p_1_att*p_3_att + p_2_att*p_3_att)*s^3 + (k3_e_pos*p_1_att*p_2_att + k3_e_pos*p_1_att*p_3_att + k3_e_pos*p_2_att*p_3_att)*s^2 + (k2_e_pos*p_1_att*p_2_att + k2_e_pos*p_1_att*p_3_att + k2_e_pos*p_2_att*p_3_att)*s + k1_e_pos*p_1_att*p_2_att + k1_e_pos*p_1_att*p_3_att + k1_e_pos*p_2_att*p_3_att)
H_pos_E_andi = ((p_1_att*p_2_att + p_1_att*p_3_att + p_2_att*p_3_att)*s^3 + (k3_ec_pos*p_1_att*p_2_att + k3_ec_pos*p_1_att*p_3_att + k3_ec_pos*p_2_att*p_3_att)*s^2 + (k2_ec_pos*k3_ec_pos*p_1_att*p_2_att + k2_ec_pos*k3_ec_pos*p_1_att*p_3_att + k2_ec_pos*k3_ec_pos*p_2_att*p_3_att)*s + k1_ec_pos*k2_ec_pos*k3_ec_pos*p_1_att*p_2_att + k1_ec_pos*k2_ec_pos*k3_ec_pos*p_1_att*p_3_att + k1_ec_pos*k2_ec_pos*k3_ec_pos*p_2_att*p_3_att)/(s^5 + (p_1_att + p_2_att + p_3_att)*s^4 + (p_1_att*p_2_att + p_1_att*p_3_att + p_2_att*p_3_att)*s^3 + (k3_ec_pos*p_1_att*p_2_att + k3_ec_pos*p_1_att*p_3_att + k3_ec_pos*p_2_att*p_3_att)*s^2 + (k2_ec_pos*k3_ec_pos*p_1_att*p_2_att + k2_ec_pos*k3_ec_pos*p_1_att*p_3_att + k2_ec_pos*k3_ec_pos*p_2_att*p_3_att)*s + k1_ec_pos*k2_ec_pos*k3_ec_pos*p_1_att*p_2_att + k1_ec_pos*k2_ec_pos*k3_ec_pos*p_1_att*p_3_att + k1_ec_pos*k2_ec_pos*k3_ec_pos*p_2_att*p_3_att) %[output:98a492f1]
H_pos_E_andi_paper = H_pos_E_andi;
H_pos_E_andi_paper = subs(H_pos_E_andi_paper, p_1_att, p_att);
H_pos_E_andi_paper = subs(H_pos_E_andi_paper, p_2_att, p_att);
H_pos_E_andi_paper = subs(H_pos_E_andi_paper, p_3_att, p_att);
H_pos_E_andi_paper = collect(simplify(H_pos_E_andi_paper),s) %[output:8c91d6df]

H_pos_E_andi = subs(H_pos_E_andi, k1_ec_pos, k_1_ec_pos);
H_pos_E_andi = subs(H_pos_E_andi, k2_ec_pos, k_2_ec_pos);
H_pos_E_andi = subs(H_pos_E_andi, k3_ec_pos, k_3_ec_pos);
H_pos_E_andi = subs(H_pos_E_andi, p_1_att, omega_n_att_rm*zeta_att_rm);
H_pos_E_andi = subs(H_pos_E_andi, p_2_att, omega_n_att_rm*zeta_att_rm);
H_pos_E_andi = subs(H_pos_E_andi, p_3_att, omega_n_att_rm*zeta_att_rm);
H_pos_E_andi = collect(simplify(H_pos_E_andi),s);
[num,den] = numden(H_pos_E_andi);
num_coefs = sym2poly(num);
den_coefs = sym2poly(den);
sys_H_pos_E_andi = tf(num_coefs, den_coefs);
%[text] INDI
%H_pos_E_indi = ((k3_e_pos*p_1_att*p_2_att*p_3_att)*s^2 + (k2_e_pos*p_1_att*p_2_att*p_3_att)*s + k1_e_pos*p_1_att*p_2_att*p_3_att)/(s^5 + (p_1_att + p_2_att + p_3_att)*s^4 + (p_1_att*p_2_att + p_1_att*p_3_att + p_2_att*p_3_att)*s^3 + (k3_e_pos*p_1_att*p_2_att*p_3_att)*s^2 + (k2_e_pos*p_1_att*p_2_att*p_3_att)*s + k1_e_pos*p_1_att*p_2_att*p_3_att)
H_pos_E_indi = ((k3_ec_pos*p_1_att*p_2_att*p_3_att)*s^2 + (k2_ec_pos*k3_ec_pos*p_1_att*p_2_att*p_3_att)*s + k1_ec_pos*k2_ec_pos*k3_ec_pos*p_1_att*p_2_att*p_3_att)/(s^5 + (p_1_att + p_2_att + p_3_att)*s^4 + (p_1_att*p_2_att + p_1_att*p_3_att + p_2_att*p_3_att)*s^3 + (k3_ec_pos*p_1_att*p_2_att*p_3_att)*s^2 + (k2_ec_pos*k3_ec_pos*p_1_att*p_2_att*p_3_att)*s + k1_ec_pos*k2_ec_pos*k3_ec_pos*p_1_att*p_2_att*p_3_att) %[output:3ca115ab]
H_pos_E_indi_paper = H_pos_E_indi;
H_pos_E_indi_paper = subs(H_pos_E_indi_paper, p_1_att, p_att);
H_pos_E_indi_paper = subs(H_pos_E_indi_paper, p_2_att, p_att);
H_pos_E_indi_paper = subs(H_pos_E_indi_paper, p_3_att, p_att);
H_pos_E_indi_paper = collect(simplify(H_pos_E_indi_paper),s) %[output:75231ebd]
omega_T = omega_motor;
p_att_rm = omega_n_att_rm * zeta_att_rm;
p_att_ec = omega_n_att_ec * zeta_att_ec;
k1_ec = k1_ec_pos;
k2_ec = k2_ec_pos;
k3_ec = k3_ec_pos;
H_pos_E_indi_full = ((omega_T*p_att_rm^3)*s^4 + (k2_ec*omega_T*p_att_rm^3 + 2*omega_T*p_att_ec*p_att_rm^3)*s^3 + (omega_T*p_att_ec^2*p_att_rm^3 + 2*k2_ec*omega_T*p_att_ec*p_att_rm^3 + k1_ec*k2_ec*omega_T*p_att_rm^3)*s^2 + (k2_ec*omega_T*p_att_ec^2*p_att_rm^3 + 2*k1_ec*k2_ec*omega_T*p_att_ec*p_att_rm^3)*s + k1_ec*k2_ec*omega_T*p_att_ec^2*p_att_rm^3)/(s^8 + (omega_T + 3*p_att_rm)*s^7 + (3*p_att_rm^2 + 3*omega_T*p_att_rm + 2*omega_T*p_att_ec)*s^6 + (omega_T*p_att_ec^2 + 6*omega_T*p_att_ec*p_att_rm + p_att_rm^3 + 3*omega_T*p_att_rm^2)*s^5 + (3*omega_T*p_att_ec^2*p_att_rm + 6*omega_T*p_att_ec*p_att_rm^2 + omega_T*p_att_rm^3)*s^4 + (3*omega_T*p_att_ec^2*p_att_rm^2 + 2*omega_T*p_att_ec*p_att_rm^3 + k2_ec*omega_T*p_att_rm^3)*s^3 + (omega_T*p_att_ec^2*p_att_rm^3 + 2*k2_ec*omega_T*p_att_ec*p_att_rm^3 + k1_ec*k2_ec*omega_T*p_att_rm^3)*s^2 + (k2_ec*omega_T*p_att_ec^2*p_att_rm^3 + 2*k1_ec*k2_ec*omega_T*p_att_ec*p_att_rm^3)*s + k1_ec*k2_ec*omega_T*p_att_ec^2*p_att_rm^3);
%%
H_pos_E_indi = subs(H_pos_E_indi, k1_ec_pos, k_1_ec_pos_indi);
H_pos_E_indi = subs(H_pos_E_indi, k2_ec_pos, k_2_ec_pos_indi);
H_pos_E_indi = subs(H_pos_E_indi, k3_ec_pos, k_3_ec_pos_indi);
H_pos_E_indi = subs(H_pos_E_indi, p_1_att, omega_n_att_rm*zeta_att_rm);
H_pos_E_indi = subs(H_pos_E_indi, p_2_att, omega_n_att_rm*zeta_att_rm);
H_pos_E_indi = subs(H_pos_E_indi, p_3_att, omega_n_att_rm*zeta_att_rm);
H_pos_E_indi = collect(simplify(H_pos_E_indi),s) %[output:08251513]
[num,den] = numden(H_pos_E_indi);
num_coefs = sym2poly(num);
den_coefs = sym2poly(den);
sys_H_pos_E_indi = tf(num_coefs, den_coefs);
%%
H_pos_E_indi_full = collect(simplify(vpa(H_pos_E_indi_full)),s) %[output:35640589]
H_pos_E_indi_full = subs(H_pos_E_indi_full, k1_ec_pos, k_1_ec_pos_indi);
H_pos_E_indi_full = subs(H_pos_E_indi_full, k2_ec_pos, k_2_ec_pos_indi);
H_pos_E_indi_full = subs(H_pos_E_indi_full, k3_ec_pos, k_3_ec_pos_indi);
H_pos_E_indi_full = subs(H_pos_E_indi_full, p_1_att, omega_n_att_rm*zeta_att_rm);
H_pos_E_indi_full = subs(H_pos_E_indi_full, p_2_att, omega_n_att_rm*zeta_att_rm);
H_pos_E_indi_full = subs(H_pos_E_indi_full, p_3_att, omega_n_att_rm*zeta_att_rm);
H_pos_E_indi_full = collect(simplify(H_pos_E_indi_full),s) %[output:702911b1]
[num,den] = numden(H_pos_E_indi_full);
num_coefs = sym2poly(num);
den_coefs = sym2poly(den);
sys_H_pos_E_indi_full = tf(num_coefs, den_coefs);
%%
H_pos_RM = H_att_RM;
H_pos_RM = subs(H_pos_RM, k1_rm_att, k_1_rm_pos);
H_pos_RM = subs(H_pos_RM, k2_rm_att, k_2_rm_pos);
H_pos_RM = subs(H_pos_RM, k3_rm_att, k_3_rm_pos);
H_pos_RM = collect(simplify(H_pos_RM),s);
[num,den] = numden(H_pos_RM);
num_coefs = sym2poly(num);
den_coefs = sym2poly(den);
sys_H_pos_RM = tf(num_coefs, den_coefs);
%%
% Extract Bode data for the system
[mag_sys, phase_sys, w_sys] = bode(sys_H_pos_RM); % System H_pos_RM

% Reshape the magnitude and phase data if needed
mag_sys = squeeze(mag_sys); % Convert to 2D if multi-dimensional
phase_sys = squeeze(phase_sys);

% Create figure and tiled layout
fig = figure(5); %[output:0035482d]
clf; %[output:0035482d]
t = tiledlayout(2, 1, 'TileSpacing', 'Compact', 'Padding', 'Compact'); %[output:0035482d]

% Plot Magnitude
nexttile; %[output:0035482d]
semilogx(w_sys, 20*log10(mag_sys), 'b', 'LineWidth', LineWidth); % Plot magnitude %[output:0035482d]
grid on; %[output:0035482d]
ylabel('Magnitude ($dB$)', 'Interpreter', 'latex', 'FontSize', FontSize); %[output:0035482d]
set(gca, 'FontSize', FontSize); %[output:0035482d]
xlim([0.1,10]) %[output:0035482d]
% Plot Phase
nexttile; %[output:0035482d]
semilogx(w_sys, phase_sys, 'b', 'LineWidth', LineWidth); % Plot phase %[output:0035482d]
grid on; %[output:0035482d]
xlabel('Frequency ($\frac{rad}{s}$)', 'Interpreter', 'latex', 'FontSize', FontSize); %[output:0035482d]
ylabel('Phase ($^\circ$)', 'Interpreter', 'latex', 'FontSize', FontSize); %[output:0035482d]
set(gca, 'FontSize', FontSize); %[output:0035482d]
xlim([0.1,10]) %[output:0035482d]
% Remove global title
title(''); %[output:0035482d]

% Save the figure as a high-quality PDF
saveFigureAsPDF(pathstr, 'H_pos_rm.pdf', 83, 83); %[output:0035482d] %[output:39a4f257]
%%
% Extract Bode data for the two systems
f_interest = 0.8;
freq_range = logspace(-1, 2, 500);
[mag_sys1, phase_sys1, w_sys1] = bode(sys_H_pos_E_andi,freq_range); % ANDI System
[mag_sys2, phase_sys2, w_sys2] = bode(sys_H_pos_E_indi,freq_range); % INDI System

% Reshape the magnitude and phase data if needed
mag_sys1 = squeeze(mag_sys1); % Convert to 2D if multi-dimensional
phase_sys1 = squeeze(phase_sys1);
mag_sys2 = squeeze(mag_sys2);
phase_sys2 = squeeze(phase_sys2);
% Find the gain and phase at f_interest for ANDI
[~, idx_andi] = min(abs(w_sys1 - f_interest));
gain_andi = mag_sys1(idx_andi);
phase_andi = phase_sys1(idx_andi);

% Find the gain and phase at f_interest for INDI
[~, idx_indi] = min(abs(w_sys2 - f_interest));
gain_indi = mag_sys2(idx_indi);
phase_indi = phase_sys2(idx_indi);

% Print the gain and phase at the frequency of interest
fprintf('ANDI: Gain at %0.2f Hz: %0.2f dB\n', f_interest, 20*log10(gain_andi)); %[output:77c5f8cf]
fprintf('ANDI: Phase at %0.2f Hz: %0.2f degrees\n', f_interest, phase_andi); %[output:4f330940]

fprintf('INDI: Gain at %0.2f Hz: %0.2f dB\n', f_interest, 20*log10(gain_indi)); %[output:934a2ec4]
fprintf('INDI: Phase at %0.2f Hz: %0.2f degrees\n', f_interest, phase_indi); %[output:0980e653]
% Create figure and tiled layout
fig = figure(3); %[output:7fa039b8]
clf; %[output:7fa039b8]
t = tiledlayout(2, 1, 'TileSpacing', 'Compact', 'Padding', 'Compact'); %[output:7fa039b8]

% Plot Magnitude for both systems
nexttile; %[output:7fa039b8]
semilogx(w_sys1, 20*log10(mag_sys1), 'b', 'LineWidth', LineWidth); % ANDI %[output:7fa039b8]
hold on; %[output:7fa039b8]
semilogx(w_sys2, 20*log10(mag_sys2), 'r--', 'LineWidth', LineWidth); % INDI %[output:7fa039b8]
grid on; %[output:7fa039b8]
ylabel('Magnitude ($dB$)', 'Interpreter', 'latex', 'FontSize', FontSize); %[output:7fa039b8]
set(gca, 'FontSize', FontSize); %[output:7fa039b8]
xlim([0.1, 10]); % Set x-axis limits %[output:7fa039b8]
ylim([-20, 20]); % Set y-axis limits %[output:7fa039b8]
hold off; %[output:7fa039b8]

% Plot Phase for both systems
nexttile; %[output:7fa039b8]
semilogx(w_sys1, phase_sys1, 'b', 'LineWidth', LineWidth); % ANDI %[output:7fa039b8]
hold on; %[output:7fa039b8]
semilogx(w_sys2, phase_sys2, 'r--', 'LineWidth', LineWidth); % INDI %[output:7fa039b8]
grid on; %[output:7fa039b8]
xlabel('Frequency ($\frac{rad}{s}$)', 'Interpreter', 'latex', 'FontSize', FontSize); %[output:7fa039b8]
ylabel('Phase ($^\circ$)', 'Interpreter', 'latex', 'FontSize', FontSize); %[output:7fa039b8]
set(gca, 'FontSize', FontSize); %[output:7fa039b8]
xlim([0.1, 10]); % Set x-axis limits %[output:7fa039b8]
hold off; %[output:7fa039b8]

% Add a legend
leg = legend('ANDI', 'INDI', 'Interpreter', 'latex', 'Location', 'southwest'); %[output:7fa039b8]
set(leg, 'ItemTokenSize', [18, 1]); % Adjust legend line length %[output:7fa039b8]

% Save the figure as a high-quality PDF
saveFigureAsPDF(pathstr, 'H_pos_E_andi_indi.pdf', 83, 83); %[output:7fa039b8] %[output:0e3486c5]

%[appendix]
%---
%[metadata:view]
%   data: {"layout":"inline","rightPanelPercent":40}
%---
%[output:9a5415b3]
%   data: {"dataType":"symbolic","outputData":{"name":"H_att_E_indi","value":"\\frac{\\omega_u \\,{\\left(s^2 +k_{2,\\textrm{ec},\\textrm{att}} \\,s+k_{1,\\textrm{ec},\\textrm{att}} \\,k_{2,\\textrm{ec},\\textrm{att}} \\right)}}{s^3 +\\omega_u \\,s^2 +k_{2,\\textrm{ec},\\textrm{att}} \\,\\omega_u \\,s+k_{1,\\textrm{ec},\\textrm{att}} \\,k_{2,\\textrm{ec},\\textrm{att}} \\,\\omega_u }"}}
%---
%[output:48bcda57]
%   data: {"dataType":"symbolic","outputData":{"name":"H_att_RM","value":"\\frac{k_{1,\\textrm{rm},\\textrm{att}} \\,k_{2,\\textrm{rm},\\textrm{att}} \\,k_{3,\\textrm{rm},\\textrm{att}} }{s^3 +k_{3,\\textrm{rm},\\textrm{att}} \\,s^2 +k_{2,\\textrm{rm},\\textrm{att}} \\,k_{3,\\textrm{rm},\\textrm{att}} \\,s+k_{1,\\textrm{rm},\\textrm{att}} \\,k_{2,\\textrm{rm},\\textrm{att}} \\,k_{3,\\textrm{rm},\\textrm{att}} }"}}
%---
%[output:2710757c]
%   data: {"dataType":"symbolic","outputData":{"name":"H_att_indi","value":"\\begin{array}{l}\n\\frac{{\\left(k_{1,\\textrm{rm},\\textrm{att}} \\,k_{2,\\textrm{rm},\\textrm{att}} \\,k_{3,\\textrm{rm},\\textrm{att}} \\,\\omega_u \\right)}\\,s^2 +\\sigma_2 \\,s+\\sigma_1 }{s^6 +{\\left(k_{3,\\textrm{rm},\\textrm{att}} +\\omega_u \\right)}\\,s^5 +{\\left(k_{2,\\textrm{rm},\\textrm{att}} \\,k_{3,\\textrm{rm},\\textrm{att}} +k_{2,\\textrm{ec},\\textrm{att}} \\,\\omega_u +k_{3,\\textrm{rm},\\textrm{att}} \\,\\omega_u \\right)}\\,s^4 +{\\left(k_{1,\\textrm{rm},\\textrm{att}} \\,k_{2,\\textrm{rm},\\textrm{att}} \\,k_{3,\\textrm{rm},\\textrm{att}} +k_{1,\\textrm{ec},\\textrm{att}} \\,k_{2,\\textrm{ec},\\textrm{att}} \\,\\omega_u +k_{2,\\textrm{ec},\\textrm{att}} \\,k_{3,\\textrm{rm},\\textrm{att}} \\,\\omega_u +k_{2,\\textrm{rm},\\textrm{att}} \\,k_{3,\\textrm{rm},\\textrm{att}} \\,\\omega_u \\right)}\\,s^3 +{\\left(k_{1,\\textrm{ec},\\textrm{att}} \\,k_{2,\\textrm{ec},\\textrm{att}} \\,k_{3,\\textrm{rm},\\textrm{att}} \\,\\omega_u +k_{2,\\textrm{ec},\\textrm{att}} \\,k_{2,\\textrm{rm},\\textrm{att}} \\,k_{3,\\textrm{rm},\\textrm{att}} \\,\\omega_u +k_{1,\\textrm{rm},\\textrm{att}} \\,k_{2,\\textrm{rm},\\textrm{att}} \\,k_{3,\\textrm{rm},\\textrm{att}} \\,\\omega_u \\right)}\\,s^2 +{\\left(k_{1,\\textrm{ec},\\textrm{att}} \\,k_{2,\\textrm{ec},\\textrm{att}} \\,k_{2,\\textrm{rm},\\textrm{att}} \\,k_{3,\\textrm{rm},\\textrm{att}} \\,\\omega_u +\\sigma_2 \\right)}\\,s+\\sigma_1 }\\\\\n\\mathrm{}\\\\\n\\textrm{where}\\\\\n\\mathrm{}\\\\\n\\;\\;\\sigma_1 =k_{1,\\textrm{ec},\\textrm{att}} \\,k_{2,\\textrm{ec},\\textrm{att}} \\,k_{1,\\textrm{rm},\\textrm{att}} \\,k_{2,\\textrm{rm},\\textrm{att}} \\,k_{3,\\textrm{rm},\\textrm{att}} \\,\\omega_u \\\\\n\\mathrm{}\\\\\n\\;\\;\\sigma_2 =k_{2,\\textrm{ec},\\textrm{att}} \\,k_{1,\\textrm{rm},\\textrm{att}} \\,k_{2,\\textrm{rm},\\textrm{att}} \\,k_{3,\\textrm{rm},\\textrm{att}} \\,\\omega_u \n\\end{array}"}}
%---
%[output:5de54a82]
%   data: {"dataType":"symbolic","outputData":{"name":"H_att_andi","value":"\\frac{k_{1,\\textrm{rm},\\textrm{att}} \\,k_{2,\\textrm{rm},\\textrm{att}} \\,k_{3,\\textrm{rm},\\textrm{att}} }{s^3 +k_{3,\\textrm{rm},\\textrm{att}} \\,s^2 +{\\left(k_{2,\\textrm{rm},\\textrm{att}} \\,k_{3,\\textrm{rm},\\textrm{att}} \\right)}\\,s+k_{1,\\textrm{rm},\\textrm{att}} \\,k_{2,\\textrm{rm},\\textrm{att}} \\,k_{3,\\textrm{rm},\\textrm{att}} }"}}
%---
%[output:00a81b7b]
%   data: {"dataType":"image","outputData":{"dataUri":"data:image\/png;base64,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","height":337,"width":560}}
%---
%[output:2b427f9c]
%   data: {"dataType":"text","outputData":{"text":"Figure saved as PDF: \/home\/tomaso\/UANDI_controller_VSQP\/images\/actuator_order_comparison.pdf\n","truncated":false}}
%---
%[output:63735fac]
%   data: {"dataType":"image","outputData":{"dataUri":"data:image\/png;base64,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","height":337,"width":560}}
%---
%[output:6163506d]
%   data: {"dataType":"text","outputData":{"text":"Figure saved as PDF: \/home\/tomaso\/UANDI_controller_VSQP\/images\/H_att_andi_indi.pdf\n","truncated":false}}
%---
%[output:98a492f1]
%   data: {"dataType":"symbolic","outputData":{"name":"H_pos_E_andi","value":"\\begin{array}{l}\n\\frac{\\sigma_3 +\\sigma_2 +\\sigma_1 +k_{1,\\textrm{ec},\\textrm{pos}} \\,k_{2,\\textrm{ec},\\textrm{pos}} \\,k_{3,\\textrm{ec},\\textrm{pos}} \\,p_{1,\\textrm{att}} \\,p_{2,\\textrm{att}} +k_{1,\\textrm{ec},\\textrm{pos}} \\,k_{2,\\textrm{ec},\\textrm{pos}} \\,k_{3,\\textrm{ec},\\textrm{pos}} \\,p_{1,\\textrm{att}} \\,p_{3,\\textrm{att}} +k_{1,\\textrm{ec},\\textrm{pos}} \\,k_{2,\\textrm{ec},\\textrm{pos}} \\,k_{3,\\textrm{ec},\\textrm{pos}} \\,p_{2,\\textrm{att}} \\,p_{3,\\textrm{att}} }{s^5 +{\\left(p_{1,\\textrm{att}} +p_{2,\\textrm{att}} +p_{3,\\textrm{att}} \\right)}\\,s^4 +\\sigma_3 +\\sigma_2 +\\sigma_1 +k_{1,\\textrm{ec},\\textrm{pos}} \\,k_{2,\\textrm{ec},\\textrm{pos}} \\,k_{3,\\textrm{ec},\\textrm{pos}} \\,p_{1,\\textrm{att}} \\,p_{2,\\textrm{att}} +k_{1,\\textrm{ec},\\textrm{pos}} \\,k_{2,\\textrm{ec},\\textrm{pos}} \\,k_{3,\\textrm{ec},\\textrm{pos}} \\,p_{1,\\textrm{att}} \\,p_{3,\\textrm{att}} +k_{1,\\textrm{ec},\\textrm{pos}} \\,k_{2,\\textrm{ec},\\textrm{pos}} \\,k_{3,\\textrm{ec},\\textrm{pos}} \\,p_{2,\\textrm{att}} \\,p_{3,\\textrm{att}} }\\\\\n\\mathrm{}\\\\\n\\textrm{where}\\\\\n\\mathrm{}\\\\\n\\;\\;\\sigma_1 ={\\left(k_{2,\\textrm{ec},\\textrm{pos}} \\,k_{3,\\textrm{ec},\\textrm{pos}} \\,p_{1,\\textrm{att}} \\,p_{2,\\textrm{att}} +k_{2,\\textrm{ec},\\textrm{pos}} \\,k_{3,\\textrm{ec},\\textrm{pos}} \\,p_{1,\\textrm{att}} \\,p_{3,\\textrm{att}} +k_{2,\\textrm{ec},\\textrm{pos}} \\,k_{3,\\textrm{ec},\\textrm{pos}} \\,p_{2,\\textrm{att}} \\,p_{3,\\textrm{att}} \\right)}\\,s\\\\\n\\mathrm{}\\\\\n\\;\\;\\sigma_2 ={\\left(k_{3,\\textrm{ec},\\textrm{pos}} \\,p_{1,\\textrm{att}} \\,p_{2,\\textrm{att}} +k_{3,\\textrm{ec},\\textrm{pos}} \\,p_{1,\\textrm{att}} \\,p_{3,\\textrm{att}} +k_{3,\\textrm{ec},\\textrm{pos}} \\,p_{2,\\textrm{att}} \\,p_{3,\\textrm{att}} \\right)}\\,s^2 \\\\\n\\mathrm{}\\\\\n\\;\\;\\sigma_3 ={\\left(p_{1,\\textrm{att}} \\,p_{2,\\textrm{att}} +p_{1,\\textrm{att}} \\,p_{3,\\textrm{att}} +p_{2,\\textrm{att}} \\,p_{3,\\textrm{att}} \\right)}\\,s^3 \n\\end{array}"}}
%---
%[output:8c91d6df]
%   data: {"dataType":"symbolic","outputData":{"name":"H_pos_E_andi_paper","value":"\\begin{array}{l}\n\\frac{\\sigma_3 +\\sigma_1 +\\sigma_2 +3\\,k_{1,\\textrm{ec},\\textrm{pos}} \\,k_{2,\\textrm{ec},\\textrm{pos}} \\,k_{3,\\textrm{ec},\\textrm{pos}} \\,{p_{\\textrm{att}} }^2 }{s^5 +{\\left(3\\,p_{\\textrm{att}} \\right)}\\,s^4 +\\sigma_3 +\\sigma_1 +\\sigma_2 +3\\,k_{1,\\textrm{ec},\\textrm{pos}} \\,k_{2,\\textrm{ec},\\textrm{pos}} \\,k_{3,\\textrm{ec},\\textrm{pos}} \\,{p_{\\textrm{att}} }^2 }\\\\\n\\mathrm{}\\\\\n\\textrm{where}\\\\\n\\mathrm{}\\\\\n\\;\\;\\sigma_1 ={\\left(3\\,k_{3,\\textrm{ec},\\textrm{pos}} \\,{p_{\\textrm{att}} }^2 \\right)}\\,s^2 \\\\\n\\mathrm{}\\\\\n\\;\\;\\sigma_2 ={\\left(3\\,k_{2,\\textrm{ec},\\textrm{pos}} \\,k_{3,\\textrm{ec},\\textrm{pos}} \\,{p_{\\textrm{att}} }^2 \\right)}\\,s\\\\\n\\mathrm{}\\\\\n\\;\\;\\sigma_3 ={\\left(3\\,{p_{\\textrm{att}} }^2 \\right)}\\,s^3 \n\\end{array}"}}
%---
%[output:3ca115ab]
%   data: {"dataType":"symbolic","outputData":{"name":"H_pos_E_indi","value":"\\frac{k_{3,\\textrm{ec},\\textrm{pos}} \\,p_{1,\\textrm{att}} \\,p_{2,\\textrm{att}} \\,p_{3,\\textrm{att}} \\,s^2 +k_{2,\\textrm{ec},\\textrm{pos}} \\,k_{3,\\textrm{ec},\\textrm{pos}} \\,p_{1,\\textrm{att}} \\,p_{2,\\textrm{att}} \\,p_{3,\\textrm{att}} \\,s+k_{1,\\textrm{ec},\\textrm{pos}} \\,k_{2,\\textrm{ec},\\textrm{pos}} \\,k_{3,\\textrm{ec},\\textrm{pos}} \\,p_{1,\\textrm{att}} \\,p_{2,\\textrm{att}} \\,p_{3,\\textrm{att}} }{s^5 +{\\left(p_{1,\\textrm{att}} +p_{2,\\textrm{att}} +p_{3,\\textrm{att}} \\right)}\\,s^4 +{\\left(p_{1,\\textrm{att}} \\,p_{2,\\textrm{att}} +p_{1,\\textrm{att}} \\,p_{3,\\textrm{att}} +p_{2,\\textrm{att}} \\,p_{3,\\textrm{att}} \\right)}\\,s^3 +k_{3,\\textrm{ec},\\textrm{pos}} \\,p_{1,\\textrm{att}} \\,p_{2,\\textrm{att}} \\,p_{3,\\textrm{att}} \\,s^2 +k_{2,\\textrm{ec},\\textrm{pos}} \\,k_{3,\\textrm{ec},\\textrm{pos}} \\,p_{1,\\textrm{att}} \\,p_{2,\\textrm{att}} \\,p_{3,\\textrm{att}} \\,s+k_{1,\\textrm{ec},\\textrm{pos}} \\,k_{2,\\textrm{ec},\\textrm{pos}} \\,k_{3,\\textrm{ec},\\textrm{pos}} \\,p_{1,\\textrm{att}} \\,p_{2,\\textrm{att}} \\,p_{3,\\textrm{att}} }"}}
%---
%[output:75231ebd]
%   data: {"dataType":"symbolic","outputData":{"name":"H_pos_E_indi_paper","value":"\\frac{{\\left(k_{3,\\textrm{ec},\\textrm{pos}} \\,{p_{\\textrm{att}} }^3 \\right)}\\,s^2 +{\\left(k_{2,\\textrm{ec},\\textrm{pos}} \\,k_{3,\\textrm{ec},\\textrm{pos}} \\,{p_{\\textrm{att}} }^3 \\right)}\\,s+k_{1,\\textrm{ec},\\textrm{pos}} \\,k_{2,\\textrm{ec},\\textrm{pos}} \\,k_{3,\\textrm{ec},\\textrm{pos}} \\,{p_{\\textrm{att}} }^3 }{s^5 +{\\left(3\\,p_{\\textrm{att}} \\right)}\\,s^4 +{\\left(3\\,{p_{\\textrm{att}} }^2 \\right)}\\,s^3 +{\\left(k_{3,\\textrm{ec},\\textrm{pos}} \\,{p_{\\textrm{att}} }^3 \\right)}\\,s^2 +{\\left(k_{2,\\textrm{ec},\\textrm{pos}} \\,k_{3,\\textrm{ec},\\textrm{pos}} \\,{p_{\\textrm{att}} }^3 \\right)}\\,s+k_{1,\\textrm{ec},\\textrm{pos}} \\,k_{2,\\textrm{ec},\\textrm{pos}} \\,k_{3,\\textrm{ec},\\textrm{pos}} \\,{p_{\\textrm{att}} }^3 }"}}
%---
%[output:08251513]
%   data: {"dataType":"symbolic","outputData":{"name":"H_pos_E_indi","value":"\\frac{104487111\\,s^2 +208974222\\,s+104487111}{1000000\\,s^5 +14130000\\,s^4 +66552300\\,s^3 +104487111\\,s^2 +208974222\\,s+104487111}"}}
%---
%[output:35640589]
%   data: {"dataType":"symbolic","outputData":{"name":"H_pos_E_indi_full","value":"\\begin{array}{l}\n\\frac{527659910549999949580524116754530.0\\,s^4 +{\\left(527659910549999993634173733880740.0\\,k_{2,\\textrm{ec},\\textrm{pos}} +\\text{4.7489391949499995462247170507908e+33}\\right)}\\,s^3 +\\sigma_1 +\\sigma_2 +\\text{1.0685113188637499871092018111085e+34}\\,k_{1,\\textrm{ec},\\textrm{pos}} \\,k_{2,\\textrm{ec},\\textrm{pos}} }{500000000000000000000000000000.0\\,s^8 +12115000000000000000000000000000.0\\,s^7 +150082650000000001000444171950220.0\\,s^6 +\\text{1.1328036704999999528808984905481e+33}\\,s^5 +\\text{4.9974310705500001859036274254322e+33}\\,s^4 +{\\left(527659910549999993634173733880740.0\\,k_{2,\\textrm{ec},\\textrm{pos}} +\\text{1.1554743773700000019744038581848e+34}\\right)}\\,s^3 +\\sigma_1 +\\sigma_2 +\\text{1.0685113188637499871092018111085e+34}\\,k_{1,\\textrm{ec},\\textrm{pos}} \\,k_{2,\\textrm{ec},\\textrm{pos}} }\\\\\n\\mathrm{}\\\\\n\\textrm{where}\\\\\n\\mathrm{}\\\\\n\\;\\;\\sigma_1 ={\\left(\\text{4.7489391949499999427075636049267e+33}\\,k_{2,\\textrm{ec},\\textrm{pos}} +527659910549999993634173733880740.0\\,k_{1,\\textrm{ec},\\textrm{pos}} \\,k_{2,\\textrm{ec},\\textrm{pos}} +\\text{1.0685113188637500570621341466904e+34}\\right)}\\,s^2 \\\\\n\\mathrm{}\\\\\n\\;\\;\\sigma_2 ={\\left(\\text{1.0685113188637499871092018111085e+34}\\,k_{2,\\textrm{ec},\\textrm{pos}} +\\text{4.7489391949499999427075636049267e+33}\\,k_{1,\\textrm{ec},\\textrm{pos}} \\,k_{2,\\textrm{ec},\\textrm{pos}} \\right)}\\,s\n\\end{array}"}}
%---
%[output:702911b1]
%   data: {"dataType":"symbolic","outputData":{"name":"H_pos_E_indi_full","value":"\\frac{527659910549999949580524116754530.0\\,s^4 +\\text{5.8042590160499995334930645185523e+33}\\,s^3 +\\text{2.0710651489087500449670642410638e+34}\\,s^2 +\\text{2.6119165572224999684891599827097e+34}\\,s+\\text{1.0685113188637499871092018111085e+34}}{500000000000000000000000000000.0\\,s^8 +12115000000000000000000000000000.0\\,s^7 +150082650000000001000444171950220.0\\,s^6 +\\text{1.1328036704999999528808984905481e+33}\\,s^5 +\\text{4.9974310705500001859036274254322e+33}\\,s^4 +\\text{1.261006359480000000701238604961e+34}\\,s^3 +\\text{2.0710651489087500449670642410638e+34}\\,s^2 +\\text{2.6119165572224999684891599827097e+34}\\,s+\\text{1.0685113188637499871092018111085e+34}}"}}
%---
%[output:0035482d]
%   data: {"dataType":"image","outputData":{"dataUri":"data:image\/png;base64,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","height":337,"width":560}}
%---
%[output:39a4f257]
%   data: {"dataType":"text","outputData":{"text":"Figure saved as PDF: \/home\/tomaso\/UANDI_controller_VSQP\/images\/H_pos_rm.pdf\n","truncated":false}}
%---
%[output:77c5f8cf]
%   data: {"dataType":"text","outputData":{"text":"ANDI: Gain at 0.80 Hz: 0.05 dB\n","truncated":false}}
%---
%[output:4f330940]
%   data: {"dataType":"text","outputData":{"text":"ANDI: Phase at 0.80 Hz: 1.69 degrees\n","truncated":false}}
%---
%[output:934a2ec4]
%   data: {"dataType":"text","outputData":{"text":"INDI: Gain at 0.80 Hz: 1.72 dB\n","truncated":false}}
%---
%[output:0980e653]
%   data: {"dataType":"text","outputData":{"text":"INDI: Phase at 0.80 Hz: 5.32 degrees\n","truncated":false}}
%---
%[output:7fa039b8]
%   data: {"dataType":"image","outputData":{"dataUri":"data:image\/png;base64,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","height":337,"width":560}}
%---
%[output:0e3486c5]
%   data: {"dataType":"text","outputData":{"text":"Figure saved as PDF: \/home\/tomaso\/UANDI_controller_VSQP\/images\/H_pos_E_andi_indi.pdf\n","truncated":false}}
%---
