%% Technical validation and calibration of grasping instrumetn with ShaftFlex add-on
clc
clear all
close all

set(groot, 'defaultAxesFontSize', 10);
set(groot, 'defaultTextFontSize', 12);

%% Raw data
% Raw data first calibration step
mass = [0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7];
pressure_mass = ([128, 133, 139, 145, 152, 161, 170, 179]-128)*5/512; %(with offset x0 set to 0 and converted to voltage)

% Conversion from mass to grasping force
force = mass*9.81;

% Raw data second calibration step (both with offset x0 set to 0 and converted to voltage)
pressure_output = ([128, 129, 130, 131, 132, 133, 136, 137, 138, 139, 140, 142, 143, 145, 146, 149, 150, 151, 153, 154, 156, 159, 162, 167, 171]-128)*5/512;
hall_output = ([718, 730, 743, 747, 753, 765, 775, 783, 787, 791, 795, 798, 801, 803, 805, 807, 808, 810, 811, 812, 813, 816, 817, 818, 819]-718)*5/1024;

%% Plot mass-pressure relation obtained from the first calibration step
figure
subplot(2,2,1)
plot(pressure_mass, force, 'Color', [8/256 48/256 107/256], 'LineWidth', 2)
title('a) Calibration results (step 1)')
xlabel('Pressure sensor output voltage [V]')
ylabel('Grasping force [N]')
grid on

saveas(gcf, 'calibration_step1.png');

%% Plot pressure-hall sensor relation obtained from second calibration step
subplot(2,2,2)
plot(hall_output, pressure_output, 'Color', [8/256 48/256 107/256], 'LineWidth', 2)
title('b) Calibration results (step 2)')
xlabel('Hall sensor output voltage [V]')
ylabel('Pressure sensor output voltage [V]')
grid on

saveas(gcf, 'calibration_step2.png');


%% Linear interpolation: combining step 1 and 2
force_interpolation = interp1(pressure_mass, force, pressure_output);

%% Resulting exponential interpolation
[fitobject, gof] = fit(hall_output(:), force_interpolation(:), 'exp2');
kracht = 1.09*(fitobject.a*exp(fitobject.b*hall_output)+fitobject.c*exp(fitobject.d*hall_output));

%% Final calibration plot
subplot(2,2,[3 4])
hold on
plot(hall_output, kracht, 'Color', [8/256 48/256 107/256], 'LineWidth', 2)
plot(hall_output, force_interpolation, '.', 'MarkerSize', 8, 'MarkerEdgeColor', [103/256,0,13/256], 'LineStyle', 'none')
annotation('textbox',[.15 .25 .1 .1],'String','$$F=1.2723 \cdot 10^{-12} \cdot e^{56.31x}+0.3956 \cdot e^{5.149x}$$', 'Interpreter', 'latex', 'FitBoxToText','on');
title('c) Final calibration results ')
xlabel('Hall sensor output voltage [V]')
ylabel('Grasping force [N]')
legend('Exponential fit','Experimental data', "Position", [0.60059,0.22054,0.26429,0.082536])
grid on

exportgraphics(gcf, 'final_calibration.png', "Resolution",600);
