# Dataset overview

This dataset contains self-documenting Jupyter notebooks that can be used to reproduce the figures of the associated manuscript.
The directory `afidtools` contains a local Python package for analysing the simulation output stored in the directory `data`.
Snapshots used in the figures are provided as image files in the directory `pore-snaps`.
Processed data is also found in three HDF5 files, whose contents are detailed below.

## `sim_data_2D.h5`
This file contains the data processed from the two-dimensional pore-scale simulations.
Each simulation is stored in its own group stored at the top level of the file, following the naming convention
`RaX.X_HdYY_ZZ'
- X.X denotes the value of the Rayleigh number $Ra_d$ (or more precisely its base 10 logarithm)
- YY denotes the value of $H/d$, the ratio between the domain height and the bead diameter
- ZZ is one of the strings 'r', 'i1', or 'i2' depending on whether the beads are regularly spaced ('r') or they are randomly shifted ('i1' or 'i2')

Each of these simulation groups contains the following data:
Scalar values
- `Hd`: Domain height to bead diameter ratio $H/d$
- `Ra`: Rayleigh number based on the domain height $Ra_H$
- `Ra_d`: Rayleigh number based on the bead diameter $Ra_d=Ra_H*(d/H)^3$
- `U`: Buoyancy velocity scale $U$
Vectors (time series data)
- `t`: Time coordinates (scaled by free-fall units and H) $t/\sqrt{\rho_0 H/ g\Delta \rho}$
- `td`: Time scaled by bead diameter and buoyancy velocity$t/(d/U)$
- `tl`: Time scaled by buoyancy-diffusion scales $l$ and $U$: $t/(\phi l/U)$
- `h`: Height of mixing layer relative to domain height $h/H$
- `hd`: Mixing layer height relative to bead diameter $h/d$
- `hd_chi`: Mixing layer measured using threshold for $\chi$ , relative to $d$
- `hl`: Mixing layer height relative to buoy-diff scale $h/l$
- `hl_chi`: Mixing layer measured using threshold for $\chi$, relative to $l$
- `chi_U`: Scalar dissipation rate scaled by buoyancy velocity $\chi/(U\Delta C^2 /H)$

## `finger_data_2D.h5`
This file contains time series for the finger wavelengths at the centre of the domain from the simulations.
The file is organised just as the `sim_data_2D.h5`, with the additional data vectors:
- `lambdaL`: Time series for wavelengths calculated from the horizontal cut of concentration just below the centreline
- `lambdaU`: Time series for wavelengths calculated from the horizontal cut of concentration just above the centreline

## `experiments.h5`
This file contains the time series and physical parameters for each laboratory experiment.
Data for each experiment is contained in the top level groups 'Ex' where x can be any integer from 1 to 16.
Within each experiment group, the following data can be accessed:

Parameters
- `H`: Domain height in metres
- `d`: Bead diameter in metres
- `ell`: Buoyancy-diffusion length scale in metres
- `U`: Buoyancy-diffusion velocity scale (metre/second)
- `D`: Molecular diffusivity (m^2/s^-3)
- `Drho`: Initial density difference between upper and lower fluid (kg/m^3)
- `rho`: Reference fluid density (kg/m^3)
- `temp`: Temperature (Celsius)
- `k`: Permeability (m^2)
- `mf`: Mass fraction
- `mu`: Dynamic viscosity (kg / m s)
- `phi`: Porosity
- `Ra_cH`: Rayleigh number based on the domain height
- `Ra_cd`: Rayleigh number based on the bead diameter
- `Ra_H`: Rayleigh-Darcy number based on domain height
- `Ra_d`: Rayleigh-Darcy number based on domain height
- `Sc`: Schmidt number
- `Da_H`: Darcy number based on the domain height
- `Da_d`: Darcy number based on bead diameter

Vectors
- `t`: Time coordinate (s)
- `t_ndim`: Time scaled by buoyancy-diffusion scales $t/(\phi l / U)$
- `h`: Mixing length height (m)
- `h_ndim`: Mixing length height scaled by buoyancy-diffusion length $h/l$