import numpy as np
import matplotlib.pyplot as plt
from matplotlib import cm

fig, (ax3) = plt.subplots(nrows=1,ncols=1)
x0=np.loadtxt('./EOM-data/fortXvalues.dat',dtype='float')
y0=np.loadtxt('./EOM-data/V.txt',dtype='float')
X0,Y0= np.meshgrid(x0,y0)

d1x0 = np.loadtxt('./EOM-data/fortith_currentsBF000.dat',dtype='float')[:,0]
d1y1 = -np.loadtxt('./EOM-data/fortith_currentsBF000.dat',dtype='float')[:,1]
d1y2 = -np.loadtxt('./EOM-data/fortith_currentsBF003.dat',dtype='float')[:,1]
d1y3 = -np.loadtxt('./EOM-data/fortith_currentsBF006.dat',dtype='float')[:,1]
d1y4 = -np.loadtxt('./EOM-data/fortith_currentsBF009.dat',dtype='float')[:,1]
d1y5 = -np.loadtxt('./EOM-data/fortith_currentsBF012.dat',dtype='float')[:,1]

ax3.plot(d1x0,d1y1,color="black",linestyle="-",label="0.0")
ax3.plot(d1x0,d1y2,color="red",linestyle="-",label="0.6")
ax3.plot(d1x0,d1y3,color="green",linestyle="-",label="1.2")
ax3.plot(d1x0,d1y4,color="blue",linestyle="-",label="1.8")
ax3.plot(d1x0,d1y5,color="orange",linestyle="-",label="2.4")
#d1 = ax3.pcolormesh(X1,Y1,Z1,cmap='bwr')
#ax3.set_title("$T/T_K=0.5$",loc='center')
ax3.set_xlabel(r'$eV/k_BT_{\rm K}$')
ax3.set_ylabel(r'$I_{\rm th}$')
#ax3.set_ylim(ymin=1,ymax=2.05)
ax3.set_xlim(xmin=-10,xmax=10)
ax3.annotate(r'${\bf D}$',xy=(-0.1, 1.1), xycoords=ax3.transAxes)
ax3.axvline(x=0.0,color="grey",linestyle=":")
ax3.axhline(y=0.0,color="grey",linestyle=":")
legend = ax3.legend(loc='lower right', shadow=True, fontsize='medium',ncol=2)
#plt.legend(loc="lower right", mode = "expand", ncol = 1)

fig.tight_layout()
plt.savefig('ScienceFig3D.pdf')
plt.show()
