import numpy as np
import matplotlib.pyplot as plt
from matplotlib import cm
import scipy.stats
from scipy.interpolate import interp1d
from mpl_toolkits.axes_grid1 import make_axes_locatable, axes_size

fig, ax = plt.subplots(nrows=1,ncols=1)

exp_data=np.loadtxt('new-slopes-least-sq-fit3.dat',dtype='float')
xdat=exp_data[:,0]
ydat=exp_data[:,1]
yerr=exp_data[:,2]

exp_bdata=np.loadtxt('aspec-bfield.dat',dtype='float')
xbdat=exp_bdata[:,0]
ybdat=exp_bdata[:,1]
yberr=exp_bdata[:,2]

acoeff=np.loadtxt('./Fliq-data/ed7gamma/a_coeff.dat',dtype='float')
b=acoeff[:,0]
a0=acoeff[:,1]
a1=acoeff[:,2]
a2=acoeff[:,3]
a3=acoeff[:,4]
a4=acoeff[:,5]
a5=acoeff[:,6]
#a6=acoeff[:,7]

ccoeff=np.loadtxt('./Fliq-data/ed7gamma/c_coeff.dat',dtype='float')
c0=ccoeff[:,1]
c1=ccoeff[:,2]
c2=ccoeff[:,3]
c3=ccoeff[:,4]
c4=ccoeff[:,5]
c5=ccoeff[:,6]

bnew=np.linspace(0,2,num=101,endpoint='True')
a0_cubic = interp1d(b, a0, kind='cubic')
s0_cubic = interp1d(b, a1, kind='cubic')
s1_cubic = interp1d(b, a5-a2, kind='cubic')
#s1_cubic_lam0p2 = interp1d(b, 0.6666*a5-a2, kind='cubic')
cv_cubic = interp1d(b, c3, kind='cubic')
ct_cubic = interp1d(b, c2, kind='cubic')

#
#fit to the NRG result for the noninteracting model (U=0, e_0=-0.1 Gamma) using same "T_K" definition as in interacting model
#
def s10_fit(x):
    return (1-1.838*x*x)/((1+1.6317*x*x)**3)
x1 =np.arange(0.0,2.0,0.01)

ax.plot(x1, s10_fit(x1)/s10_fit(0.0),linestyle=':',color='green',label=r'$s_1(B)/s_1(0),\;\;U/\Gamma=0$')
s1=ax.plot(bnew, s1_cubic(bnew)/s1_cubic(0), '-',color='orange',label=r'$s_1(B)/s_1(0),\;\;U/\Gamma=16$')#B_{\rm th}\approx 0.75$')#\;,B_{\rm th}\approx 0.754T_{\rm K}$')
s1exp=ax.errorbar(xdat,ydat, yerr=yerr, color='black',fmt='.', label=r'$s_1^{\rm exp.}(B)$')#,\;\;B_{\rm th}^{\rm exp.}\approx 0.69$')#\;,B_{\rm th}^{\rm Exp.}\approx 0.69T_{\rm K}$')
ax.annotate(r"$0.75$",xy=(0.75,0.0),xytext=(0.75,+0.2),color='red',ha="center",fontsize=12,
                 arrowprops=dict(arrowstyle="->",color='red',facecolor='red',lw='1'))
ax.annotate(r"$0.69$",xy=(0.69,0.0),xytext=(0.69,-0.2),color='red',ha="center",fontsize=12,arrowprops=dict(arrowstyle="->",color='red',facecolor='red',lw='1'))
ax.axhline(y=0, color="grey", linestyle="--")
ax.axes.set_aspect(aspect=0.8)

ax.set_xlabel(r'$g\mu_{\rm B}B/k_{\rm B}T_{K}$',fontsize='small')
ax.set_ylabel(r'${s}_{1}(B)/s_{1}(0),\;s_{1}^{\rm exp.}(B)$',fontsize='small')

ax.set_ylim(ymin=-0.3,ymax=1.2)
ax.set_xlim(xmin=0,xmax=2.0)
ax.annotate(r'${\bf F}$)',xy=(-0.1, 1.1), xycoords=ax.transAxes)

legend = ax.legend(loc='upper center', shadow=False,frameon=False, fontsize='medium')


fig.tight_layout()
plt.savefig('ScienceFig3F.pdf')
#plt.savefig('ScienceFig3F.png')
plt.show()

