# The Cryptex shape memory mechanism: an antagonistic mechanical controller for follow-the-leader surgical instruments
#### Authors:  
Fabian Trauzettel, Pam van Zaanen, David Jager, Remi van Starkenburg, Jenny
Dankelman and Paul Breedveld

Medical Instruments  & Bio-Inspired Technology  
Corresponding author: F. Trauzettel  

#### Contact Information:
f.trauzettel@tudelft.nl  

Delft University of Technology - Faculty of Mechanical Engineering  
Mekelweg 2  
2628CD Delft  
The Netherlands  

#### General Introduction
The Cryptex Programmable Memory Mechanism (CPMM) is fully-mechanical Follow-the-Leader controller for tendon-driven, flexible catheters. 
#### Basic function
The system contains a series of memory rings that can slide on a splined shaft. By rotating the shaft, an agular position is chosen for the rings. A second, fixed shaft is apposed axially to the first. The memory rings can be translated on to the fixed shaft one by one each with an arbitrary position, allowing the user to program a path to be followed. 
Concentric to the fixed shaft is a set of 15 reading rings. As the memory rings are translated on to the fixed shaft, they pass through the reading rings. 
The reading and memory rings are connected via a compliant H-beam that is located in the annular space between the two sets of rings. Bearings in the outer surface of the memory and inner surface of the reading rings engage with the H-beam.
As the memory rings are in different positions, their bearings deform the H-beam into a sort of cam track, and as the memory rings travel through the reading rings, the reading rings translate the shape of the cam track into tendon displacements that can be connected to a steerable instrument shaft.

The final prototype is approximately 155 mm long, has an outer diameter of 60.5 mm, and weighs approximately 780 grams.
It possesses eight memory rings and 15 reading rings, allowing it to steer 15 tip segments. 

#### Purpose of the design
The goal of this research was to design an easy to implement shape-memory mechanism for tendon-driven follow-the-leader devices, by integrating antagonistic tendon control within the memory mechanism.


#### Description of the Dataset
The Dataset contains the Autodesk Inventor CAD files, as well as an open STEP file which can be viewed with most CAD programs.

- To view the assembly using Autodesk Inventor (2024 or newer), open **MainAssembly.iam**

-To view the assembly using other CAD packages, open **MainAssembly.stp**