clc
clear all

analytical_h = importdata('analytical_h.txt');
analytical_t = importdata('analytical_t.txt');

correct_smaller = importdata('01correctSmallerDt.txt');
correct_small = importdata('02correctSmallDt.txt');

wrong_smaller = importdata('03wrongLiteratureSmallerDt.txt');
wrong_small = importdata('03wrongLiteratureSmallDt.txt');

wrong_original = importdata('04wrongOriginal.txt');

tmax = 8000;
% t_smaller = analytical_t;
% t_small = 10:10:tmax;
% t_original = 100:100:tmax;

% reduce the number of points to n
n = 10;
dt = tmax / n;
t2 = dt : dt : tmax;

for i=1:n
    correct_smaller2(i) = correct_smaller(i*dt);
    correct_small2(i) = correct_small(i*dt/10);
    wrong_smaller2(i) = wrong_smaller(i*dt);
    wrong_small2(i) = wrong_small(i*dt/10);
    wrong_original2(i) = wrong_original(i*dt/100);
	
    true2(i) = analytical_h(i*dt);
end

% compute thickness
h0 = 0.01e-3;
analytical_s = (h0 - analytical_h) / 2;
correct_smaller_s = (h0 - correct_smaller2) / 2;
correct_small_s = (h0 - correct_small2) / 2;
wrong_smaller_s = (h0 - wrong_smaller2) / 2;
wrong_small_s = (h0 - wrong_small2) / 2;
wrong_original_s = (h0 - wrong_original2) / 2;

true_s = (h0 - true2)/ 2;

% compute error
correct_smaller_error = correct_smaller_s - true_s;
correct_small_error = correct_small_s - true_s;
wrong_smaller_error = wrong_smaller_s - true_s;
wrong_small_error = wrong_small_s - true_s;
wrong_original_error = wrong_original_s - true_s;

%%%%%%%%%%%%% plot errors
p0 = semilogy (t2, (wrong_original_s - true_s) ./  true_s, 'ok', 'markers',8);
hold on
p11 = semilogy (t2, (wrong_small_s - true_s) ./  true_s, 'dr', 'markers',8);
p12 = semilogy (t2, (wrong_smaller_s - true_s) ./  true_s, '+r', 'markers',8);

p21 = semilogy (t2, (correct_small_s - true_s) ./  true_s, 'sb', 'markers',8);
p22 = semilogy (t2, (correct_smaller_s - true_s) ./  true_s, 'xb', 'markers',8);


% p_3=plot(analytical_t, analytical_s, 'linewidth', 1, 'color', 'k');

%%%%%% Axis %%%%%%
xlabel('$t$ (s)','FontSize',20,'Interpreter','latex');
ylabel('Relative error','FontSize',20,'Interpreter','latex');
% ylim([-1 0.1]);
xlim([0 8200]);
set(gca,'FontName','Times New Roman','FontSize',...
    20,'LineWidth',2,'Yscale','log');

%%%%%%% Legend %%%%%%
% legend([p1(1) p2(1) p3(1) p4(1) p5(1) p6(1)], '','','','','FontSize',18,'Interpreter','latex')
% set(legend, 'box', 'off', 'Position', [0.7 0.77 0 0])
% a=axes('position',get(gca,'position'),'visible','off');
% legend(a,[p1(2) p2(2) p3(2) p4(2)], '$\hat{t}=0.5$','$\hat{t}=1$','$\hat{t}=2$','$\hat{t}=5$','FontSize',18,'Interpreter','latex')
% set(legend, 'box', 'off', 'Position', [0.78 0.77 0 0])

% legend('Original, $\delta t = 100$ s','Literature, $\delta t = 10$ s',...
%     'Literature, $\delta t = 1$ s', 'Corrected, $\delta t = 10$ s',...
%     'Corrected, $\delta t = 1$ s', 'FontSize',18,'Interpreter','latex')
% set(legend, 'box', 'off', 'Location', 'Southeast')

%%%%%%%%% Figure %%%%%%%%%%
set(gcf, 'Units', 'centimeters',...
    'Position',[3 4 16 12],... % [left bottom width height]
    'PaperPositionMode', 'auto');
h=gcf;
pos = get(gcf, 'Position');
set(h,'PaperUnits','centimeters', 'PaperSize', pos(3:4));
print(h,'-dpdf', sprintf('./%s.pdf',mfilename));



% color1=[158	202	225]/255;
% color2=[107	174	214]/255;
% color3=[66	146	198]/255;
% color4=[33	113	181]/255;
% color5=[8	69	148]/255;

% color1=[158	202	225]/255;
% color2=[107	174	214]/255;
% color3=[49	130	189]/255;
% color4=[8	81	156]/255;